/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.apt;

import java.util.ArrayList;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import org.reflext.api.AccessScope;
import org.reflext.apt.JavaxLangReflectionModel;
import org.reflext.spi.model.MethodModel;

public class JavaxLangMethodModel
implements MethodModel<Object, ExecutableElement> {
    public Iterable<ExecutableElement> getDeclaredMethods(Object classType) {
        if (classType instanceof TypeElement) {
            TypeElement typeElt = (TypeElement)classType;
            return ElementFilter.methodsIn(typeElt.getEnclosedElements());
        }
        return this.getDeclaredMethods(((DeclaredType)classType).asElement());
    }

    public String getName(ExecutableElement executableElement) {
        return executableElement.getSimpleName().toString();
    }

    public Object getReturnType(ExecutableElement executableElement) {
        return executableElement.getReturnType();
    }

    public Iterable<Object> getParameterTypes(ExecutableElement executableElement) {
        ExecutableType executableType = (ExecutableType)executableElement.asType();
        ArrayList<Object> parameterTypes = new ArrayList<Object>();
        for (TypeMirror typeMirror : executableType.getParameterTypes()) {
            parameterTypes.add(typeMirror);
        }
        return parameterTypes;
    }

    public Iterable<String> getParameterNames(ExecutableElement executableElement) {
        ArrayList<String> names = new ArrayList<String>();
        for (VariableElement variableElement : executableElement.getParameters()) {
            names.add(variableElement.getSimpleName().toString());
        }
        return names;
    }

    public AccessScope getAccess(ExecutableElement executableElement) {
        return JavaxLangReflectionModel.getAccess(executableElement);
    }

    public Iterable<Object> getTypeParameters(ExecutableElement executableElement) {
        ArrayList<Object> typeParameters = new ArrayList<Object>();
        for (TypeParameterElement typeParameterElement : executableElement.getTypeParameters()) {
            typeParameters.add(typeParameterElement.asType());
        }
        return typeParameters;
    }

    public ExecutableElement getGenericDeclaration(Object typeVariable) {
        return (ExecutableElement)((TypeParameterElement)((TypeVariable)typeVariable).asElement()).getGenericElement();
    }

    public Object getOwner(ExecutableElement executableElement) {
        return executableElement.getEnclosingElement();
    }

    public boolean isAbstract(ExecutableElement executableElement) {
        return JavaxLangReflectionModel.isAbstract(executableElement);
    }

    public boolean isStatic(ExecutableElement executableElement) {
        return JavaxLangReflectionModel.isStatic(executableElement);
    }

    public boolean isNative(ExecutableElement executableElement) {
        return JavaxLangReflectionModel.isNative(executableElement);
    }

    public boolean isFinal(ExecutableElement executableElement) {
        return JavaxLangReflectionModel.isFinal(executableElement);
    }

    public Iterable<Object> getThrownTypes(ExecutableElement method) {
        ArrayList<Object> throwTypes = new ArrayList<Object>();
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            throwTypes.add(typeMirror);
        }
        return throwTypes;
    }
}

