/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.chromattic.api.ChromatticSession;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.config.NoSuchDataException;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.CloneApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.PersistentApplicationState;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.importer.Imported;
import org.exoplatform.portal.mop.importer.Status;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.portal.pom.config.POMTask;
import org.exoplatform.portal.pom.config.tasks.Mapper;
import org.exoplatform.portal.pom.config.tasks.PageTask;
import org.exoplatform.portal.pom.config.tasks.PortalConfigTask;
import org.exoplatform.portal.pom.config.tasks.PreferencesTask;
import org.exoplatform.portal.pom.config.tasks.SearchTask;
import org.exoplatform.portal.pom.data.ApplicationData;
import org.exoplatform.portal.pom.data.ModelChange;
import org.exoplatform.portal.pom.data.ModelData;
import org.exoplatform.portal.pom.data.ModelDataStorage;
import org.exoplatform.portal.pom.data.PageData;
import org.exoplatform.portal.pom.data.PageKey;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.common.transaction.JTAUserTransactionLifecycleService;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;
import org.gatein.mop.api.workspace.WorkspaceObject;
import org.gatein.mop.api.workspace.ui.UIComponent;
import org.gatein.mop.api.workspace.ui.UIWindow;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.impl.UnmarshallingContext;

public class POMDataStorage
implements ModelDataStorage {
    private static final Logger log = LoggerFactory.getLogger(POMDataStorage.class);
    private final POMSessionManager pomMgr;
    private ConfigurationManager confManager_;
    private JTAUserTransactionLifecycleService jtaUserTransactionLifecycleService;
    private final ListenerService listenerService;

    public POMDataStorage(final POMSessionManager pomMgr, ConfigurationManager confManager, JTAUserTransactionLifecycleService jtaUserTransactionLifecycleService, ListenerService listenerService) {
        Listener<Object, org.exoplatform.portal.mop.page.PageKey> invalidator = new Listener<Object, org.exoplatform.portal.mop.page.PageKey>(){

            public void onEvent(Event<Object, org.exoplatform.portal.mop.page.PageKey> event) throws Exception {
                org.exoplatform.portal.mop.page.PageKey key = (org.exoplatform.portal.mop.page.PageKey)event.getData();
                PageKey adaptedKey = new PageKey(key.getSite().getTypeName(), key.getSite().getName(), key.getName());
                pomMgr.getSession().scheduleForEviction((Serializable)adaptedKey);
            }
        };
        listenerService.addListener("org.exoplatform.portal.mop.page.page_updated", (Listener)invalidator);
        listenerService.addListener("org.exoplatform.portal.mop.page.page_destroyed", (Listener)invalidator);
        this.pomMgr = pomMgr;
        this.confManager_ = confManager;
        this.jtaUserTransactionLifecycleService = jtaUserTransactionLifecycleService;
        this.listenerService = listenerService;
    }

    public PortalData getPortalConfig(PortalKey key) throws Exception {
        return this.pomMgr.execute(new PortalConfigTask.Load(key));
    }

    public void create(PortalData config) throws Exception {
        this.pomMgr.execute(new PortalConfigTask.Save(config, false));
    }

    public void save(PortalData config) throws Exception {
        this.pomMgr.execute(new PortalConfigTask.Save(config, true));
    }

    public void remove(PortalData config) throws Exception {
        this.pomMgr.execute(new PortalConfigTask.Remove(config.getKey()));
    }

    public PageData getPage(PageKey key) throws Exception {
        return this.pomMgr.execute(new PageTask.Load(key));
    }

    public List<ModelChange> save(PageData page) throws Exception {
        PageTask.Save task = new PageTask.Save(page);
        this.pomMgr.execute(task);
        return task.getChanges();
    }

    public <S> String getId(ApplicationState<S> state) throws Exception {
        String contentId;
        if (state instanceof TransientApplicationState) {
            TransientApplicationState tstate = (TransientApplicationState)state;
            contentId = tstate.getContentId();
        } else if (state instanceof PersistentApplicationState) {
            PersistentApplicationState pstate = (PersistentApplicationState)state;
            contentId = this.pomMgr.execute(new PreferencesTask.GetContentId(pstate.getStorageId()));
        } else if (state instanceof CloneApplicationState) {
            CloneApplicationState cstate = (CloneApplicationState)state;
            contentId = this.pomMgr.execute(new PreferencesTask.GetContentId(cstate.getStorageId()));
        } else {
            throw new AssertionError();
        }
        return contentId;
    }

    public <S> S load(ApplicationState<S> state, ApplicationType<S> type) throws Exception {
        if (type == null || type.getContentType() == null || state == null) {
            return null;
        }
        Class clazz = type.getContentType().getStateClass();
        if (state instanceof TransientApplicationState) {
            TransientApplicationState transientState = (TransientApplicationState)state;
            Object prefs = transientState.getContentState();
            return (S)(prefs != null ? prefs : null);
        }
        if (state instanceof CloneApplicationState) {
            PreferencesTask.Load load = new PreferencesTask.Load(((CloneApplicationState)state).getStorageId(), clazz);
            return this.pomMgr.execute(load);
        }
        PreferencesTask.Load load = new PreferencesTask.Load(((PersistentApplicationState)state).getStorageId(), clazz);
        return this.pomMgr.execute(load);
    }

    public <S> ApplicationState<S> save(ApplicationState<S> state, S preferences) throws Exception {
        if (state instanceof TransientApplicationState) {
            throw new AssertionError((Object)"Does not make sense");
        }
        if (state instanceof PersistentApplicationState) {
            PreferencesTask.Save<S> save = new PreferencesTask.Save<S>(((PersistentApplicationState)state).getStorageId(), preferences);
            this.pomMgr.execute(save);
        } else {
            PreferencesTask.Save<S> save = new PreferencesTask.Save<S>(((CloneApplicationState)state).getStorageId(), preferences);
            this.pomMgr.execute(save);
        }
        return state;
    }

    public <T> LazyPageList<T> find(Query<T> q) throws Exception {
        return this.find(q, null);
    }

    public <T> LazyPageList<T> find(Query<T> q, Comparator<T> sortComparator) throws Exception {
        Class type = q.getClassType();
        if (PageData.class.equals((Object)type)) {
            throw new UnsupportedOperationException("Use PageService.findPages to instead of");
        }
        if (PortletPreferences.class.equals((Object)type)) {
            return this.pomMgr.execute(new SearchTask.FindPortletPreferences((Query<PortletPreferences>)q));
        }
        if (PortalData.class.equals((Object)type)) {
            return this.pomMgr.execute(new SearchTask.FindSite((Query<PortalData>)q));
        }
        if (PortalKey.class.equals((Object)type) && "portal".equals(q.getOwnerType())) {
            return this.pomMgr.execute(new SearchTask.FindSiteKey((Query<PortalKey>)q));
        }
        if (PortalKey.class.equals((Object)type) && "group".equals(q.getOwnerType())) {
            return this.pomMgr.execute(new SearchTask.FindSiteKey((Query<PortalKey>)q));
        }
        throw new UnsupportedOperationException("Could not perform search on query " + q);
    }

    private void generateStorageName(ModelObject obj) {
        if (obj instanceof Container) {
            for (ModelObject child : ((Container)obj).getChildren()) {
                this.generateStorageName(child);
            }
        } else if (obj instanceof Application) {
            obj.setStorageName(UUID.randomUUID().toString());
        }
    }

    public Container getSharedLayout(String siteName) throws Exception {
        String path = null;
        path = StringUtils.isBlank((CharSequence)siteName) ? "war:/conf/portal/portal/sharedlayout.xml" : "war:/conf/portal/portal/sharedlayout-" + siteName + ".xml";
        InputStream inputStream = null;
        try {
            inputStream = this.confManager_.getInputStream(path);
        }
        catch (IOException e) {
            log.debug((Object)("Unable to find file '" + path + "'"), (Throwable)e);
            return this.getSharedLayout(null);
        }
        String out = IOUtil.getStreamContentAsString((InputStream)inputStream);
        ByteArrayInputStream is = new ByteArrayInputStream(out.getBytes("UTF-8"));
        IBindingFactory bfact = BindingDirectory.getFactory(Container.class);
        UnmarshallingContext uctx = (UnmarshallingContext)bfact.createUnmarshallingContext();
        uctx.setDocument((InputStream)is, null, "UTF-8", false);
        Container container = (Container)uctx.unmarshalElement();
        this.generateStorageName((ModelObject)container);
        return container;
    }

    public void save() throws Exception {
        this.pomMgr.execute(new POMTask<Object>(){

            @Override
            public Object run(POMSession session) {
                session.save();
                return null;
            }
        });
    }

    public <A> A adapt(ModelData modelData, Class<A> type) {
        return this.adapt(modelData, type, true);
    }

    public <A> A adapt(ModelData modelData, Class<A> type, boolean create) {
        try {
            POMSession pomSession = this.pomMgr.getSession();
            ChromatticSession chromSession = pomSession.getSession();
            WorkspaceObject o = pomSession.findObjectById(modelData.getStorageId());
            Object a = chromSession.getEmbedded((Object)o, type);
            if (a == null && create) {
                a = chromSession.create(type);
                chromSession.setEmbedded((Object)o, type, a);
            }
            return (A)a;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void syncUserTransactionIfJTAEnabled() {
        try {
            POMSession pomSession;
            if (this.jtaUserTransactionLifecycleService.getUserTransaction().getStatus() == 0 && (pomSession = this.pomMgr.getSession()).isModified()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Active JTA transaction found. Going to sync MOP session and JTA transaction");
                }
                pomSession.save();
                this.jtaUserTransactionLifecycleService.finishJTATransaction();
                this.jtaUserTransactionLifecycleService.beginJTATransaction();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error during sync of JTA transaction", (Throwable)e);
        }
    }

    public String[] getSiteInfo(String workspaceObjectId) throws Exception {
        POMSession session = this.pomMgr.getSession();
        WorkspaceObject workspaceObject = session.findObjectById(workspaceObjectId);
        if (workspaceObject instanceof UIComponent) {
            Site site = ((UIComponent)workspaceObject).getPage().getSite();
            ObjectType siteType = site.getObjectType();
            String[] siteInfo = new String[2];
            if (siteType == ObjectType.PORTAL_SITE) {
                siteInfo[0] = PortalConfig.PORTAL_TYPE;
            } else if (siteType == ObjectType.GROUP_SITE) {
                siteInfo[0] = PortalConfig.GROUP_TYPE;
            } else if (siteType == ObjectType.USER_SITE) {
                siteInfo[0] = PortalConfig.USER_TYPE;
            }
            siteInfo[1] = site.getName();
            return siteInfo;
        }
        throw new Exception("The provided ID is not associated with an application");
    }

    public <S> ApplicationData<S> getApplicationData(String applicationStorageId) {
        POMSession session = this.pomMgr.getSession();
        WorkspaceObject workspaceObject = session.findObjectById(applicationStorageId);
        if (workspaceObject instanceof UIWindow) {
            UIWindow application = (UIWindow)workspaceObject;
            Mapper mapper = new Mapper(session);
            ApplicationData data = mapper.load(application);
            return data;
        }
        throw new NoSuchDataException("Could not load the application data specified by the ID: " + applicationStorageId);
    }

    public Status getImportStatus() {
        POMSession session = this.pomMgr.getSession();
        Workspace workspace = session.getWorkspace();
        Imported imported = (Imported)workspace.adapt(Imported.class);
        Integer st = imported.getStatus();
        if (st != null) {
            Status status = Status.getStatus((int)st);
            return status;
        }
        return null;
    }

    public void saveImportStatus(Status status) {
        POMSession session = this.pomMgr.getSession();
        Workspace workspace = session.getWorkspace();
        Imported imported = (Imported)workspace.adapt(Imported.class);
        if (imported.getCreationDate() == null) {
            imported.setCreationDate(new Date());
        }
        imported.setLastModificationDate(new Date());
        imported.setStatus(status.status());
        session.save();
    }
}

