/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.config.cache;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMTask;
import org.exoplatform.portal.pom.config.TaskExecutionDecorator;
import org.exoplatform.portal.pom.config.TaskExecutor;
import org.exoplatform.portal.pom.config.cache.CacheableDataTask;
import org.exoplatform.portal.pom.config.cache.NullObject;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class DataCache
extends TaskExecutionDecorator {
    private final Logger log = LoggerFactory.getLogger(DataCache.class);
    private final AtomicLong readCount = new AtomicLong();
    private boolean cluster = ExoContainer.hasProfile((String)"cluster");

    public DataCache(TaskExecutor next) {
        super(next);
    }

    @Override
    public <V> V execute(POMSession session, POMTask<V> task) throws Exception {
        if (task instanceof CacheableDataTask) {
            CacheableDataTask loadTask = (CacheableDataTask)task;
            switch (loadTask.getAccessMode()) {
                case READ: {
                    return this.read(session, loadTask);
                }
                case CREATE: {
                    return this.create(session, loadTask);
                }
                case WRITE: {
                    return this.write(session, loadTask);
                }
                case DESTROY: {
                    return this.remove(session, loadTask);
                }
            }
            throw new UnsupportedOperationException();
        }
        return super.execute(session, task);
    }

    private <K extends Serializable, V> V remove(POMSession session, CacheableDataTask<K, V> task) throws Exception {
        K key = task.getKey();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Schedule " + key + " for eviction"));
        }
        session.scheduleForEviction((Serializable)key);
        return super.execute(session, task);
    }

    private <K extends Serializable, V> V write(POMSession session, CacheableDataTask<K, V> task) throws Exception {
        K key = task.getKey();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Schedule " + key + " for eviction"));
        }
        session.scheduleForEviction((Serializable)key);
        return super.execute(session, task);
    }

    private <K extends Serializable, V> V create(POMSession session, CacheableDataTask<K, V> task) throws Exception {
        K key = task.getKey();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Schedule " + key + " for eviction"));
        }
        session.scheduleForEviction((Serializable)key);
        return super.execute(session, task);
    }

    private <K extends Serializable, V> V read(POMSession session, CacheableDataTask<K, V> task) throws Exception {
        K key = task.getKey();
        if (!session.isModified()) {
            Object o = session.getFromCache((Serializable)key);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Retrieved " + o + " for key " + key));
            }
            V v = null;
            if (o != null) {
                if (o == NullObject.get()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"Returning null as found null object marker");
                    }
                    return null;
                }
                Class<V> type = task.getValueType();
                if (type.isInstance(o)) {
                    v = type.cast(o);
                } else {
                    this.log.error((Object)("Object " + o + " was not of the expected type " + type));
                }
            }
            if (v != null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Returning object " + v + " for key " + key));
                }
                return v;
            }
            this.readCount.incrementAndGet();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Object not found in cache for key " + key + " about to retrieve it"));
            }
            v = super.execute(session, task);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Retrieved object " + v + " key " + key + " that will be returned"));
            }
            if (!session.isModified()) {
                if (v == null) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Updating cache with null object for key " + key));
                    }
                    session.putInCache((Serializable)key, NullObject.get());
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Updating cache with object " + v + " for key " + key));
                    }
                    session.putInCache((Serializable)key, v);
                }
            }
            return v;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Session was modified, object for key " + key + " is directly retrieved"));
        }
        return super.execute(session, task);
    }

    public long getReadCount() {
        return this.readCount.longValue();
    }
}

