/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.impl.WikiScannerUtil;

public class WikiParameters
implements Iterable<WikiParameter> {
    public static final char DEFAULT_ESCAPECHAR = '\\';
    public static final WikiParameters EMPTY = new WikiParameters();
    private static final long serialVersionUID = 1253393289284318413L;
    protected final List<WikiParameter> fList = new ArrayList<WikiParameter>();
    private Map<String, WikiParameter[]> fMap;
    private String fStr;

    public static WikiParameters newWikiParameters(String str) {
        return WikiParameters.newWikiParameters(str, '\\');
    }

    public static WikiParameters newWikiParameters(String str, char escapeChar) {
        if (str == null) {
            return EMPTY;
        }
        if ("".equals(str = str.trim())) {
            return EMPTY;
        }
        return new WikiParameters(str, escapeChar);
    }

    public WikiParameters() {
    }

    public WikiParameters(Collection<WikiParameter> list) {
        this.fList.addAll(list);
    }

    public WikiParameters(String str) {
        WikiScannerUtil.splitToPairs(str, this.fList);
    }

    public WikiParameters(String str, char escapeChar) {
        WikiScannerUtil.splitToPairs(str, this.fList, escapeChar);
    }

    public WikiParameters(String str, String delimiter) {
        WikiScannerUtil.splitToPairs(str, this.fList, delimiter);
    }

    public WikiParameters(WikiParameters parameters) {
        this.fList.addAll(parameters.fList);
    }

    public WikiParameters addParameter(String key, String value) {
        WikiParameters result = new WikiParameters();
        result.fList.addAll(this.fList);
        result.fList.add(new WikiParameter(key, value));
        return result;
    }

    public WikiParameters addParameters(WikiParameters parameters) {
        WikiParameters result = new WikiParameters();
        result.fList.addAll(this.fList);
        result.fList.addAll(parameters.fList);
        return result;
    }

    public WikiParameters setParameter(String key, String value) {
        return this.remove(key).addParameter(key, value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WikiParameters)) {
            return false;
        }
        WikiParameters params = (WikiParameters)obj;
        return ((Object)this.fList).equals(params.fList);
    }

    public WikiParameter getParameter(int pos) {
        return pos < 0 || pos >= this.fList.size() ? null : this.fList.get(pos);
    }

    public WikiParameter getParameter(String key) {
        WikiParameter[] list = this.getParameters(key);
        return list != null ? list[0] : null;
    }

    private Map<String, WikiParameter[]> getParameters() {
        if (this.fMap == null) {
            this.fMap = new HashMap<String, WikiParameter[]>();
            for (WikiParameter param : this.fList) {
                String key = param.getKey();
                WikiParameter[] list = this.fMap.get(key);
                int len = list != null ? list.length : 0;
                WikiParameter[] newList = new WikiParameter[len + 1];
                if (len > 0) {
                    System.arraycopy(list, 0, newList, 0, len);
                }
                newList[len] = param;
                this.fMap.put(key, newList);
            }
        }
        return this.fMap;
    }

    public WikiParameter[] getParameters(String key) {
        Map<String, WikiParameter[]> map = this.getParameters();
        WikiParameter[] list = map.get(key);
        return list;
    }

    public int getSize() {
        return this.fList.size();
    }

    public int hashCode() {
        return ((Object)this.fList).hashCode();
    }

    @Override
    public Iterator<WikiParameter> iterator() {
        return this.fList.iterator();
    }

    public WikiParameters remove(String key) {
        int pos = 0;
        for (WikiParameter param : this.fList) {
            if (key.equals(param.getKey())) break;
            ++pos;
        }
        WikiParameters result = this;
        if (pos < this.fList.size()) {
            result = new WikiParameters(this.fList);
            result.fList.remove(pos);
        }
        return result;
    }

    public List<WikiParameter> toList() {
        ArrayList<WikiParameter> result = new ArrayList<WikiParameter>(this.fList);
        return result;
    }

    public String toString() {
        if (this.fStr == null) {
            StringBuffer buf = new StringBuffer();
            int len = this.fList.size();
            int counter = 0;
            for (int i = 0; i < len; ++i) {
                WikiParameter pair = this.fList.get(i);
                if (!pair.isValid()) continue;
                buf.append(" ");
                buf.append(pair);
                ++counter;
            }
            this.fStr = buf.toString();
        }
        return this.fStr;
    }
}

