/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.apt;

import java.util.Map;
import org.chromattic.apt.PackageNameIterator;
import org.reflext.api.ClassTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PackageMetaData {
    final String packageName;
    final Map<String, String> prefixMappings;
    final boolean deep;

    public PackageMetaData(String packageName, Map<String, String> prefixMappings, boolean deep) {
        this.packageName = packageName;
        this.prefixMappings = prefixMappings;
        this.deep = deep;
    }

    int distance(ClassTypeInfo cti) {
        int distance;
        if (this.deep) {
            if (cti.getPackageName().startsWith(this.packageName)) {
                distance = 0;
                for (String packageName : PackageNameIterator.with(cti.getPackageName())) {
                    if (!cti.getPackageName().equals(packageName)) {
                        ++distance;
                        continue;
                    }
                    break;
                }
            } else {
                distance = -1;
            }
        } else {
            distance = cti.getPackageName().equals(this.packageName) ? 0 : -1;
        }
        return distance;
    }
}

