/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.description;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.description.CacheKey;

public class CacheValue
implements Serializable {
    private static final long serialVersionUID = 1187065465332781105L;
    public static final CacheValue NULL_VALUE = new CacheValue();
    private static final AtomicLong SEQUENCE = new AtomicLong();
    final CacheKey origin;
    final long serial;
    final State state;

    private CacheValue() {
        this.state = null;
        this.serial = 0L;
        this.origin = null;
    }

    public CacheValue(CacheKey origin, long serial, State state) {
        this.origin = origin;
        this.serial = serial;
        this.state = state;
    }

    public CacheValue(State state) {
        this.origin = null;
        this.serial = SEQUENCE.incrementAndGet();
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheValue)) {
            return false;
        }
        CacheValue that = (CacheValue)o;
        if (this.serial != that.serial) {
            return false;
        }
        return this.origin != null ? this.origin.equals(that.origin) : that.origin == null;
    }

    public int hashCode() {
        int result = this.origin != null ? this.origin.hashCode() : 0;
        result = 31 * result + (int)(this.serial ^ this.serial >>> 32);
        return result;
    }
}

