/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.typegen;

import java.util.ArrayList;
import java.util.List;
import org.chromattic.metamodel.mapping.jcr.PropertyDefinitionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDefinition {
    private final String name;
    private final boolean multiple;
    private final int type;
    private List<String> defaultValues;
    private List<String> valueConstraints;

    PropertyDefinition(String name, boolean multiple, int type) {
        this.name = name;
        this.multiple = multiple;
        this.type = type;
        this.defaultValues = null;
        this.valueConstraints = null;
    }

    PropertyDefinition(PropertyDefinitionMapping<?> mapping, boolean multiple) {
        List<String> defaultValues = mapping.getDefaultValue();
        defaultValues = defaultValues == null ? null : new ArrayList<String>(defaultValues);
        this.multiple = multiple;
        this.name = mapping.getName();
        this.type = mapping.getMetaType().getCode();
        this.defaultValues = defaultValues;
        this.valueConstraints = null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public int getType() {
        return this.type;
    }

    public List<String> getDefaultValues() {
        return this.defaultValues;
    }

    public List<String> getValueConstraints() {
        return this.valueConstraints;
    }

    void addValueConstraint(String valueConstraint) {
        if (this.valueConstraints == null) {
            this.valueConstraints = new ArrayList<String>();
        }
        this.valueConstraints.add(valueConstraint);
    }
}

