/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.migration;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.application.registry.impl.ApplicationRegistryServiceImpl;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.jdbc.migration.MigrationContext;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AppRegistryMigrationService {
    public static final String EVENT_LISTENER_KEY = "PORTAL_APPLICATIONS_MIGRATION";
    private static final Log LOG = ExoLogger.getExoLogger(AppRegistryMigrationService.class);
    private ApplicationRegistryService appService;
    private ApplicationRegistryServiceImpl jcrAppService;
    private ListenerService listenerService;
    private List<ApplicationCategory> data;

    public AppRegistryMigrationService(ApplicationRegistryService appService, ApplicationRegistryServiceImpl jcrAppService, ListenerService listenerService) {
        this.appService = appService;
        this.jcrAppService = jcrAppService;
        this.listenerService = listenerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMigration() {
        long t = System.currentTimeMillis();
        LOG.info((Object)"| \\ START::Application Categories migration ---------------------------------");
        List<ApplicationCategory> categories = this.getAppCategory();
        if (categories == null || categories.isEmpty()) {
            MigrationContext.setAppDone();
            return;
        }
        for (ApplicationCategory category : categories) {
            if (MigrationContext.isForceStop()) break;
            long t1 = System.currentTimeMillis();
            try {
                ApplicationCategory created = this.appService.getApplicationCategory(category.getName());
                if (created == null) {
                    LOG.info("|  \\ START::migrate category {}", new Object[]{category.getName()});
                    for (Application app : category.getApplications()) {
                        if (app == null || !ApplicationType.PORTLET.equals(app.getType())) continue;
                        this.appService.save(category, app);
                    }
                    this.broadcastListener(category, category.getName());
                    LOG.info("|  / END::migrate category {} in {}ms", new Object[]{category.getName(), System.currentTimeMillis() - t1});
                    continue;
                }
                LOG.info("|  / IGNORE::already existing category {} in {}ms", new Object[]{category.getName(), System.currentTimeMillis() - t1});
            }
            catch (Exception ex) {
                LOG.error("|  / END::migrate category {} in {}ms", new Object[]{category.getName(), System.currentTimeMillis() - t1, ex});
            }
            finally {
                MigrationContext.restartTransaction();
            }
        }
        MigrationContext.setAppDone();
        LOG.info("| / END::Category migration in {}ms", new Object[]{System.currentTimeMillis() - t});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemove() {
        LOG.info((Object)"| \\ START::cleanup Application Categories ---------------------------------");
        long t = System.currentTimeMillis();
        List<ApplicationCategory> categories = this.getAppCategory();
        if (categories.isEmpty()) {
            MigrationContext.setAppCleanupDone();
            return;
        }
        for (ApplicationCategory category : categories) {
            LOG.info("|  \\ START::cleanup Category number: {} ({} category)", new Object[]{category.getName()});
            try {
                this.jcrAppService.remove(category);
                LOG.info("|  \\ END::cleanup Category {}", new Object[]{category.getName()});
            }
            catch (Exception ex) {
                LOG.error("|  \\ END::cleanup Category {}", new Object[]{category.getName(), ex});
            }
            finally {
                MigrationContext.restartTransaction();
            }
        }
        LOG.info("| / END::cleanup Application categories in {}ms", new Object[]{System.currentTimeMillis() - t});
        MigrationContext.setAppCleanupDone();
    }

    protected String getListenerKey() {
        return EVENT_LISTENER_KEY;
    }

    private List<ApplicationCategory> getAppCategory() {
        if (this.data == null) {
            this.data = new ArrayList<ApplicationCategory>();
            try {
                this.data.addAll(this.jcrAppService.getApplicationCategories());
            }
            catch (Exception e) {
                LOG.error((Object)"Can't load application categories", (Throwable)e);
            }
        }
        return this.data;
    }

    protected void broadcastListener(Object t, String newId) {
        try {
            this.listenerService.broadcast(new Event(this.getListenerKey(), t, (Object)newId));
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to broadcast event", (Throwable)e);
        }
    }
}

