/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.chromattic.api.UndeclaredRepositoryException;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.navigation.ExoDataCache;
import org.exoplatform.portal.mop.navigation.InvalidationBridge;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NavigationServiceImpl;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.navigation.SimpleDataCache;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.listener.ListenerService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.mop.api.workspace.Navigation;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Site;
import org.picocontainer.Startable;

public class NavigationServiceWrapper
implements NavigationService,
Startable {
    private static final Logger log = LoggerFactory.getLogger(NavigationServiceWrapper.class);
    private final NavigationServiceImpl service;
    private final ListenerService listenerService;
    private final POMSessionManager manager;
    private final RepositoryService repositoryService;
    private final InvalidationBridge bridge;

    public NavigationServiceWrapper(RepositoryService repositoryService, POMSessionManager manager, ListenerService listenerService) {
        SimpleDataCache cache = new SimpleDataCache();
        this.repositoryService = repositoryService;
        this.manager = manager;
        this.service = new NavigationServiceImpl(manager, cache);
        this.listenerService = listenerService;
        this.bridge = new InvalidationBridge(cache);
    }

    public NavigationServiceWrapper(RepositoryService repositoryService, POMSessionManager manager, ListenerService listenerService, CacheService cacheService) {
        ExoDataCache cache = new ExoDataCache(cacheService);
        this.repositoryService = repositoryService;
        this.manager = manager;
        this.service = new NavigationServiceImpl(manager, cache);
        this.listenerService = listenerService;
        this.bridge = new InvalidationBridge(cache);
    }

    public NavigationContext loadNavigation(SiteKey key) {
        return this.service.loadNavigation(key);
    }

    public List<NavigationContext> loadNavigations(SiteType type) throws NullPointerException, NavigationServiceException {
        return this.service.loadNavigations(type);
    }

    public void saveNavigation(NavigationContext navigation) throws NullPointerException, NavigationServiceException {
        boolean created = navigation.data == null;
        this.service.saveNavigation(navigation);
        if (created) {
            this.notify("org.exoplatform.portal.mop.navigation.navigation_created", navigation.key);
        } else {
            this.notify("org.exoplatform.portal.mop.navigation.navigation_updated", navigation.key);
        }
    }

    public boolean destroyNavigation(NavigationContext navigation) throws NullPointerException, NavigationServiceException {
        boolean destroyed = this.service.destroyNavigation(navigation);
        if (destroyed) {
            this.notify("org.exoplatform.portal.mop.navigation.navigation_destroyed", navigation.key);
        }
        return destroyed;
    }

    public <N> NodeContext<N> loadNode(NodeModel<N> model, NavigationContext navigation, Scope scope, NodeChangeListener<NodeContext<N>> listener) {
        return this.service.loadNode(model, navigation, scope, listener);
    }

    public <N> void saveNode(NodeContext<N> context, NodeChangeListener<NodeContext<N>> listener) throws NavigationServiceException {
        this.service.saveNode(context, listener);
        Navigation nav = (Navigation)this.service.manager.getSession().findObjectById(ObjectType.NAVIGATION, context.data.id);
        Site site = nav.getSite();
        SiteKey key = new SiteKey(Utils.siteType((ObjectType)site.getObjectType()), site.getName());
        this.notify("org.exoplatform.portal.mop.navigation.navigation_updated", key);
    }

    public <N> void updateNode(NodeContext<N> context, Scope scope, NodeChangeListener<NodeContext<N>> listener) throws NullPointerException, NavigationServiceException {
        this.service.updateNode(context, scope, listener);
    }

    public <N> void rebaseNode(NodeContext<N> context, Scope scope, NodeChangeListener<NodeContext<N>> listener) throws NullPointerException, NavigationServiceException {
        this.service.rebaseNode(context, scope, listener);
    }

    private void notify(String name, SiteKey key) {
        try {
            this.listenerService.broadcast(name, (Object)this, (Object)key);
        }
        catch (Exception e) {
            log.error((Object)("Error when delivering notification " + name + " for navigation " + key), (Throwable)e);
        }
    }

    public void start() {
        Session session = null;
        try {
            String workspaceName = this.manager.getLifeCycle().getWorkspaceName();
            ManageableRepository repo = this.repositoryService.getCurrentRepository();
            session = repo.getSystemSession(workspaceName);
            this.bridge.start(session);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public void stop() {
        this.bridge.stop();
    }

    public void clearCache() {
        this.service.clearCache();
    }
}

