/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.migration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang3.StringUtils;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.jdbc.migration.AppReferencesMigrationService;
import org.exoplatform.portal.jdbc.migration.MigrationContext;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.pom.config.POMDataStorage;
import org.exoplatform.portal.pom.data.ApplicationData;
import org.exoplatform.portal.pom.data.BodyData;
import org.exoplatform.portal.pom.data.ComponentData;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.ModelDataStorage;
import org.exoplatform.portal.pom.data.PageData;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbstractMigrationService {
    protected static final String LIMIT_THRESHOLD_KEY = "LIMIT_THRESHOLD";
    protected static final String DEFAULT_WORKSPACE_NAME = "portal-system";
    protected static final BaseEncodingObjectFormatter formatter = new BaseEncodingObjectFormatter();
    protected final Log log;
    protected int limitThreshold = 10;
    protected final POMDataStorage pomStorage;
    protected final ModelDataStorage modelStorage;
    protected final ListenerService listenerService;
    protected final RepositoryService repoService;
    protected final AppReferencesMigrationService appReferencesMigrationService;
    protected final SettingService settingService;
    protected String workspaceName;

    public AbstractMigrationService(InitParams initParams, POMDataStorage pomDataStorage, ModelDataStorage modelStorage, ListenerService listenerService, RepositoryService repoService, SettingService settingService, AppReferencesMigrationService appReferencesMigrationService) {
        this.pomStorage = pomDataStorage;
        this.modelStorage = modelStorage;
        this.listenerService = listenerService;
        this.repoService = repoService;
        this.settingService = settingService;
        this.appReferencesMigrationService = appReferencesMigrationService;
        this.log = ExoLogger.getLogger((String)this.getClass().getName());
        this.workspaceName = this.getString(initParams, "workspace", DEFAULT_WORKSPACE_NAME);
        this.limitThreshold = this.getInteger(initParams, LIMIT_THRESHOLD_KEY, 1);
    }

    public void addMigrationListener(Listener<Object, String> listener) {
        this.listenerService.addListener(this.getListenerKey(), listener);
    }

    protected void broadcastListener(Object t, String newId) {
        try {
            this.listenerService.broadcast(new Event(this.getListenerKey(), t, (Object)newId));
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to broadcast event", (Throwable)e);
        }
    }

    protected int getInteger(InitParams params, String key, int defaultValue) {
        try {
            return Integer.valueOf(params.getValueParam(key).getValue());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected String getString(InitParams params, String key, String defaultValue) {
        try {
            return params.getValueParam(key).getValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected String getProperty(Node node, String propName) {
        try {
            return node.getProperty(propName).getString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected String[] getProperties(Node node, String propName) {
        LinkedList<String> values = new LinkedList<String>();
        try {
            for (Value val : node.getProperty(propName).getValues()) {
                values.add(val.getString());
            }
            return values.toArray(new String[values.size()]);
        }
        catch (Exception ex) {
            this.log.warn("Error reading property '{}' of node {}", new Object[]{propName, node, ex});
            return new String[0];
        }
    }

    protected ContainerData migrateContainer(ContainerData containerData) {
        List<ComponentData> children = this.migrateComponents(containerData.getChildren());
        return new ContainerData(null, containerData.getId(), containerData.getName(), containerData.getIcon(), containerData.getTemplate(), containerData.getFactoryId(), containerData.getTitle(), containerData.getDescription(), containerData.getWidth(), containerData.getHeight(), containerData.getAccessPermissions(), containerData.getMoveAppsPermissions(), containerData.getMoveContainersPermissions(), children);
    }

    protected <S> ApplicationData<S> migrateApplication(ApplicationData<S> app) {
        if (StringUtils.isBlank((CharSequence)app.getStorageId())) {
            throw new IllegalStateException("Unexpected empty application storage id");
        }
        ApplicationData applicationData = this.pomStorage.getApplicationData(app.getStorageId());
        try {
            Object s = this.pomStorage.load(applicationData.getState(), applicationData.getType());
            String contentId = this.pomStorage.getId(app.getState());
            if (this.appReferencesMigrationService.isApplicationToModify(contentId)) {
                String newContentId;
                contentId = newContentId = this.appReferencesMigrationService.modifyApplicationReference(contentId);
            } else if (this.appReferencesMigrationService.isApplicationToRemove(contentId)) {
                this.log.info("Remove application instance '{}' that has been removed", new Object[]{contentId});
                return null;
            }
            TransientApplicationState migrated = new TransientApplicationState(contentId, s);
            return new ApplicationData(null, app.getStorageName(), app.getType(), (ApplicationState)migrated, app.getId(), app.getTitle(), app.getIcon(), app.getDescription(), app.isShowInfoBar(), app.isShowApplicationState(), app.isShowApplicationMode(), app.getTheme(), app.getWidth(), app.getHeight(), app.getProperties(), app.getAccessPermissions());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to retrieve data of application with storage id " + app.getStorageId(), e);
        }
    }

    protected BodyData migrateBodyData(BodyData body) {
        return new BodyData(null, body.getType());
    }

    protected PageData migratePageData(PageData page) {
        List<ComponentData> children = this.migrateComponents(page.getChildren());
        return new PageData(null, page.getId(), page.getName(), page.getIcon(), page.getTemplate(), page.getFactoryId(), page.getTitle(), page.getDescription(), page.getWidth(), page.getHeight(), page.getAccessPermissions(), children, page.getOwnerType(), page.getOwnerId(), page.getEditPermission(), page.isShowMaxWindow(), page.getMoveAppsPermissions(), page.getMoveContainersPermissions());
    }

    protected List<ComponentData> migrateComponents(List<ComponentData> list) {
        ArrayList<ComponentData> result = new ArrayList<ComponentData>();
        for (ComponentData comp : list) {
            ApplicationData application;
            if (comp instanceof ContainerData) {
                result.add((ComponentData)this.migrateContainer((ContainerData)comp));
                continue;
            }
            if (comp instanceof PageData) {
                result.add((ComponentData)this.migratePageData((PageData)comp));
                continue;
            }
            if (comp instanceof BodyData) {
                result.add((ComponentData)this.migrateBodyData((BodyData)comp));
                continue;
            }
            if (!(comp instanceof ApplicationData) || (application = this.migrateApplication((ApplicationData)comp)) == null) continue;
            result.add((ComponentData)application);
        }
        return result;
    }

    protected List<PortalKey> getSitesToMigrate() {
        List<Object> portalKeys = MigrationContext.getSitesToMigrate();
        if (portalKeys != null) {
            return portalKeys;
        }
        portalKeys = Collections.synchronizedList(new LinkedList());
        long t1 = System.currentTimeMillis();
        this.log.info((Object)"  \\ START::COMPUTE site keys to migrate");
        this.findSites(portalKeys, SiteType.PORTAL);
        int portalSitesCount = portalKeys.size();
        this.log.info("  --- {} PORTAL sites to migrate", new Object[]{portalSitesCount});
        MigrationContext.restartTransaction();
        this.findSites(portalKeys, SiteType.GROUP);
        int groupSitesCount = portalKeys.size() - portalSitesCount;
        this.log.info("  --- {} GROUP sites to migrate", new Object[]{groupSitesCount});
        MigrationContext.restartTransaction();
        this.findSites(portalKeys, SiteType.USER);
        int userSitesCount = portalKeys.size() - portalSitesCount - groupSitesCount;
        this.log.info("  --- {} USER sites to migrate", new Object[]{userSitesCount});
        MigrationContext.restartTransaction();
        MigrationContext.setSitesToMigrate(portalKeys);
        this.log.info("  / END::COMPUTE site keys to migrate in {}ms", new Object[]{System.currentTimeMillis() - t1});
        return portalKeys;
    }

    protected void findSites(List<PortalKey> portalKeys, SiteType type) {
        long offset = 0L;
        long limit = this.limitThreshold;
        boolean hasNext = false;
        do {
            if (MigrationContext.isForceStop()) {
                this.log.info((Object)"|  \\ STOPPING migration (server terminated)");
                break;
            }
            hasNext = this.findSites(portalKeys, type, offset, limit);
            offset += limit;
        } while (hasNext);
    }

    protected boolean findSites(List<PortalKey> portalKeys, SiteType type, long offset, long limit) {
        HashSet<PortalKey> result = new HashSet<PortalKey>();
        String mopType = "mop:" + type.getName().toLowerCase() + "site";
        try {
            String query = "select * from " + mopType;
            ManageableRepository currentRepository = this.repoService.getCurrentRepository();
            Session session = SessionProvider.createSystemProvider().getSession(this.workspaceName, currentRepository);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query q = queryManager.createQuery(query, "sql");
            if (q instanceof QueryImpl) {
                ((QueryImpl)q).setOffset(offset);
                ((QueryImpl)q).setLimit(limit);
            }
            QueryResult rs = q.execute();
            NodeIterator iterator = rs.getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                String path = node.getPath();
                String siteName = path.substring(path.lastIndexOf(58) + 1);
                siteName = formatter.decodeNodeName(null, siteName);
                result.add(new PortalKey(type.getName().toLowerCase(), siteName));
            }
        }
        catch (RepositoryException ex) {
            this.log.error((Object)"Error while retrieve user portal", (Throwable)ex);
        }
        if (!result.isEmpty()) {
            portalKeys.addAll(result);
        }
        return !result.isEmpty();
    }

    public abstract void doMigrate(PortalKey var1) throws Exception;

    public abstract void doRemove(PortalKey var1) throws Exception;

    protected abstract String getListenerKey();
}

