/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.display.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.rendering.block.XDOM;

@Component
@Singleton
public class DefaultDocumentDisplayer
implements DocumentDisplayer {
    @Inject
    @Named(value="title")
    private DocumentDisplayer titleDisplayer;
    @Inject
    @Named(value="content")
    private DocumentDisplayer contentDisplayer;
    @Inject
    private ComponentManager componentManager;

    @Override
    public XDOM display(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        DocumentDisplayer displayer;
        String syntaxId = document.getSyntax().toIdString();
        if (parameters.isTitleDisplayed()) {
            try {
                displayer = (DocumentDisplayer)this.componentManager.getInstance(DocumentDisplayer.class, "title/" + syntaxId);
            }
            catch (ComponentLookupException e) {
                displayer = this.titleDisplayer;
            }
        } else {
            try {
                displayer = (DocumentDisplayer)this.componentManager.getInstance(DocumentDisplayer.class, "content/" + syntaxId);
            }
            catch (ComponentLookupException e) {
                displayer = this.contentDisplayer;
            }
        }
        return displayer.display(document, parameters);
    }
}

