/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.children;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.rendering.context.MarkupContextManager;
import org.exoplatform.wiki.rendering.macro.children.ChildrenMacroParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component(value="children")
public class ChildrenMacro
extends AbstractMacro<ChildrenMacroParameters> {
    private static final Log log = ExoLogger.getLogger(ChildrenMacro.class);
    private static final String DESCRIPTION = "Display children and descendants of a specific page";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Execution execution;
    @Inject
    private MarkupContextManager markupContextManager;

    public ChildrenMacro() {
        super("Children", DESCRIPTION, ChildrenMacroParameters.class);
        this.setDefaultCategory("Navigation");
    }

    public List<Block> execute(ChildrenMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        RawBlock includePageBlock = new RawBlock("<exo-wiki-children-pages></exo-wiki-children-pages>", Syntax.XHTML_1_0);
        GroupBlock container = new GroupBlock(Arrays.asList(includePageBlock));
        container.setParameter("class", "wiki-children-pages");
        return Collections.singletonList(container);
    }

    public boolean supportsInlineMode() {
        return true;
    }
}

