/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.xml.sax;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xwiki.rendering.wikimodel.IWikiParser;
import org.xwiki.rendering.wikimodel.WikiParserException;
import org.xwiki.rendering.wikimodel.xml.WemTagNotifier;
import org.xwiki.rendering.wikimodel.xml.sax.WemToSax;

public class WemReader
implements XMLReader {
    private ContentHandler fContentHandler;
    private DTDHandler fDTDHandler;
    private EntityResolver fEntityResolver;
    private ErrorHandler fErrorHandler;
    private IWikiParser fParser;
    protected Map<String, Object> fProperties = new HashMap<String, Object>();

    public WemReader(IWikiParser parser) {
        this.fParser = parser;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.fContentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fProperties.get(name);
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        Reader reader = input.getCharacterStream();
        this.parse(reader);
    }

    private void parse(Reader reader) throws SAXException, IOException {
        try {
            WemToSax handler = new WemToSax(this.fContentHandler);
            WemTagNotifier tagNotifier = new WemTagNotifier(handler);
            this.fParser.parse(reader, tagNotifier);
        }
        catch (WikiParserException e) {
            throw new SAXException(e);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(String systemId) throws IOException, SAXException {
        URL url = new URL(systemId);
        InputStream input = url.openStream();
        try {
            InputStreamReader reader = new InputStreamReader(input, "UTF-8");
            this.parse(reader);
        }
        finally {
            input.close();
        }
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.fContentHandler = handler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.fDTDHandler = handler;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.fEntityResolver = resolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.fErrorHandler = handler;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.fProperties.put(name, value);
    }
}

