/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.display.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.display.internal.DisplayConfiguration;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.rendering.block.XDOM;

@Component
@Named(value="configured")
@Singleton
public class ConfiguredDocumentDisplayer
implements DocumentDisplayer {
    @Inject
    private Logger logger;
    @Inject
    private DisplayConfiguration displayConfiguration;
    @Inject
    private ComponentManager componentManager;

    @Override
    public XDOM display(DocumentModelBridge data, DocumentDisplayerParameters parameters) {
        return this.getDocumentDisplayer().display(data, parameters);
    }

    private DocumentDisplayer getDocumentDisplayer() {
        String documentDisplayerHint = this.displayConfiguration.getDocumentDisplayerHint();
        try {
            return (DocumentDisplayer)this.componentManager.getInstance(DocumentDisplayer.class, documentDisplayerHint);
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Failed to lookup document displayer with hint [{}]. Using default document displayer.", (Object)documentDisplayerHint);
            try {
                return (DocumentDisplayer)this.componentManager.getInstance(DocumentDisplayer.class);
            }
            catch (ComponentLookupException ex) {
                throw new RuntimeException("Failed to lookup default document displayer.", ex);
            }
        }
    }
}

