/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ReloadPortalConfigurationMigration
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(ReloadPortalConfigurationMigration.class);
    private UserPortalConfigService userPortalConfigService;
    private static final String OWNER_TYPE = "ownerType";
    private static final String PREDEFINED_OWNER = "predefinedOwner";
    private static final String LOCATION_PARAMETER = "location";
    private static final String IMPORT_MODE = "importMode";
    private static final String OVERRIDE_MODE = "overrideMode";
    String ownerType;
    String predefinedOwner;
    String location;
    String importMode;
    boolean overrideMode = false;

    public ReloadPortalConfigurationMigration(UserPortalConfigService userPortalConfigService, InitParams initParams) {
        super(initParams);
        if (initParams.containsKey((Object)OWNER_TYPE) && !initParams.getValueParam(OWNER_TYPE).getValue().isBlank()) {
            this.ownerType = initParams.getValueParam(OWNER_TYPE).getValue();
        }
        if (initParams.containsKey((Object)PREDEFINED_OWNER) && !initParams.getValueParam(PREDEFINED_OWNER).getValue().isBlank()) {
            this.predefinedOwner = initParams.getValueParam(PREDEFINED_OWNER).getValue();
        }
        if (initParams.containsKey((Object)LOCATION_PARAMETER) && !initParams.getValueParam(LOCATION_PARAMETER).getValue().isBlank()) {
            this.location = initParams.getValueParam(LOCATION_PARAMETER).getValue();
        }
        if (initParams.containsKey((Object)IMPORT_MODE) && !initParams.getValueParam(IMPORT_MODE).getValue().isBlank()) {
            this.importMode = initParams.getValueParam(IMPORT_MODE).getValue();
        }
        if (initParams.containsKey((Object)OVERRIDE_MODE) && !initParams.getValueParam(OVERRIDE_MODE).getValue().isBlank()) {
            this.overrideMode = Boolean.parseBoolean(initParams.getValueParam(OVERRIDE_MODE).getValue());
        }
        this.userPortalConfigService = userPortalConfigService;
    }

    public void processUpgrade(String s, String s1) {
        LOG.info((Object)"Start Upgrade ReloadPortalConfigurationMigration");
        if (this.ownerType == null || this.predefinedOwner == null || this.location == null || this.importMode == null) {
            LOG.error("At least one parameter is null : ownerType={}, predefinedOwner={}, location={}, importMode={}, overrideMode={}", new Object[]{this.ownerType, this.predefinedOwner, this.location, this.importMode, this.overrideMode});
            throw new RuntimeException("An error occurred while applying Upgrade Plugin ReloadPortalConfigurationMigration. Check plugin configuration");
        }
        this.userPortalConfigService.reloadConfig(this.ownerType, this.predefinedOwner, this.location, this.importMode, this.overrideMode);
        LOG.info((Object)"End Upgrade ReloadPortalConfigurationMigration");
    }
}

