/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PagesMigration
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getExoLogger(PagesMigration.class);
    private static final String APPLICATION_CONTENT_IDS = "application.contentIds";
    private static final String OLD_APPLICATION_CONTENT_ID = "old.application.contentId";
    private static final String NEW_APPLICATION_CONTENT_ID = "new.application.contentId";
    private PortalContainer container;
    private EntityManagerService entityManagerService;
    private Map<String, String> applicationReferences;
    private int pagesUpdatedCount;

    public PagesMigration(PortalContainer container, EntityManagerService entityManagerService, InitParams initParams) {
        block3: {
            block2: {
                super(initParams);
                this.applicationReferences = new HashMap<String, String>();
                this.container = container;
                this.entityManagerService = entityManagerService;
                if (!initParams.containsKey((Object)OLD_APPLICATION_CONTENT_ID)) break block2;
                String oldApplicationReference = initParams.getValueParam(OLD_APPLICATION_CONTENT_ID).getValue();
                if (!initParams.containsKey((Object)NEW_APPLICATION_CONTENT_ID)) break block3;
                String newApplicationReference = initParams.getValueParam(NEW_APPLICATION_CONTENT_ID).getValue();
                if (!StringUtils.isNotBlank((CharSequence)oldApplicationReference) || !StringUtils.isNotBlank((CharSequence)newApplicationReference)) break block3;
                this.applicationReferences.put(oldApplicationReference, newApplicationReference);
                break block3;
            }
            if (initParams.containsKey((Object)APPLICATION_CONTENT_IDS)) {
                List values = initParams.getValuesParam(APPLICATION_CONTENT_IDS).getValues();
                for (String value : values) {
                    String[] parts = value.split(":");
                    String oldApplicationReference = parts[0];
                    String newApplicationReference = parts[1];
                    if (!StringUtils.isNotBlank((CharSequence)oldApplicationReference) || !StringUtils.isNotBlank((CharSequence)newApplicationReference)) continue;
                    this.applicationReferences.put(oldApplicationReference, newApplicationReference);
                }
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        int executionCount = previousUpgradePluginExecution == null ? 0 : previousUpgradePluginExecution.getExecutionCount();
        return !this.isExecuteOnlyOnce() || executionCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (this.applicationReferences.isEmpty()) {
            LOG.error("Couldn't process upgrade, the parameter '{}' is mandatory", new Object[]{OLD_APPLICATION_CONTENT_ID});
            return;
        }
        long startupTime = System.currentTimeMillis();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        boolean transactionStarted = false;
        Set<Map.Entry<String, String>> applicationReferencesEntrySet = this.applicationReferences.entrySet();
        for (Map.Entry<String, String> applicationReference : applicationReferencesEntrySet) {
            String oldApplicationReference = applicationReference.getKey().trim();
            String newApplicationReference = applicationReference.getValue().trim();
            LOG.info("Start upgrade of pages with application references '{}' to use application '{}'", new Object[]{oldApplicationReference, newApplicationReference});
            RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
            EntityManager entityManager = this.entityManagerService.getEntityManager();
            try {
                if (!entityManager.getTransaction().isActive()) {
                    entityManager.getTransaction().begin();
                    transactionStarted = true;
                }
                String sqlString = "UPDATE PORTAL_WINDOWS  SET CONTENT_ID = '" + newApplicationReference + "' WHERE CONTENT_ID = '" + oldApplicationReference + "' AND ID > 0;";
                Query nativeQuery = entityManager.createNativeQuery(sqlString);
                this.pagesUpdatedCount = nativeQuery.executeUpdate();
                LOG.info("End upgrade of '{}' pages with application references '{}' to use application '{}'. It took {} ms", new Object[]{this.pagesUpdatedCount, oldApplicationReference, newApplicationReference, System.currentTimeMillis() - startupTime});
                if (!transactionStarted || !entityManager.getTransaction().isActive()) continue;
                entityManager.getTransaction().commit();
                entityManager.clear();
                entityManager.flush();
            }
            catch (Exception e) {
                if (!transactionStarted || !entityManager.getTransaction().isActive() || !entityManager.getTransaction().getRollbackOnly()) continue;
                entityManager.getTransaction().rollback();
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    public int getPagesUpdatedCount() {
        return this.pagesUpdatedCount;
    }
}

