/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.analytics.api.service.StatisticDataProcessorService;
import org.exoplatform.analytics.es.AnalyticsESClient;
import org.exoplatform.analytics.es.AnalyticsIndexingServiceConnector;
import org.exoplatform.commons.search.es.client.ElasticResponse;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class ElasticsearchMigration
extends UpgradeProductPlugin {
    private static final String QUERY_TARGET_INDEX_PARAM = "TARGET_INDEX";
    private static final String QUERY_SOURCE_INDEX_PARAM = "SOURCE_INDEX";
    private static final String QUERY_SOURCE_TYPE_PARAM = "SOURCE_TYPE";
    private static final String REINDEX_URI = "_reindex?require_alias=true&refresh=true";
    private static final Log LOG = ExoLogger.getExoLogger(ElasticsearchMigration.class);
    private static final String SEARCH_INDEX_TYPE_REINDEX_QUERY = "jar:/analytics-index-type-migration.json";
    private static final String SEARCH_INDEX_REINDEX_QUERY = "jar:/analytics-index-migration.json";
    private static final String QUERY_SOURCE_PARAM = "ES5_HOST";
    private static final String QUERY_SOCKET_TIMEOUT_PARAM = "SOCKET_TIMEOUT";
    private static final String QUERY_CONNECTION_TIMEOUT_PARAM = "CONNECT_TIMEOUT";
    private static final String SOURCE_ES_URL_PARAM = "elasticsearch56.url";
    private static final String SOCKET_TIMEOUT_PARAM = "socket.timeout";
    private static final String CONNECTION_TIMEOUT_PARAM = "connection.timeout";
    private static final long DAY_IN_MS = 86400000L;
    private ConfigurationManager configurationManager;
    private AnalyticsESClient analyticsESClient;
    private StatisticDataProcessorService statisticDataProcessorService;
    private AnalyticsIndexingServiceConnector analyticsIndexingConnector;
    private String sourceESUrl;
    private String socketTimeout;
    private String connectionTimeout;
    private String reindexNoTypeQuery;
    private String reindexWithTypeQuery;

    public ElasticsearchMigration(ConfigurationManager configurationManager, AnalyticsESClient analyticsESClient, StatisticDataProcessorService statisticDataProcessorService, AnalyticsIndexingServiceConnector analyticsIndexingConnector, InitParams initParams) {
        super(initParams);
        this.analyticsESClient = analyticsESClient;
        this.statisticDataProcessorService = statisticDataProcessorService;
        this.configurationManager = configurationManager;
        this.analyticsIndexingConnector = analyticsIndexingConnector;
        if (initParams != null) {
            if (initParams.getValueParam(SOURCE_ES_URL_PARAM) != null) {
                this.sourceESUrl = initParams.getValueParam(SOURCE_ES_URL_PARAM).getValue();
            }
            if (initParams.getValueParam(SOCKET_TIMEOUT_PARAM) != null) {
                this.socketTimeout = initParams.getValueParam(SOCKET_TIMEOUT_PARAM).getValue();
            }
            if (initParams.getValueParam(CONNECTION_TIMEOUT_PARAM) != null) {
                this.connectionTimeout = initParams.getValueParam(CONNECTION_TIMEOUT_PARAM).getValue();
            }
        }
    }

    public boolean isEnabled() {
        return StringUtils.isNotBlank((CharSequence)this.sourceESUrl);
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        int executionCount = previousUpgradePluginExecution == null ? 0 : previousUpgradePluginExecution.getExecutionCount();
        return !this.isExecuteOnlyOnce() || executionCount == 0;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        boolean upgraded = true;
        if (this.analyticsESClient.sendIsIndexExistsRequest("profile_alias")) {
            boolean bl = upgraded = this.upgradeIndex("profile_alias", null, "profile_alias") && upgraded;
        }
        if (this.analyticsESClient.sendIsIndexExistsRequest("space_alias")) {
            boolean bl = upgraded = this.upgradeIndex("space_alias", null, "space_alias") && upgraded;
        }
        if (this.analyticsESClient.sendIsIndexExistsRequest("wiki_alias")) {
            boolean bl = upgraded = this.upgradeIndex("wiki_v2", "wiki-page", "wiki_alias") && upgraded;
        }
        if (this.analyticsESClient.sendIsIndexExistsRequest("activity_alias")) {
            boolean bl = upgraded = this.upgradeIndex("activity_alias", null, "activity_alias") && upgraded;
        }
        if (this.analyticsESClient.sendIsIndexExistsRequest("news_alias")) {
            boolean bl = upgraded = this.upgradeIndex("news_alias", null, "news_alias") && upgraded;
        }
        if (this.analyticsESClient.sendIsIndexExistsRequest("event_alias")) {
            boolean bl = upgraded = this.upgradeIndex("event_alias", null, "event_alias") && upgraded;
        }
        if (this.analyticsESClient.sendIsIndexExistsRequest("file_alias")) {
            upgraded = this.upgradeIndex("file_alias", null, "file_alias") && upgraded;
        }
        boolean bl = upgraded = this.upgradeAnalyticsIndices() && upgraded;
        if (!upgraded) {
            throw new IllegalStateException("Elasticsearch upgrade failed due to previous errors");
        }
        LOG.info((Object)"Elasticsearch upgrade proceeded successfully. You can switch off the old Elasticsearch 5.6 !");
    }

    private boolean upgradeIndex(String sourceAnalyticsIndex, String sourceAnalyticsType, String targetAnalyticsIndex) {
        LOG.info("START::Index '{}' from ES5 migration to index '{}' on ES7.", new Object[]{sourceAnalyticsIndex, targetAnalyticsIndex});
        long startTime = System.currentTimeMillis();
        try {
            String esQuery = this.getReindexQuery(StringUtils.isNotBlank((CharSequence)sourceAnalyticsType));
            esQuery = esQuery.replace(QUERY_SOURCE_PARAM, this.sourceESUrl).replace(QUERY_SOCKET_TIMEOUT_PARAM, this.socketTimeout).replace(QUERY_CONNECTION_TIMEOUT_PARAM, this.connectionTimeout).replace(QUERY_SOURCE_INDEX_PARAM, sourceAnalyticsIndex).replace(QUERY_SOURCE_TYPE_PARAM, sourceAnalyticsType == null ? "" : sourceAnalyticsType).replace(QUERY_TARGET_INDEX_PARAM, targetAnalyticsIndex);
            ElasticResponse response = this.analyticsESClient.sendHttpPostRequest(REINDEX_URI, esQuery);
            JSONObject esResponseObject = new JSONObject(response.getMessage());
            long totalObjects = esResponseObject.getLong("total");
            LOG.info("END::Index '{}' migration successfully. The operation took {} milliseconds for '{}' documents.", new Object[]{sourceAnalyticsIndex, System.currentTimeMillis() - startTime, totalObjects});
            return this.checkDocCountCoherence(sourceAnalyticsIndex, sourceAnalyticsType, targetAnalyticsIndex);
        }
        catch (Exception e) {
            LOG.error("Error while migrating index {}", new Object[]{sourceAnalyticsIndex, e});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upgradeAnalyticsIndices() {
        LOG.info((Object)"START::All analytics Indices migration.");
        long startTime = System.currentTimeMillis();
        this.statisticDataProcessorService.pauseProcessor("exo.addon.analytics.processor.es");
        boolean upgraded = true;
        try {
            this.deleteAnalyticsIndices();
            List<String> analyticsIndices = this.getAnalyticsIndices(this.sourceESUrl);
            int analyticsIndicesCount = analyticsIndices.size();
            LOG.info("START::All {} analytics Indices migration.", new Object[]{analyticsIndicesCount});
            String analyticsPrefix = this.analyticsIndexingConnector.getIndexPrefix() + "_";
            for (int i = 0; i < analyticsIndicesCount; ++i) {
                String targetAnalyticsIndex;
                String sourceAnalyticsIndex = analyticsIndices.get(i);
                upgraded = this.upgradeAnalyticsIndex(sourceAnalyticsIndex, targetAnalyticsIndex = this.getAnalyticsTargetIndexName(analyticsPrefix, sourceAnalyticsIndex), i, analyticsIndicesCount) && upgraded;
            }
            LOG.info("END::All {} analytics Indices migration successfully. The operation took {} milliseconds.", new Object[]{analyticsIndicesCount, System.currentTimeMillis() - startTime});
            boolean bl = upgraded;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while migrating all analytics indices", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.statisticDataProcessorService.unpauseProcessor("exo.addon.analytics.processor.es");
        }
    }

    private void deleteAnalyticsIndices() throws JSONException {
        List<String> es7AnalyticsIndices = this.getAnalyticsIndices(null);
        for (String es7AnalyticsIndex : es7AnalyticsIndices) {
            LOG.info("START::Delete automatically created analytics index {} in ES7", new Object[]{es7AnalyticsIndex});
            this.analyticsESClient.sendHttpDeleteRequest(es7AnalyticsIndex);
            LOG.info("END::Delete automatically created analytics index {} in ES7 successfully", new Object[]{es7AnalyticsIndex});
        }
    }

    private boolean upgradeAnalyticsIndex(String sourceAnalyticsIndex, String targetAnalyticsIndex, int i, int analyticsIndicesCount) {
        try {
            LOG.info("START::{} analytics Index creation: {}/{}.", new Object[]{targetAnalyticsIndex, i + 1, analyticsIndicesCount});
            this.analyticsESClient.sendCreateIndexRequest(targetAnalyticsIndex);
            LOG.info("END::{} analytics Index creation: {}/{}.", new Object[]{targetAnalyticsIndex, i + 1, analyticsIndicesCount});
            return this.upgradeIndex(sourceAnalyticsIndex, null, targetAnalyticsIndex);
        }
        catch (Exception e) {
            LOG.info("START::{} analytics Index migration: {}/{}.", new Object[]{targetAnalyticsIndex, i + 1, analyticsIndicesCount});
            return false;
        }
    }

    private List<String> getAnalyticsIndices(String clientUri) throws JSONException {
        ElasticResponse response = this.analyticsESClient.sendHttpGetRequest(clientUri, "analytics*/_mapping");
        JSONObject esResponseObject = new JSONObject(response.getMessage());
        ArrayList<String> analyticsIndices = new ArrayList<String>();
        esResponseObject.keys().forEachRemaining(index -> analyticsIndices.add(index.toString()));
        return analyticsIndices;
    }

    private String getAnalyticsTargetIndexName(String analyticsPrefix, String sourceAnalyticsIndex) {
        String sourceAnalyticsIndexSuffix = sourceAnalyticsIndex.replace(analyticsPrefix, "");
        if (StringUtils.isNumeric((CharSequence)sourceAnalyticsIndexSuffix)) {
            long suffix = Long.parseLong(sourceAnalyticsIndexSuffix);
            long timestamp = suffix * 86400000L * (long)this.analyticsESClient.getIndexPerDays();
            return analyticsPrefix + this.analyticsESClient.getIndexSuffix(timestamp);
        }
        return sourceAnalyticsIndex;
    }

    private String getFileContent(String filePath) throws Exception {
        InputStream mappingFileIS = this.configurationManager.getInputStream(filePath);
        return IOUtil.getStreamContentAsString((InputStream)mappingFileIS);
    }

    private boolean checkDocCountCoherence(String sourceAnalyticsIndex, String sourceAnalyticsType, String targetAnalyticsIndex) throws JSONException {
        this.analyticsESClient.refreshIndex(targetAnalyticsIndex);
        String sourceAnalyticsIndexType = StringUtils.isBlank((CharSequence)sourceAnalyticsType) ? sourceAnalyticsIndex : sourceAnalyticsIndex + "/" + sourceAnalyticsType;
        long sourceCount = this.getDocCount(this.sourceESUrl, sourceAnalyticsIndexType);
        long targetCount = this.getDocCount(null, targetAnalyticsIndex);
        if (targetCount < sourceCount) {
            LOG.error("Check Migrated Doc COUNT Error, detected {} on source index '{}' on ES5 and {} on target index '{}' ES7", new Object[]{sourceCount, sourceAnalyticsIndexType, targetCount, targetAnalyticsIndex});
            return false;
        }
        LOG.info("REPORT::Check Migrated Doc COUNT Success, detected {} on source index '{}' on ES5 and {} on target index '{}' ES7", new Object[]{sourceCount, sourceAnalyticsIndexType, targetCount, targetAnalyticsIndex});
        return true;
    }

    private long getDocCount(String urlClient, String index) throws JSONException {
        ElasticResponse response = this.analyticsESClient.sendHttpGetRequest(urlClient, index + "/_count");
        JSONObject responseObject = new JSONObject(response.getMessage());
        return responseObject.getLong("count");
    }

    public String getReindexQuery(boolean withType) throws Exception {
        if (withType) {
            if (StringUtils.isBlank((CharSequence)this.reindexWithTypeQuery)) {
                this.reindexWithTypeQuery = this.getFileContent(SEARCH_INDEX_TYPE_REINDEX_QUERY);
            }
            return this.reindexWithTypeQuery;
        }
        if (StringUtils.isBlank((CharSequence)this.reindexNoTypeQuery)) {
            this.reindexNoTypeQuery = this.getFileContent(SEARCH_INDEX_REINDEX_QUERY);
        }
        return this.reindexNoTypeQuery;
    }
}

