/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.migration.PortalNavigationIconMigration$AjcClosure1;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PortalNavigationIconMigration
extends UpgradeProductPlugin {
    private static final Log LOG;
    private static final String ICON_UPDATE_SQL = "  UPDATE PORTAL_NAVIGATION_NODES\n  SET ICON =\n    CASE\n      %s\n     ELSE ICON\n    END\n  WHERE EXISTS (SELECT * FROM PORTAL_PAGES p INNER JOIN PORTAL_SITES s ON s.ID = p.SITE_ID WHERE PAGE_ID = p.ID AND s.TYPE = 0)\n";
    private static final String ICON_UPDATE_CASE_SQL = "   WHEN NAME in (%s) THEN TRIM('%s')\n";
    private static final String PORTAL_NODE_NAMES = "portal.node.names";
    private static final String PORTAL_NODE_ICONS = "portal.node.icons";
    private final EntityManagerService entityManagerService;
    private final Map<String, String> portalNodes = new HashMap<String, String>();
    private int migratedPortalNodeIcons;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public PortalNavigationIconMigration(EntityManagerService entityManagerService, InitParams initParams) {
        super(initParams);
        this.entityManagerService = entityManagerService;
        if (initParams.containsKey((Object)PORTAL_NODE_ICONS) && initParams.containsKey((Object)PORTAL_NODE_NAMES)) {
            String[] portalNodeNames = initParams.getValueParam(PORTAL_NODE_NAMES).getValue().split(";");
            String[] portalNodeIcons = initParams.getValueParam(PORTAL_NODE_ICONS).getValue().split(";");
            if (portalNodeIcons.length == portalNodeNames.length) {
                for (int i = 0; i < portalNodeNames.length; ++i) {
                    this.portalNodes.put(portalNodeNames[i], portalNodeIcons[i]);
                }
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return !this.portalNodes.isEmpty();
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        LOG.info((Object)"Start:: Upgrade of portal navigation node icons");
        Set<Map.Entry<String, String>> portalNodesEntrySet = this.portalNodes.entrySet();
        this.migratedPortalNodeIcons = this.upgradePortalNodeIcons(portalNodesEntrySet);
        LOG.info("End:: Upgrade of '{}' node icons. It tooks {} ms", new Object[]{this.migratedPortalNodeIcons, System.currentTimeMillis() - startupTime});
    }

    @ExoTransactional
    public int upgradePortalNodeIcons(Set<Map.Entry<String, String>> portalNodesEntrySet) {
        Set<Map.Entry<String, String>> set = portalNodesEntrySet;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), set);
        Object[] objectArray = new Object[]{this, set, joinPoint};
        PortalNavigationIconMigration$AjcClosure1 portalNavigationIconMigration$AjcClosure1 = new PortalNavigationIconMigration$AjcClosure1(objectArray);
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(portalNavigationIconMigration$AjcClosure1.linkClosureAndJoinPoint(69648)));
    }

    public int getMigratedPortalNodeIconsNodeIcons() {
        return this.migratedPortalNodeIcons;
    }

    static {
        PortalNavigationIconMigration.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(PortalNavigationIconMigration.class);
    }

    static final /* synthetic */ int upgradePortalNodeIcons_aroundBody0(PortalNavigationIconMigration ajc$this, Set portalNodesEntrySet, JoinPoint joinPoint) {
        EntityManager entityManager = ajc$this.entityManagerService.getEntityManager();
        Object sqlStatement = String.format(ICON_UPDATE_SQL, ajc$this.portalNodes.entrySet().stream().map(e -> {
            String keys = Arrays.stream(((String)e.getKey()).split(",")).map(key -> String.format("'%s'", key)).collect(Collectors.joining(","));
            return String.format(ICON_UPDATE_CASE_SQL, keys, e.getValue());
        }).collect(Collectors.joining()));
        sqlStatement = (String)sqlStatement + " AND NAME IN ('" + ajc$this.portalNodes.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.joining("','")) + "')";
        Query query = entityManager.createNativeQuery((String)sqlStatement);
        return query.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PortalNavigationIconMigration.java", PortalNavigationIconMigration.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "upgradePortalNodeIcons", "org.exoplatform.migration.PortalNavigationIconMigration", "java.util.Set", "portalNodesEntrySet", "", "int"), 102);
    }
}

