/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.migration;

import java.util.ArrayList;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.migration.PagesMigration;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.cache.CacheService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.portal-configuration-local.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/portal/config/conf/configuration.xml")})
public class PagesMigrationTest
extends AbstractKernelTest {
    private static final String SITE_TYPE = PortalConfig.PORTAL_TYPE;
    private static final String SITE_NAME = "testSite";
    private static final String PAGE_TO_KEEP_NAME = "page2";
    private static final String PAGE_TO_CHANGE_NAME = "page1";
    protected PortalContainer container;
    protected LayoutService layoutService;
    protected EntityManagerService entityManagerService;
    protected CacheService cacheService;
    protected Page changeThisPage;
    protected Page keepThisPage;
    protected String oldContent = "app/oldApp";
    protected String newContent = "newApp/newApp";

    public PagesMigrationTest() {
        this.setForceContainerReload(true);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.container = this.getContainer();
        this.layoutService = (LayoutService)this.container.getComponentInstanceOfType(LayoutService.class);
        this.entityManagerService = (EntityManagerService)this.container.getComponentInstanceOfType(EntityManagerService.class);
        this.cacheService = (CacheService)this.container.getComponentInstanceOfType(CacheService.class);
        this.begin();
        this.injectData();
        this.restartTransaction();
    }

    @After
    public void tearDown() {
        this.purgeData();
        this.end();
    }

    @Test
    public void testPageMigration() throws Exception {
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("old.application.contentId");
        valueParam.setValue(this.oldContent);
        initParams.addParameter((Parameter)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("new.application.contentId");
        valueParam.setValue(this.newContent);
        initParams.addParameter((Parameter)valueParam);
        Page page = this.layoutService.getPage(new PageKey(SITE_TYPE, SITE_NAME, PAGE_TO_CHANGE_NAME));
        PagesMigrationTest.assertNotNull((Object)page);
        PagesMigrationTest.assertEquals((int)1, (int)page.getChildren().size());
        page.getChildren().get(0);
        Application componentData = (Application)page.getChildren().get(0);
        String contentId = this.layoutService.getId(componentData.getState());
        PagesMigrationTest.assertEquals((String)this.oldContent, (String)contentId);
        page = this.layoutService.getPage(new PageKey(SITE_TYPE, SITE_NAME, PAGE_TO_KEEP_NAME));
        PagesMigrationTest.assertNotNull((Object)page);
        PagesMigrationTest.assertEquals((int)1, (int)page.getChildren().size());
        componentData = (Application)page.getChildren().get(0);
        contentId = this.layoutService.getId(componentData.getState());
        PagesMigrationTest.assertEquals((String)this.newContent, (String)contentId);
        PagesMigration pagesMigration = new PagesMigration(this.container, this.entityManagerService, this.cacheService, initParams);
        PagesMigrationTest.assertEquals((int)0, (int)pagesMigration.getPagesUpdatedCount());
        pagesMigration.processUpgrade(null, null);
        PagesMigrationTest.assertEquals((int)1, (int)pagesMigration.getPagesUpdatedCount());
        PagesMigrationTest.assertTrue((boolean)pagesMigration.shouldProceedToUpgrade("v1", "v1", new UpgradePluginExecutionContext("v1;0")));
        this.restartTransaction();
        page = this.layoutService.getPage(new PageKey(SITE_TYPE, SITE_NAME, PAGE_TO_CHANGE_NAME));
        PagesMigrationTest.assertNotNull((Object)page);
        PagesMigrationTest.assertEquals((int)1, (int)page.getChildren().size());
        componentData = (Application)page.getChildren().get(0);
        contentId = this.layoutService.getId(componentData.getState());
        PagesMigrationTest.assertEquals((String)this.newContent, (String)contentId);
        page = this.layoutService.getPage(new PageKey(SITE_TYPE, SITE_NAME, PAGE_TO_KEEP_NAME));
        PagesMigrationTest.assertNotNull((Object)page);
        PagesMigrationTest.assertEquals((int)1, (int)page.getChildren().size());
        componentData = (Application)page.getChildren().get(0);
        contentId = this.layoutService.getId(componentData.getState());
        PagesMigrationTest.assertEquals((String)this.newContent, (String)contentId);
    }

    protected void injectData() throws Exception {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(SITE_TYPE, SITE_NAME);
        if (portalConfig == null) {
            portalConfig = new PortalConfig(SITE_TYPE, SITE_NAME);
            this.layoutService.create(portalConfig);
        }
        this.changeThisPage = this.createPage(PAGE_TO_CHANGE_NAME, this.oldContent);
        this.keepThisPage = this.createPage(PAGE_TO_KEEP_NAME, this.newContent);
    }

    protected void purgeData() {
        this.layoutService.remove(this.changeThisPage.getPageKey());
        this.layoutService.remove(this.keepThisPage.getPageKey());
    }

    protected void begin() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    protected void end() {
        RequestLifeCycle.end();
    }

    private Page createPage(String pageName, String contentId) throws Exception {
        Page page = new Page(SITE_TYPE, SITE_NAME, pageName);
        page.setAccessPermissions(new String[]{"Everyone"});
        ArrayList<Application> children = new ArrayList<Application>();
        page.setChildren(children);
        Application app = Application.createPortletApplication();
        children.add(app);
        app.setState((ApplicationState)new TransientApplicationState(contentId, null));
        app.setTheme("theme");
        app.setTitle("title");
        app.setAccessPermissions(new String[]{"Everyone"});
        PageState pageState = Utils.toPageState((Page)page);
        this.layoutService.save(new PageContext(page.getPageKey(), pageState), page);
        return page;
    }
}

