/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.binding;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.management.binding.xml.NavigationMarshaller;
import org.exoplatform.portal.mop.management.binding.xml.PageMarshaller;
import org.exoplatform.portal.mop.management.binding.xml.SiteLayoutMarshaller;
import org.gatein.management.api.ContentType;
import org.gatein.management.api.binding.BindingException;
import org.gatein.management.api.binding.BindingProvider;
import org.gatein.management.api.binding.Marshaller;

public class MopBindingProvider
implements BindingProvider {
    public static final MopBindingProvider INSTANCE = new MopBindingProvider();

    private MopBindingProvider() {
    }

    public <T> Marshaller<T> getMarshaller(Class<T> type, ContentType contentType) throws BindingException {
        switch (contentType) {
            case XML: {
                return this.getXmlMarshaller(type);
            }
        }
        return null;
    }

    private <T> Marshaller<T> getXmlMarshaller(Class<T> type) {
        if (Page.class.isAssignableFrom(type)) {
            return XmlMarshallers.page_marshaller;
        }
        if (Page.PageSet.class.isAssignableFrom(type)) {
            return XmlMarshallers.pages_marshaller;
        }
        if (PageNavigation.class.isAssignableFrom(type)) {
            return XmlMarshallers.navigation_marshaller;
        }
        if (PortalConfig.class.isAssignableFrom(type)) {
            return XmlMarshallers.site_marshaller;
        }
        return null;
    }

    private static class XmlMarshallers {
        private static Marshaller<Page.PageSet> pages_marshaller = new PageMarshaller();
        private static Marshaller<Page> page_marshaller = new Marshaller<Page>(){

            public void marshal(Page page, OutputStream outputStream, boolean pretty) throws BindingException {
                Page.PageSet pages = new Page.PageSet();
                pages.setPages(new ArrayList(1));
                pages.getPages().add(page);
                pages_marshaller.marshal((Object)pages, outputStream, pretty);
            }

            public Page unmarshal(InputStream inputStream) throws BindingException {
                Page.PageSet pages = (Page.PageSet)pages_marshaller.unmarshal(inputStream);
                if (pages.getPages().isEmpty()) {
                    throw new BindingException("No page was unmarshalled.");
                }
                if (pages.getPages().size() != 1) {
                    throw new BindingException("Multiple pages found.");
                }
                return (Page)pages.getPages().get(0);
            }
        };
        private static Marshaller<PageNavigation> navigation_marshaller = new NavigationMarshaller();
        private static Marshaller<PortalConfig> site_marshaller = new SiteLayoutMarshaller();

        private XmlMarshallers() {
        }
    }
}

