/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.binding.xml.portal.redirects;

import java.util.ArrayList;
import java.util.Collection;
import org.exoplatform.portal.config.model.PortalRedirect;
import org.exoplatform.portal.mop.management.binding.xml.Element;
import org.exoplatform.portal.mop.management.binding.xml.portal.redirects.ConditionXmlHandler;
import org.exoplatform.portal.mop.management.binding.xml.portal.redirects.RedirectMappingsXmlHandler;
import org.gatein.common.xml.stax.CollectionXmlHandler;
import org.gatein.common.xml.stax.navigator.Exceptions;
import org.gatein.common.xml.stax.navigator.StaxNavUtils;
import org.gatein.common.xml.stax.writer.StaxWriter;
import org.gatein.common.xml.stax.writer.WritableValueTypes;
import org.staxnav.StaxNavigator;
import org.staxnav.ValueType;

public class PortalRedirectXmlHandler
extends CollectionXmlHandler<PortalRedirect, Element> {
    private final ConditionXmlHandler conditionXmlHandler;
    private final RedirectMappingsXmlHandler mappingsXmlHandler;

    public PortalRedirectXmlHandler() {
        this(new ConditionXmlHandler(), new RedirectMappingsXmlHandler());
    }

    public PortalRedirectXmlHandler(ConditionXmlHandler conditionXmlHandler, RedirectMappingsXmlHandler mappingsXmlHandler) {
        super((Object)Element.PORTAL_REDIRECTS, (Object)Element.PORTAL_REDIRECT);
        this.conditionXmlHandler = conditionXmlHandler;
        this.mappingsXmlHandler = mappingsXmlHandler;
    }

    protected PortalRedirect readElement(StaxNavigator<Element> navigator) {
        if (navigator.getName() != Element.PORTAL_REDIRECT) {
            throw Exceptions.expectedElement(navigator, (Object)((Object)Element.PORTAL_REDIRECT));
        }
        PortalRedirect redirect = new PortalRedirect();
        String redirectSite = StaxNavUtils.getRequiredContent((StaxNavigator)StaxNavUtils.child(navigator, (Object)((Object)Element.REDIRECT_SITE)), (boolean)true);
        redirect.setRedirectSite(redirectSite);
        String name = StaxNavUtils.getRequiredContent((StaxNavigator)StaxNavUtils.sibling(navigator, (Object)((Object)Element.NAME)), (boolean)true);
        redirect.setName(name);
        boolean enabled = (Boolean)StaxNavUtils.parseRequiredContent((StaxNavigator)StaxNavUtils.sibling(navigator, (Object)((Object)Element.REDIRECT_ENABLED)), (ValueType)ValueType.BOOLEAN);
        redirect.setEnabled(enabled);
        boolean conditions = false;
        boolean mappings = false;
        block5: while (navigator.sibling() != null) {
            switch ((Element)((Object)navigator.getName())) {
                case CONDITIONS: {
                    if (conditions || mappings) {
                        throw Exceptions.unexpectedElement(navigator);
                    }
                    conditions = true;
                    redirect.setConditions((ArrayList)this.conditionXmlHandler.read(navigator.fork()));
                    continue block5;
                }
                case NODE_MAPPING: {
                    if (mappings) {
                        throw Exceptions.unexpectedElement(navigator);
                    }
                    mappings = true;
                    redirect.setMappings(this.mappingsXmlHandler.read((StaxNavigator<Element>)navigator.fork()));
                    continue block5;
                }
                case UNKNOWN: {
                    throw Exceptions.unknownElement(navigator);
                }
            }
            throw Exceptions.unexpectedElement(navigator);
        }
        return redirect;
    }

    protected void writeElement(StaxWriter<Element> writer, PortalRedirect redirect) {
        if (redirect == null) {
            return;
        }
        writer.writeStartElement((Object)Element.PORTAL_REDIRECT);
        writer.writeElement((Object)Element.REDIRECT_SITE, redirect.getRedirectSite());
        writer.writeElement((Object)Element.NAME, redirect.getName());
        writer.writeElement((Object)Element.REDIRECT_ENABLED, WritableValueTypes.BOOLEAN, (Object)redirect.isEnabled());
        this.conditionXmlHandler.write(writer, redirect.getConditions());
        this.mappingsXmlHandler.write(writer, redirect.getMappings());
        writer.writeEndElement();
    }

    protected Collection<PortalRedirect> createCollection() {
        return new ArrayList<PortalRedirect>();
    }
}

