/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.page;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.commons.serialization.MarshalledObject;
import org.exoplatform.portal.mop.page.DataCache;
import org.exoplatform.portal.mop.page.PageData;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.pom.config.POMSession;

public class SimpleDataCache
extends DataCache {
    protected Map<MarshalledObject<PageKey>, MarshalledObject<PageData>> pages = new ConcurrentHashMap<MarshalledObject<PageKey>, MarshalledObject<PageData>>();

    @Override
    protected PageData getPage(POMSession session, PageKey key) {
        MarshalledObject marshalledKey = MarshalledObject.marshall((Serializable)key);
        MarshalledObject<PageData> marshalledPage = this.pages.get(marshalledKey);
        if (marshalledPage == null) {
            PageData page = this.loadPage(session, key);
            if (page != null) {
                this.pages.put((MarshalledObject<PageKey>)marshalledKey, (MarshalledObject<PageData>)MarshalledObject.marshall((Serializable)page));
                return page;
            }
            return null;
        }
        return (PageData)marshalledPage.unmarshall();
    }

    @Override
    protected void removePage(POMSession session, PageKey key) {
        this.pages.remove(MarshalledObject.marshall((Serializable)key));
    }

    @Override
    protected void putPage(PageData data) {
        this.pages.put((MarshalledObject<PageKey>)MarshalledObject.marshall((Serializable)data.key), (MarshalledObject<PageData>)MarshalledObject.marshall((Serializable)data));
    }

    @Override
    protected void clear() {
        this.pages.clear();
    }
}

