/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.config.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.exoplatform.portal.config.NoSuchDataException;
import org.exoplatform.portal.config.StaleModelException;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.CloneApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.PersistentApplicationState;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.ProtectedContainer;
import org.exoplatform.portal.mop.ProtectedResource;
import org.exoplatform.portal.mop.redirects.Condition;
import org.exoplatform.portal.mop.redirects.DeviceProperty;
import org.exoplatform.portal.mop.redirects.Mappings;
import org.exoplatform.portal.mop.redirects.NodeMap;
import org.exoplatform.portal.mop.redirects.Redirect;
import org.exoplatform.portal.mop.redirects.Redirectable;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.data.ApplicationData;
import org.exoplatform.portal.pom.data.BodyData;
import org.exoplatform.portal.pom.data.BodyType;
import org.exoplatform.portal.pom.data.ComponentData;
import org.exoplatform.portal.pom.data.ContainerData;
import org.exoplatform.portal.pom.data.MappedAttributes;
import org.exoplatform.portal.pom.data.ModelChange;
import org.exoplatform.portal.pom.data.ModelData;
import org.exoplatform.portal.pom.data.PageData;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.pom.data.RedirectConditionData;
import org.exoplatform.portal.pom.data.RedirectData;
import org.exoplatform.portal.pom.data.RedirectDevicePropertyConditionData;
import org.exoplatform.portal.pom.data.RedirectMappingsData;
import org.exoplatform.portal.pom.data.RedirectUserAgentConditionData;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.mop.api.Attributes;
import org.gatein.mop.api.content.ContentType;
import org.gatein.mop.api.content.Customization;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Page;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Templatized;
import org.gatein.mop.api.workspace.WorkspaceObject;
import org.gatein.mop.api.workspace.ui.UIBody;
import org.gatein.mop.api.workspace.ui.UIComponent;
import org.gatein.mop.api.workspace.ui.UIContainer;
import org.gatein.mop.api.workspace.ui.UIWindow;
import org.gatein.mop.core.util.Tools;

public class Mapper {
    private static final Log LOG = ExoLogger.getLogger(Mapper.class);
    private static final Set<String> propertiesBlackList = Tools.set((Object[])new String[]{"jcr:uuid", "jcr:primaryType"});
    private static final Set<String> portalPropertiesBlackList = Tools.set((Object[])new String[]{MappedAttributes.LOCALE.getName(), MappedAttributes.SKIN.getName()});
    private static final Set<String> windowPropertiesBlackList = Tools.set((Object[])new String[]{MappedAttributes.THEME.getName(), MappedAttributes.TYPE.getName(), MappedAttributes.ICON.getName(), MappedAttributes.WIDTH.getName(), MappedAttributes.HEIGHT.getName()});
    private final POMSession session;

    public Mapper(POMSession session) {
        this.session = session;
    }

    public PortalData load(Site src) {
        String type = Mapper.getOwnerType((ObjectType<? extends Site>)src.getObjectType());
        Attributes attrs = src.getAttributes();
        Templatized templarized = src.getRootNavigation().getTemplatized();
        Page template = templarized.getTemplate();
        UIContainer srcLayout = template.getRootComponent();
        HashMap<String, String> properties = new HashMap<String, String>();
        Mapper.load(attrs, properties, portalPropertiesBlackList);
        List<ComponentData> layoutChildren = this.loadChildren(srcLayout);
        ContainerData layout = this.load(srcLayout, layoutChildren);
        List<Object> accessPermissions = Collections.emptyList();
        String editPermission = null;
        if (src.isAdapted(ProtectedResource.class)) {
            ProtectedResource pr = (ProtectedResource)src.adapt(ProtectedResource.class);
            accessPermissions = pr.getAccessPermissions();
            editPermission = pr.getEditPermission();
        }
        List<RedirectData> redirects = null;
        if (src.isAdapted(Redirectable.class)) {
            Redirectable redirectAble = (Redirectable)src.adapt(Redirectable.class);
            redirects = this.loadRedirects(src, redirectAble.getRedirects());
        }
        Described described = (Described)src.adapt(Described.class);
        return new PortalData(src.getObjectId(), src.getName(), type, (String)attrs.getValue(MappedAttributes.LOCALE), described.getName(), described.getDescription(), accessPermissions, editPermission, Collections.unmodifiableMap(properties), (String)attrs.getValue(MappedAttributes.SKIN), layout, redirects);
    }

    private List<RedirectData> loadRedirects(Site src, Map<String, Redirect> redirects) {
        if (redirects == null || redirects.isEmpty()) {
            return null;
        }
        ArrayList<RedirectData> redirectsData = new ArrayList<RedirectData>();
        for (Redirect redirect : redirects.values()) {
            RedirectData redirectDate = new RedirectData(src.getObjectId(), redirect.getSite(), redirect.getName(), redirect.getEnabled(), this.buildConditionData(src, redirect.getConditions()), this.buildMappingsData(src.getObjectId(), redirect.getMapping()));
            redirectsData.add(redirectDate);
        }
        return redirectsData;
    }

    private List<RedirectConditionData> buildConditionData(Site src, Map<String, Condition> conditions) {
        ArrayList<RedirectConditionData> conditionDatas = new ArrayList<RedirectConditionData>();
        for (Condition condition : conditions.values()) {
            RedirectConditionData conditionData = new RedirectConditionData(src.getObjectId(), null, condition.getName());
            RedirectUserAgentConditionData userAgentConditionData = new RedirectUserAgentConditionData(src.getObjectId(), null);
            userAgentConditionData.getUserAgentContains().addAll(condition.getUserAgentContains());
            userAgentConditionData.getUserAgentDoesNotContain().addAll(condition.getUserAgentDoesNotContain());
            conditionData.setUserAgentConditionData(userAgentConditionData);
            for (DeviceProperty deviceProperty : condition.getDeviceProperties().values()) {
                RedirectDevicePropertyConditionData propertyConditionData = new RedirectDevicePropertyConditionData(src.getObjectId(), null, deviceProperty.getName());
                if (deviceProperty.getEquals() != null) {
                    propertyConditionData.setEquals(deviceProperty.getEquals());
                }
                if (deviceProperty.getGreaterThan() != null) {
                    propertyConditionData.setGreaterThan(deviceProperty.getGreaterThan());
                }
                if (deviceProperty.getLessThan() != null) {
                    propertyConditionData.setLessThan(deviceProperty.getLessThan());
                }
                if (deviceProperty.getPattern() != null) {
                    propertyConditionData.setMatches(Pattern.compile(deviceProperty.getPattern()));
                }
                conditionData.getDevicePropertyConditionData().add(propertyConditionData);
            }
            conditionDatas.add(conditionData);
        }
        return conditionDatas;
    }

    private RedirectMappingsData buildMappingsData(String storageId, Mappings mappings) {
        if (mappings != null) {
            RedirectMappingsData redirectMappingsData = new RedirectMappingsData(storageId);
            if (mappings.getUnresolvedNodeMatching() != null) {
                redirectMappingsData.setUnresolvedNode(mappings.getUnresolvedNodeMatching());
            }
            if (mappings.getNodeNameMatching() != null) {
                redirectMappingsData.setUseNodeNameMatching(mappings.getNodeNameMatching().booleanValue());
            }
            if (mappings.getNodeMap() != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                for (NodeMap nodeMap : mappings.getNodeMap().values()) {
                    map.put(nodeMap.getOriginNode(), nodeMap.getRedirectNode());
                }
                redirectMappingsData.getMappings().putAll(map);
            }
            return redirectMappingsData;
        }
        return null;
    }

    public void save(PortalData src, Site dst) {
        try {
            Page templates;
            Page template;
            if (src.getStorageId() != null && !src.getStorageId().equals(dst.getObjectId())) {
                String msg = "Attempt to save a site " + src.getType() + "/" + src.getName() + " on the wrong target site " + dst.getObjectType() + "/" + dst.getName();
                throw new IllegalArgumentException(msg);
            }
            Attributes attrs = dst.getAttributes();
            attrs.setValue(MappedAttributes.LOCALE, (Object)src.getLocale());
            attrs.setValue(MappedAttributes.SKIN, (Object)src.getSkin());
            if (src.getProperties() != null) {
                Mapper.save(src.getProperties(), attrs, portalPropertiesBlackList);
            }
            ProtectedResource pr = (ProtectedResource)dst.adapt(ProtectedResource.class);
            pr.setAccessPermissions(src.getAccessPermissions());
            pr.setEditPermission(src.getEditPermission());
            Described described = (Described)dst.adapt(Described.class);
            described.setName(src.getLabel());
            described.setDescription(src.getDescription());
            Redirectable redirectable = (Redirectable)dst.adapt(Redirectable.class);
            Map<String, Redirect> redirects = redirectable.getRedirects();
            List redirectsData = src.getRedirects();
            redirects.clear();
            if (src.getRedirects() != null) {
                for (RedirectData redirectData : redirectsData) {
                    Redirect redirect = redirectable.createRedirect();
                    redirects.put(redirectData.getRedirectName(), redirect);
                    redirect.setName(redirectData.getRedirectName());
                    redirect.setSite(redirectData.getRedirectSiteName());
                    redirect.setEnabled(redirectData.isEnabled());
                    if (redirectData.getConditions() != null) {
                        redirect.getConditions().clear();
                        for (RedirectConditionData conditionData : redirectData.getConditions()) {
                            Condition condition = redirect.createCondition();
                            redirect.getConditions().put(conditionData.getRedirectName(), condition);
                            this.buildCondition(conditionData, condition);
                        }
                    }
                    if (redirectData.getMappings() == null) continue;
                    Mappings mappings = redirect.getMapping();
                    if (redirect.getMapping() == null) {
                        mappings = redirect.createMapping();
                        redirect.setMapping(mappings);
                    }
                    this.buildMappings(redirectData.getMappings(), mappings);
                }
            }
            if ((template = (templates = dst.getRootPage().getChild("templates")).getChild("default")) == null) {
                template = templates.addChild("default");
            }
            ContainerData srcContainer = src.getPortalLayout();
            UIContainer dstContainer = template.getRootComponent();
            ContainerData realSrcContainer = new ContainerData(dstContainer.getObjectId(), srcContainer.getId(), srcContainer.getName(), srcContainer.getIcon(), srcContainer.getTemplate(), srcContainer.getFactoryId(), srcContainer.getTitle(), srcContainer.getDescription(), srcContainer.getWidth(), srcContainer.getHeight(), srcContainer.getAccessPermissions(), srcContainer.getMoveAppsPermissions(), srcContainer.getMoveContainersPermissions(), srcContainer.getChildren());
            this.save(realSrcContainer, dstContainer);
            this.saveChildren(realSrcContainer, dstContainer);
            Templatized templatized = dst.getRootNavigation().getTemplatized();
            if (templatized != null) {
                templatized.setTemplate(template);
            } else {
                template.templatize((WorkspaceObject)dst.getRootNavigation());
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void buildCondition(RedirectConditionData redirectConditionData, Condition condition) {
        condition.setName(redirectConditionData.getRedirectName());
        if (redirectConditionData.getUserAgentConditionData() != null) {
            condition.setUserAgentContains(redirectConditionData.getUserAgentConditionData().getUserAgentContains());
        }
        if (redirectConditionData.getUserAgentConditionData() != null) {
            condition.setUserAgentDoesNotContain(redirectConditionData.getUserAgentConditionData().getUserAgentDoesNotContain());
        }
        if (redirectConditionData.getDevicePropertyConditionData() != null || !condition.getDeviceProperties().isEmpty()) {
            HashSet<String> notFoundProperties = new HashSet<String>(condition.getDeviceProperties().keySet());
            for (RedirectDevicePropertyConditionData propertyConditionData : redirectConditionData.getDevicePropertyConditionData()) {
                DeviceProperty deviceProperty = condition.getDeviceProperties().get(propertyConditionData.getPropertyName());
                if (deviceProperty == null) {
                    deviceProperty = condition.createDeviceProperty();
                    condition.getDeviceProperties().put(propertyConditionData.getPropertyName(), deviceProperty);
                } else {
                    notFoundProperties.remove(propertyConditionData.getPropertyName());
                }
                deviceProperty.setName(propertyConditionData.getPropertyName());
                if (propertyConditionData.getGreaterThan() != null) {
                    deviceProperty.setGreaterThan(propertyConditionData.getGreaterThan());
                }
                if (propertyConditionData.getLessThan() != null) {
                    deviceProperty.setLessThan(propertyConditionData.getLessThan());
                }
                if (propertyConditionData.getEquals() != null) {
                    deviceProperty.setEquals(propertyConditionData.getEquals());
                }
                if (propertyConditionData.getMatches() == null) continue;
                deviceProperty.setPattern(propertyConditionData.getMatches().toString());
            }
            for (String devicePropertyName : notFoundProperties) {
                condition.getDeviceProperties().remove(devicePropertyName);
            }
        }
    }

    private void buildMappings(RedirectMappingsData mappingsData, Mappings mappings) {
        mappings.setNodeNameMatching(mappingsData.isUseNodeNameMatching());
        mappings.setUnresolvedNodeMatching(mappingsData.getUnresolvedNode());
        if (!mappingsData.getMappings().isEmpty() || !mappings.getNodeMap().isEmpty()) {
            HashSet<String> notFoundNodeMappings = new HashSet<String>(mappings.getNodeMap().keySet());
            for (String key : mappingsData.getMappings().keySet()) {
                NodeMap nodeMap = mappings.getNodeMap().get(Text.escapeIllegalJcrChars((String)key));
                if (nodeMap == null) {
                    nodeMap = mappings.createNode();
                    mappings.getNodeMap().put(Text.escapeIllegalJcrChars((String)key), nodeMap);
                } else {
                    notFoundNodeMappings.remove(Text.escapeIllegalJcrChars((String)key));
                }
                nodeMap.setOriginNode(key);
                nodeMap.setRedirectNode((String)mappingsData.getMappings().get(key));
            }
            for (String nodeName : notFoundNodeMappings) {
                mappings.getNodeMap().remove(nodeName);
            }
        }
    }

    public PageData load(Page src) {
        Site site = src.getSite();
        String ownerType = Mapper.getOwnerType((ObjectType<? extends Site>)site.getObjectType());
        String ownerId = site.getName();
        String name = src.getName();
        List<ComponentData> children = this.loadChildren(src.getRootComponent());
        List<Object> moveAppsPermissions = null;
        List<Object> moveContainersPermissions = null;
        if (src.isAdapted(ProtectedContainer.class)) {
            ProtectedContainer pc = (ProtectedContainer)src.adapt(ProtectedContainer.class);
            moveAppsPermissions = pc.getMoveAppsPermissions();
            moveContainersPermissions = pc.getMoveContainersPermissions();
        } else {
            moveAppsPermissions = Collections.emptyList();
            moveContainersPermissions = Collections.emptyList();
        }
        return new PageData(src.getObjectId(), null, name, null, null, null, null, null, null, null, Collections.emptyList(), children, ownerType, ownerId, null, false, moveAppsPermissions, moveContainersPermissions);
    }

    private ContainerData load(UIContainer src, List<ComponentData> children) {
        List<Object> accessPermissions = Collections.emptyList();
        if (src.isAdapted(ProtectedResource.class)) {
            ProtectedResource pr = (ProtectedResource)src.adapt(ProtectedResource.class);
            accessPermissions = pr.getAccessPermissions();
        }
        List<String> moveAppsPermissions = null;
        List<String> moveContainersPermissions = null;
        if (src.isAdapted(ProtectedContainer.class)) {
            ProtectedContainer pc = (ProtectedContainer)src.adapt(ProtectedContainer.class);
            moveAppsPermissions = pc.getMoveAppsPermissions();
            moveContainersPermissions = pc.getMoveContainersPermissions();
        } else {
            moveAppsPermissions = Container.DEFAULT_MOVE_APPLICATIONS_PERMISSIONS;
            moveContainersPermissions = Container.DEFAULT_MOVE_CONTAINERS_PERMISSIONS;
        }
        Described described = (Described)src.adapt(Described.class);
        Attributes attrs = src.getAttributes();
        return new ContainerData(src.getObjectId(), (String)attrs.getValue(MappedAttributes.ID), (String)attrs.getValue(MappedAttributes.NAME), (String)attrs.getValue(MappedAttributes.ICON), (String)attrs.getValue(MappedAttributes.TEMPLATE), (String)attrs.getValue(MappedAttributes.FACTORY_ID), described.getName(), described.getDescription(), (String)attrs.getValue(MappedAttributes.WIDTH), (String)attrs.getValue(MappedAttributes.HEIGHT), Utils.safeImmutableList(accessPermissions), Utils.safeImmutableList(moveAppsPermissions), Utils.safeImmutableList(moveContainersPermissions), children);
    }

    private List<ComponentData> loadChildren(UIContainer src) {
        if (src == null) {
            throw new NoSuchDataException("Can not load children");
        }
        ArrayList<ComponentData> children = new ArrayList<ComponentData>();
        for (UIComponent component : src.getComponents()) {
            ContainerData mo;
            if (component instanceof UIContainer) {
                UIContainer srcContainer = (UIContainer)component;
                Attributes attrs = srcContainer.getAttributes();
                String type = (String)attrs.getValue(MappedAttributes.TYPE);
                if ("dashboard".equals(type)) continue;
                List<ComponentData> dstChildren = this.loadChildren(srcContainer);
                mo = this.load(srcContainer, dstChildren);
            } else if (component instanceof UIWindow) {
                UIWindow window = (UIWindow)component;
                ContainerData application = this.load(window);
                if (application == null) continue;
                mo = application;
            } else if (component instanceof UIBody) {
                mo = new BodyData(component.getObjectId(), BodyType.PAGE);
            } else {
                throw new AssertionError();
            }
            children.add((ComponentData)mo);
        }
        return children;
    }

    public List<ModelChange> save(PageData src, Site site, String name) throws IllegalStateException {
        Page root = site.getRootPage();
        Page pages = root.getChild("pages");
        Page dst = pages.getChild(name);
        LinkedList<ModelChange> changes = new LinkedList<ModelChange>();
        if (dst == null) {
            throw new NoSuchDataException("The page " + name + " not found");
        }
        changes.add((ModelChange)new ModelChange.Update((ModelData)src));
        UIContainer rootContainer = dst.getRootComponent();
        PageData src2 = new PageData(rootContainer.getObjectId(), src.getId(), src.getName(), src.getIcon(), src.getTemplate(), null, null, null, src.getWidth(), src.getHeight(), Collections.emptyList(), src.getChildren(), src.getOwnerType(), src.getOwnerId(), null, false, src.getMoveAppsPermissions(), src.getMoveContainersPermissions());
        LinkedList<ModelChange> childrenChanges = this.saveChildren((ContainerData)src2, rootContainer);
        changes.addAll(childrenChanges);
        return changes;
    }

    private void save(ContainerData src, UIContainer dst) {
        ProtectedResource pr = (ProtectedResource)dst.adapt(ProtectedResource.class);
        pr.setAccessPermissions(src.getAccessPermissions());
        ProtectedContainer pc = (ProtectedContainer)dst.adapt(ProtectedContainer.class);
        pc.setMoveAppsPermissions(src.getMoveAppsPermissions());
        pc.setMoveContainersPermissions(src.getMoveContainersPermissions());
        Described described = (Described)dst.adapt(Described.class);
        described.setName(src.getTitle());
        described.setDescription(src.getDescription());
        Attributes dstAttrs = dst.getAttributes();
        dstAttrs.setValue(MappedAttributes.ID, (Object)src.getId());
        dstAttrs.setValue(MappedAttributes.TYPE, null);
        dstAttrs.setValue(MappedAttributes.ICON, (Object)src.getIcon());
        dstAttrs.setValue(MappedAttributes.TEMPLATE, (Object)src.getTemplate());
        dstAttrs.setValue(MappedAttributes.FACTORY_ID, (Object)src.getFactoryId());
        dstAttrs.setValue(MappedAttributes.WIDTH, (Object)src.getWidth());
        dstAttrs.setValue(MappedAttributes.HEIGHT, (Object)src.getHeight());
        dstAttrs.setValue(MappedAttributes.NAME, (Object)src.getName());
    }

    private void save(ModelData src, WorkspaceObject dst, LinkedList<ModelChange> changes, Map<String, String> hierarchyRelationships) {
        if (src instanceof ContainerData) {
            this.save((ContainerData)src, (UIContainer)dst);
            this.saveChildren((ContainerData)src, (UIContainer)dst, changes, hierarchyRelationships);
        } else if (src instanceof ApplicationData) {
            this.save((ApplicationData)src, (UIWindow)dst);
        } else if (!(src instanceof BodyData)) {
            throw new AssertionError((Object)("Was not expecting child " + src));
        }
    }

    private LinkedList<ModelChange> saveChildren(ContainerData src, UIContainer dst) {
        LinkedList<ModelChange> changes = new LinkedList<ModelChange>();
        Map<String, String> hierarchyRelationships = new HashMap<String, String>();
        this.build(src, hierarchyRelationships);
        hierarchyRelationships = Collections.unmodifiableMap(hierarchyRelationships);
        this.saveChildren(src, dst, changes, hierarchyRelationships);
        return changes;
    }

    private void build(ContainerData parent, Map<String, String> hierarchyRelationships) {
        String parentId = parent.getStorageId();
        for (ModelData child : parent.getChildren()) {
            String childId = child.getStorageId();
            if (childId != null) {
                if (hierarchyRelationships.containsKey(childId)) {
                    throw new AssertionError((Object)"The same object is present two times in the object hierarchy");
                }
                hierarchyRelationships.put(childId, parentId);
            }
            if (!(child instanceof ContainerData)) continue;
            this.build((ContainerData)child, hierarchyRelationships);
        }
    }

    private void saveChildren(ContainerData src, UIContainer dst, LinkedList<ModelChange> changes, Map<String, String> hierarchyRelationships) {
        String dstChildId;
        final ArrayList<String> orders = new ArrayList<String>();
        HashMap<String, ModelData> modelObjectMap = new HashMap<String, ModelData>();
        for (ModelData srcChild : src.getChildren()) {
            UIComponent dstChild;
            String srcChildId = srcChild.getStorageId();
            Object transientDashboardData = null;
            if (srcChildId != null) {
                dstChild = (UIComponent)this.session.findObjectById(ObjectType.COMPONENT, srcChildId);
                if (dstChild == null) {
                    throw new StaleModelException("Could not find supposed present child with id " + srcChildId);
                }
                boolean found = false;
                for (UIComponent child : dst.getComponents()) {
                    if (!child.getObjectId().equals(srcChildId)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    if (hierarchyRelationships.containsKey(srcChildId)) {
                        String srcId = hierarchyRelationships.get(srcChildId);
                        dst.getComponents().add(dstChild);
                        changes.add((ModelChange)new ModelChange.Move(srcId, dst.getObjectId(), srcChildId));
                    } else {
                        throw new IllegalArgumentException("Attempt for updating a ui component " + this.session.pathOf((WorkspaceObject)dstChild) + " that is not present in the target ui container " + this.session.pathOf((WorkspaceObject)dst));
                    }
                }
                changes.add((ModelChange)new ModelChange.Update(srcChild));
            } else {
                String name = srcChild.getStorageName();
                if (name == null) {
                    name = UUID.randomUUID().toString();
                }
                if (srcChild instanceof ContainerData) {
                    dstChild = dst.add(ObjectType.CONTAINER, name);
                } else if (srcChild instanceof ApplicationData) {
                    dstChild = dst.add(ObjectType.WINDOW, name);
                } else if (srcChild instanceof BodyData) {
                    dstChild = dst.add(ObjectType.BODY, name);
                } else {
                    throw new StaleModelException("Was not expecting child " + srcChild);
                }
                changes.add((ModelChange)new ModelChange.Create(dst.getObjectId(), srcChild));
            }
            if (transientDashboardData != null) {
                Attributes attrs = dstChild.getAttributes();
                attrs.setValue(MappedAttributes.SHOW_INFO_BAR, (Object)transientDashboardData.isShowInfoBar());
                attrs.setValue(MappedAttributes.SHOW_MODE, (Object)transientDashboardData.isShowApplicationMode());
                attrs.setValue(MappedAttributes.SHOW_WINDOW_STATE, (Object)transientDashboardData.isShowApplicationState());
                attrs.setValue(MappedAttributes.THEME, (Object)transientDashboardData.getTheme());
            }
            this.save(srcChild, (WorkspaceObject)dstChild, changes, hierarchyRelationships);
            String dstChildId2 = dstChild.getObjectId();
            modelObjectMap.put(dstChildId2, srcChild);
            orders.add(dstChildId2);
        }
        for (UIComponent dstChild : dst.getComponents()) {
            dstChildId = dstChild.getObjectId();
            if (modelObjectMap.containsKey(dstChildId)) continue;
            String parentId = hierarchyRelationships.get(dstChildId);
            if (parentId != null) {
                UIContainer parent = (UIContainer)this.session.findObjectById(ObjectType.CONTAINER, parentId);
                parent.getComponents().add(dstChild);
                changes.add((ModelChange)new ModelChange.Move(dst.getObjectId(), parentId, dstChildId));
                continue;
            }
            if (!hierarchyRelationships.containsKey(dstChildId)) continue;
            modelObjectMap.put(dstChildId, null);
        }
        Iterator i = dst.getComponents().iterator();
        while (i.hasNext()) {
            UIComponent dstChild;
            dstChild = (UIComponent)i.next();
            dstChildId = dstChild.getObjectId();
            if (modelObjectMap.containsKey(dstChildId)) continue;
            i.remove();
            changes.add((ModelChange)new ModelChange.Destroy(dstChildId));
        }
        UIComponent[] a = dst.getComponents().toArray(new UIComponent[dst.getComponents().size()]);
        Arrays.sort(a, new Comparator<UIComponent>(){

            @Override
            public int compare(UIComponent o1, UIComponent o2) {
                int i1 = orders.indexOf(o1.getObjectId());
                int i2 = orders.indexOf(o2.getObjectId());
                return i1 - i2;
            }
        });
        for (int j = 0; j < a.length; ++j) {
            dst.getComponents().add(j, a[j]);
        }
    }

    public <S> ApplicationData<S> load(UIWindow src) {
        Attributes attrs = src.getAttributes();
        Customization customization = src.getCustomization();
        ApplicationType type = null;
        PersistentApplicationState instanceState = null;
        if (customization == null) {
            return null;
        }
        ContentType contentType = customization.getType();
        String customizationid = customization.getId();
        type = ApplicationType.getType((ContentType)contentType);
        instanceState = new PersistentApplicationState(customizationid);
        HashMap<String, String> properties = new HashMap<String, String>();
        Mapper.load(attrs, properties, windowPropertiesBlackList);
        List<Object> accessPermissions = Collections.emptyList();
        if (src.isAdapted(ProtectedResource.class)) {
            ProtectedResource pr = (ProtectedResource)src.adapt(ProtectedResource.class);
            accessPermissions = pr.getAccessPermissions();
        }
        Described described = (Described)src.adapt(Described.class);
        boolean showInfoBar = (Boolean)attrs.getValue(MappedAttributes.SHOW_INFO_BAR, (Object)false);
        boolean showWindowState = (Boolean)attrs.getValue(MappedAttributes.SHOW_WINDOW_STATE, (Object)false);
        boolean showMode = (Boolean)attrs.getValue(MappedAttributes.SHOW_MODE, (Object)false);
        String theme = (String)attrs.getValue(MappedAttributes.THEME, null);
        return new ApplicationData(src.getObjectId(), src.getName(), type, (ApplicationState)instanceState, null, described.getName(), (String)attrs.getValue(MappedAttributes.ICON), described.getDescription(), showInfoBar, showWindowState, showMode, theme, (String)attrs.getValue(MappedAttributes.WIDTH), (String)attrs.getValue(MappedAttributes.HEIGHT), Utils.safeImmutableMap(properties), Utils.safeImmutableList(accessPermissions));
    }

    public <S> void save(ApplicationData<S> src, UIWindow dst) {
        ProtectedResource pr = (ProtectedResource)dst.adapt(ProtectedResource.class);
        pr.setAccessPermissions(src.getAccessPermissions());
        Described described = (Described)dst.adapt(Described.class);
        described.setName(src.getTitle());
        described.setDescription(src.getDescription());
        Attributes attrs = dst.getAttributes();
        attrs.setValue(MappedAttributes.SHOW_INFO_BAR, (Object)src.isShowInfoBar());
        attrs.setValue(MappedAttributes.SHOW_WINDOW_STATE, (Object)src.isShowApplicationState());
        attrs.setValue(MappedAttributes.SHOW_MODE, (Object)src.isShowApplicationMode());
        attrs.setValue(MappedAttributes.THEME, (Object)src.getTheme());
        attrs.setValue(MappedAttributes.ICON, (Object)src.getIcon());
        attrs.setValue(MappedAttributes.WIDTH, (Object)src.getWidth());
        attrs.setValue(MappedAttributes.HEIGHT, (Object)src.getHeight());
        Mapper.save(src.getProperties(), attrs, windowPropertiesBlackList);
        ApplicationState instanceState = src.getState();
        if (instanceState instanceof TransientApplicationState) {
            Customization dstCustomization;
            TransientApplicationState transientState = (TransientApplicationState)instanceState;
            Site site = null;
            if (transientState.getOwnerType() != null && transientState.getOwnerId() != null) {
                ObjectType<Site> siteType = Mapper.parseSiteType(transientState.getOwnerType());
                site = this.session.getWorkspace().getSite(siteType, transientState.getOwnerId());
            }
            Site currentSite = dst.getPage().getSite();
            if (site == dst.getPage().getSite()) {
                site = null;
            }
            String contentId = transientState.getContentId();
            ContentType contentType = src.getType().getContentType();
            Customization customization = null;
            if (dst.getCustomization() != null) {
                dst.getCustomization().destroy();
            }
            if (customization != null && customization.getType().equals((Object)contentType) && customization.getContentId().equals(contentId)) {
                Customization bilto = customization;
                if (bilto.getContext() == currentSite) {
                    dstCustomization = dst.customize(bilto);
                } else {
                    Object state = bilto.getVirtualState();
                    dstCustomization = dst.customize(contentType, contentId, state);
                }
            } else {
                dstCustomization = dst.customize(contentType, contentId, null);
            }
            Object state = ((TransientApplicationState)instanceState).getContentState();
            if (state != null) {
                dstCustomization.setState(state);
            }
        } else if (instanceState instanceof CloneApplicationState) {
            CloneApplicationState cloneState = (CloneApplicationState)instanceState;
            Customization<?> customization = this.session.findCustomizationById(cloneState.getStorageId());
            dst.customize(customization);
        } else if (!(instanceState instanceof PersistentApplicationState)) {
            throw new IllegalArgumentException("Cannot save application with state " + instanceState);
        }
    }

    private static void load(Attributes src, Map<String, String> dst, Set<String> blackList) {
        for (String name : src.getKeys()) {
            Object value;
            if (blackList.contains(name) || propertiesBlackList.contains(name) || !((value = src.getObject(name)) instanceof String)) continue;
            dst.put(name, (String)value);
        }
    }

    public static void save(Map<String, String> src, Attributes dst, Set<String> blackList) {
        for (Map.Entry<String, String> property : src.entrySet()) {
            String name = property.getKey();
            if (blackList.contains(name) || propertiesBlackList.contains(name)) continue;
            dst.setString(name, property.getValue());
        }
    }

    public static String getOwnerType(ObjectType<? extends Site> siteType) {
        if (siteType == ObjectType.PORTAL_SITE) {
            return PortalConfig.PORTAL_TYPE;
        }
        if (siteType == ObjectType.GROUP_SITE) {
            return PortalConfig.GROUP_TYPE;
        }
        if (siteType == ObjectType.USER_SITE) {
            return PortalConfig.USER_TYPE;
        }
        throw new IllegalArgumentException("Invalid site type " + siteType);
    }

    public static ObjectType<Site> parseSiteType(String ownerType) {
        if (ownerType.equals(PortalConfig.PORTAL_TYPE)) {
            return ObjectType.PORTAL_SITE;
        }
        if (ownerType.equals(PortalConfig.GROUP_TYPE)) {
            return ObjectType.GROUP_SITE;
        }
        if (ownerType.equals(PortalConfig.USER_TYPE)) {
            return ObjectType.USER_SITE;
        }
        throw new IllegalArgumentException("Invalid owner type " + ownerType);
    }
}

