/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.spi.portlet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.PortletBuilder;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.exoplatform.portal.pom.spi.portlet.PreferenceState;
import org.gatein.mop.core.api.workspace.content.AbstractCustomizationState;

@PrimaryType(name="mop:portletpreferences")
@FormattedBy(value=BaseEncodingObjectFormatter.class)
@NamingPrefix(value="mop")
public abstract class PortletState
extends AbstractCustomizationState {
    private Portlet payload;

    @OneToMany
    public abstract Map<String, PreferenceState> getChildren();

    @Create
    public abstract PreferenceState create();

    public void setPayload(Portlet payload) {
        Map<String, PreferenceState> entries = this.getChildren();
        entries.clear();
        for (Preference pref : payload) {
            PreferenceState prefState = this.create();
            entries.put(pref.getName(), prefState);
            List<String> toCopyValues = pref.getValues();
            ArrayList<String> copiedValues = new ArrayList<String>(toCopyValues.size());
            for (int i = 0; i < toCopyValues.size(); ++i) {
                String value = toCopyValues.get(i);
                if (value == null) {
                    value = "";
                }
                copiedValues.add(value);
            }
            prefState.setValue(copiedValues);
            prefState.setReadOnly(pref.isReadOnly());
        }
        payload = null;
    }

    public Portlet getPayload() {
        if (this.payload == null) {
            PortletBuilder builder = new PortletBuilder();
            for (PreferenceState entry : this.getChildren().values()) {
                builder.add(entry.getName(), entry.getValues(), entry.getReadOnly());
            }
            this.payload = builder.build();
        }
        return this.payload;
    }
}

