/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.migration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.jdbc.migration.ApplicationReferenceModification;
import org.exoplatform.portal.jdbc.migration.MigrationContext;
import org.exoplatform.portal.mop.jdbc.dao.WindowDAO;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AppReferencesMigrationService {
    public static final String EVENT_LISTENER_KEY = "PORTAL_APPLICATIONS_MIGRATION";
    private static final Log LOG = ExoLogger.getExoLogger(AppReferencesMigrationService.class);
    private ApplicationRegistryService appService;
    private WindowDAO windowDAO;
    private Map<String, ApplicationReferenceModification> applicationReferenceModifications = new HashMap<String, ApplicationReferenceModification>();

    public AppReferencesMigrationService(ApplicationRegistryService appService, WindowDAO windowDAO) {
        this.appService = appService;
        this.windowDAO = windowDAO;
    }

    public void doMigration() throws Exception {
        if (this.applicationReferenceModifications.isEmpty()) {
            return;
        }
        this.migrateApplicationRegistryEntries();
        this.migrateApplicationReferencesInMOP();
    }

    private void migrateApplicationReferencesInMOP() {
        long t = System.currentTimeMillis();
        LOG.info((Object)"| \\ START::Application References migration from pages and sites ---------------------------------");
        ArrayList<String> contentIdsToUpdate = new ArrayList<String>(this.applicationReferenceModifications.keySet());
        for (String oldContentId : contentIdsToUpdate) {
            ApplicationReferenceModification applicationModification = this.applicationReferenceModifications.get(oldContentId);
            int modifiedLines = 0;
            if (applicationModification.isModification()) {
                modifiedLines = this.windowDAO.updateContentId(oldContentId, applicationModification.getNewContentId());
            } else if (applicationModification.isRemoval()) {
                modifiedLines = this.windowDAO.deleteByContentId(oldContentId);
            }
            MigrationContext.restartTransaction();
            if (modifiedLines <= 0) continue;
            LOG.info("| -- UPDATE::Application Reference '{}' ({} items) migrated successfully", new Object[]{oldContentId, modifiedLines});
        }
        LOG.info("| / END::Application References migration from pages and sites in {}ms", new Object[]{System.currentTimeMillis() - t});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateApplicationRegistryEntries() throws Exception {
        long t = System.currentTimeMillis();
        LOG.info((Object)"| \\ START::Application References migration from app registry ---------------------------------");
        List categories = this.appService.getApplicationCategories();
        if (categories == null || categories.isEmpty()) {
            return;
        }
        for (ApplicationCategory category : categories) {
            if (MigrationContext.isForceStop()) break;
            long t1 = System.currentTimeMillis();
            try {
                for (Application app : category.getApplications()) {
                    if (app == null || !ApplicationType.PORTLET.equals(app.getType()) || this.isApplicationToRemove(app)) continue;
                    String oldContentId = app.getContentId();
                    if (this.isApplicationToRemove(app)) {
                        LOG.info("|  -- UPDATE::remove application reference from registry '{}'", new Object[]{oldContentId});
                        this.appService.remove(app);
                        continue;
                    }
                    if (!this.isApplicationToModify(app)) continue;
                    this.modifyApplicationReference(app);
                    LOG.info("|  -- UPDATE::migrate application reference in registry from '{}' to '{}'", new Object[]{oldContentId, app.getContentId()});
                    this.appService.save(category, app);
                }
            }
            catch (Exception ex) {
                LOG.error("|  / END::migrate Application References from app registry category {} in {}ms", new Object[]{category.getName(), System.currentTimeMillis() - t1, ex});
            }
            finally {
                MigrationContext.restartTransaction();
            }
        }
        LOG.info("| / END::Application References migration from app registry in {}ms", new Object[]{System.currentTimeMillis() - t});
    }

    public void addApplicationModification(ApplicationReferenceModification applicationReferenceModification) {
        if (applicationReferenceModification == null) {
            throw new IllegalArgumentException("applicationReferenceModification plugin is mandatory");
        }
        this.applicationReferenceModifications.put(applicationReferenceModification.getOldApplicationName() + "/" + applicationReferenceModification.getOldPortletName(), applicationReferenceModification);
    }

    public boolean isApplicationToRemove(Object app) {
        String contentId = this.getApplicationContentId(app);
        return StringUtils.isNotBlank((CharSequence)contentId) && this.applicationReferenceModifications.containsKey(contentId) && this.applicationReferenceModifications.get(contentId).isRemoval();
    }

    public boolean isApplicationToModify(Object app) {
        String contentId = this.getApplicationContentId(app);
        return StringUtils.isNotBlank((CharSequence)contentId) && this.applicationReferenceModifications.containsKey(contentId) && this.applicationReferenceModifications.get(contentId).isModification();
    }

    public String modifyApplicationReference(Object app) {
        if (app instanceof Application) {
            Application application = (Application)app;
            String contentId = this.getApplicationContentId(application);
            ApplicationReferenceModification applicationReferenceModification = this.applicationReferenceModifications.get(contentId);
            String newContentId = applicationReferenceModification.getNewContentId();
            application.setApplicationName(applicationReferenceModification.getNewPortletName());
            application.setContentId(newContentId);
            return newContentId;
        }
        if (app instanceof String) {
            ApplicationReferenceModification applicationReferenceModification = this.applicationReferenceModifications.get(app.toString());
            return applicationReferenceModification == null ? null : applicationReferenceModification.getNewContentId();
        }
        return null;
    }

    private String getApplicationContentId(Object app) {
        String contentId = null;
        if (app instanceof Application) {
            contentId = ((Application)app).getContentId();
        } else if (app instanceof String) {
            contentId = app.toString();
        }
        return contentId;
    }
}

