/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.Visible;
import org.exoplatform.portal.mop.management.operations.navigation.NavigationUtils;
import org.exoplatform.portal.mop.navigation.DataCache;
import org.exoplatform.portal.mop.navigation.FederatingVisitor;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationData;
import org.exoplatform.portal.mop.navigation.NavigationError;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeChangeQueue;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.navigation.SimpleDataCache;
import org.exoplatform.portal.mop.navigation.TreeContext;
import org.exoplatform.portal.mop.navigation.TreeMerge;
import org.exoplatform.portal.mop.navigation.TreeUpdate;
import org.exoplatform.portal.mop.navigation.TreeUpdateAdapter;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.portal.pom.data.MappedAttributes;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.mop.api.Attributes;
import org.gatein.mop.api.workspace.Navigation;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Page;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;
import org.gatein.mop.api.workspace.link.PageLink;

public class NavigationServiceImpl
implements NavigationService {
    final POMSessionManager manager;
    private final DataCache dataCache;
    final Logger log = LoggerFactory.getLogger(NavigationServiceImpl.class);

    public NavigationServiceImpl(POMSessionManager manager, DataCache dataCache) throws NullPointerException {
        if (manager == null) {
            throw new NullPointerException("No null pom session manager allowed");
        }
        if (dataCache == null) {
            throw new NullPointerException("No null data cache allowed");
        }
        this.manager = manager;
        this.dataCache = dataCache;
    }

    public NavigationServiceImpl(POMSessionManager manager) throws NullPointerException {
        this(manager, new SimpleDataCache());
    }

    public NavigationContext loadNavigation(SiteKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        POMSession session = this.manager.getSession();
        NavigationData data = this.dataCache.getNavigationData(session, key);
        return data != null && data != NavigationData.EMPTY && data.key != null ? new NavigationContext(data) : null;
    }

    public List<NavigationContext> loadNavigations(SiteType type) throws NullPointerException, NavigationServiceException {
        if (type == null) {
            throw new NullPointerException();
        }
        POMSession session = this.manager.getSession();
        ObjectType objectType = Utils.objectType((SiteType)type);
        Collection sites = session.getWorkspace().getSites(objectType);
        LinkedList<NavigationContext> navigations = new LinkedList<NavigationContext>();
        for (Site site : sites) {
            Navigation defaultNavigation = site.getRootNavigation().getChild("default");
            if (defaultNavigation == null) continue;
            SiteKey key = new SiteKey(type, site.getName());
            navigations.add(new NavigationContext(new NavigationData(key, defaultNavigation)));
        }
        return navigations;
    }

    public void saveNavigation(NavigationContext navigation) throws NullPointerException, NavigationServiceException {
        NavigationState state;
        if (navigation == null) {
            throw new NullPointerException();
        }
        POMSession session = this.manager.getSession();
        ObjectType objectType = Utils.objectType((SiteType)navigation.key.getType());
        Workspace workspace = session.getWorkspace();
        Site site = workspace.getSite(objectType, navigation.key.getName());
        if (site == null) {
            throw new NavigationServiceException(NavigationError.NAVIGATION_NO_SITE);
        }
        Navigation rootNode = site.getRootNavigation();
        Navigation defaultNode = rootNode.getChild("default");
        if (defaultNode == null) {
            defaultNode = rootNode.addChild("default");
        }
        if ((state = navigation.state) != null) {
            Integer priority = state.getPriority();
            defaultNode.getAttributes().setValue(MappedAttributes.PRIORITY, (Object)priority);
        }
        this.dataCache.removeNavigationData(session, navigation.key);
        navigation.data = this.dataCache.getNavigationData(session, navigation.key);
        navigation.state = null;
    }

    public boolean destroyNavigation(NavigationContext navigation) throws NullPointerException, NavigationServiceException {
        if (navigation == null) {
            throw new NullPointerException("No null navigation argument");
        }
        if (navigation.data == null) {
            throw new IllegalArgumentException("Already removed");
        }
        POMSession session = this.manager.getSession();
        ObjectType objectType = Utils.objectType((SiteType)navigation.key.getType());
        Workspace workspace = session.getWorkspace();
        Site site = workspace.getSite(objectType, navigation.key.getName());
        if (site == null) {
            throw new NavigationServiceException(NavigationError.NAVIGATION_NO_SITE);
        }
        Navigation rootNode = site.getRootNavigation();
        Navigation defaultNode = rootNode.getChild("default");
        if (defaultNode != null) {
            this.dataCache.removeNavigation(navigation.key);
            String rootId = navigation.data.rootId;
            if (rootId != null) {
                this.dataCache.removeNodes(Collections.singleton(rootId));
            }
            defaultNode.destroy();
            navigation.data = null;
            return true;
        }
        return false;
    }

    public <N> NodeContext<N> loadNode(NodeModel<N> model, NavigationContext navigation, Scope scope, NodeChangeListener<NodeContext<N>> listener) {
        if (model == null) {
            throw new NullPointerException("No null model accepted");
        }
        if (navigation == null) {
            throw new NullPointerException("No null navigation accepted");
        }
        if (scope == null) {
            throw new NullPointerException("No null scope accepted");
        }
        String nodeId = navigation.data.rootId;
        if (navigation.data.rootId != null) {
            POMSession session = this.manager.getSession();
            NodeData data = this.dataCache.getNodeData(session, nodeId);
            if (data != null) {
                NodeContext context = new NodeContext(model, data);
                this.updateNode(context, scope, listener);
                return context;
            }
            return null;
        }
        return null;
    }

    public <N> void updateNode(NodeContext<N> root, Scope scope, NodeChangeListener<NodeContext<N>> listener) throws NullPointerException, IllegalArgumentException, NavigationServiceException {
        Object visitor = scope != null ? new FederatingVisitor((Scope.Visitor)root.tree, root, scope) : root.tree;
        this.updateTree(root.tree, (Scope.Visitor)visitor, listener);
    }

    public <N> void saveNode(NodeContext<N> context, NodeChangeListener<NodeContext<N>> listener) throws NullPointerException, NavigationServiceException {
        this.saveTree(context.tree, listener);
    }

    public <N> void rebaseNode(NodeContext<N> context, Scope scope, NodeChangeListener<NodeContext<N>> listener) throws NavigationServiceException {
        Object visitor = scope != null ? new FederatingVisitor(context.tree.origin(), context, scope) : context.tree.origin();
        this.rebaseTree((TreeContext<N>)context.tree, (Scope.Visitor)visitor, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <N> void updateTree(TreeContext<N> tree, Scope.Visitor visitor, NodeChangeListener<NodeContext<N>> listener) throws NullPointerException, IllegalArgumentException, NavigationServiceException {
        if (tree.hasChanges()) {
            throw new IllegalArgumentException("For now we don't accept to update a context that has pending changes");
        }
        POMSession session = this.manager.getSession();
        NodeData data = this.dataCache.getNodeData(session, tree.root.data.id);
        if (data == null) {
            throw new NavigationServiceException(NavigationError.UPDATE_CONCURRENTLY_REMOVED_NODE);
        }
        tree.editMode = true;
        try {
            TreeUpdate.perform(tree, NodeContextUpdateAdapter.create(), (Object)data, (TreeUpdateAdapter)NodeDataUpdateAdapter.create(this.dataCache, session), listener, (Scope.Visitor)visitor);
        }
        finally {
            tree.editMode = false;
        }
    }

    public void clearCache() {
        this.dataCache.clear();
    }

    private <N> void saveTree(TreeContext<N> tree, NodeChangeListener<NodeContext<N>> listener) throws NullPointerException, NavigationServiceException {
        POMSession session = this.manager.getSession();
        NodeData data = this.dataCache.getNodeData(session, tree.root.data.id);
        if (data == null) {
            throw new NavigationServiceException(NavigationError.UPDATE_CONCURRENTLY_REMOVED_NODE);
        }
        TreeContext<N> rebased = this.rebase(tree, tree.origin());
        NavigationPersister persister = new NavigationPersister(session);
        NodeChangeQueue changes = rebased.getChanges();
        if (changes != null) {
            NodeContext a;
            changes.broadcast(persister);
            for (Map.Entry entry : persister.toPersist.entrySet()) {
                a = tree.getNode((String)entry.getKey());
                a.handle = (String)entry.getValue();
            }
            for (String ddd : persister.toUpdate) {
                a = tree.getNode(ddd);
                a.data = new NodeData(a);
                a.name = null;
                a.state = null;
            }
            changes.clear();
            tree.getChanges().clear();
        }
        TreeUpdate.perform(tree, NodeContextUpdateAdapter.create(), (Object)rebased.root, NodeContextUpdateAdapter.create(), listener, rebased);
        session.save();
        this.dataCache.removeNodeData(session, persister.toEvict);
    }

    private <N> void rebaseTree(TreeContext<N> tree, Scope.Visitor visitor, NodeChangeListener<NodeContext<N>> listener) throws NavigationServiceException {
        if (!tree.hasChanges()) {
            this.updateTree(tree, visitor, listener);
        } else {
            TreeContext<N> rebased = this.rebase(tree, visitor);
            TreeUpdate.perform(tree, NodeContextUpdateAdapter.create(), (Object)rebased.root, NodeContextUpdateAdapter.create(), listener, rebased);
        }
    }

    private <N> TreeContext<N> rebase(TreeContext<N> tree, Scope.Visitor visitor) throws NavigationServiceException {
        POMSession session = this.manager.getSession();
        NodeData data = this.dataCache.getNodeData(session, tree.root.getId());
        if (data == null) {
            throw new NavigationServiceException(NavigationError.UPDATE_CONCURRENTLY_REMOVED_NODE);
        }
        TreeContext rebased = new NodeContext((NodeModel)tree.model, (NodeData)data).tree;
        TreeUpdate.perform((TreeContext)rebased, NodeContextUpdateAdapter.create(), (Object)data, (TreeUpdateAdapter)NodeDataUpdateAdapter.create(this.dataCache, session), null, (Scope.Visitor)visitor);
        NodeChangeQueue changes = tree.getChanges();
        TreeMerge merger = new TreeMerge(rebased, (NodeChangeListener)rebased);
        if (changes != null) {
            changes.broadcast((NodeChangeListener)merger);
        }
        return rebased;
    }

    private static class NavigationPersister<N>
    extends NodeChangeListener.Base<NodeContext<N>> {
        private final Map<String, String> toPersist = new HashMap<String, String>();
        private final Set<String> toUpdate = new HashSet<String>();
        private final Set<String> toEvict;
        private final POMSession session;

        private NavigationPersister(POMSession session) {
            this.session = session;
            this.toEvict = new HashSet<String>();
        }

        public void onCreate(NodeContext<N> target, NodeContext<N> parent, NodeContext<N> previous, String name) throws NavigationServiceException {
            Navigation parentNav = (Navigation)this.session.findObjectById(ObjectType.NAVIGATION, parent.data.id);
            this.toEvict.add(parentNav.getObjectId());
            int index = 0;
            if (previous != null) {
                Navigation previousNav = (Navigation)this.session.findObjectById(ObjectType.NAVIGATION, previous.data.id);
                index = previousNav.getIndex() + 1;
            }
            Navigation sourceNav = parentNav.addChild(Integer.valueOf(index), name);
            parent.data = NavigationUtils.getNodeData(parentNav);
            this.toPersist.put(target.handle, sourceNav.getObjectId());
            target.data = NavigationUtils.getNodeData(sourceNav);
            target.handle = target.data.id;
            target.name = null;
            target.state = null;
            this.toUpdate.add(parent.handle);
            this.toUpdate.add(target.handle);
        }

        public void onDestroy(NodeContext<N> target, NodeContext<N> parent) {
            Navigation parentNav = (Navigation)this.session.findObjectById(ObjectType.NAVIGATION, parent.data.id);
            Navigation sourceNav = (Navigation)this.session.findObjectById(ObjectType.NAVIGATION, target.data.id);
            this.toEvict.add(parentNav.getObjectId());
            sourceNav.destroy();
            parent.data = NavigationUtils.getNodeData(parentNav);
            this.toUpdate.add(parent.handle);
            this.destroy(target);
        }

        private void destroy(NodeContext<N> ctx) {
            this.toPersist.values().remove(ctx.handle);
            this.toUpdate.remove(ctx.handle);
            this.toEvict.add(ctx.handle);
            if (ctx.isExpanded()) {
                for (NodeContext child = (NodeContext)ctx.getFirst(); child != null; child = (NodeContext)child.getNext()) {
                    this.destroy(child);
                }
            }
        }

        public void onUpdate(NodeContext<N> source, NodeState state) throws NavigationServiceException {
            Navigation sourceNav = (Navigation)this.session.findObjectById(ObjectType.NAVIGATION, source.data.id);
            this.toEvict.add(sourceNav.getObjectId());
            Workspace workspace = sourceNav.getSite().getWorkspace();
            PageKey reference = state.getPageRef();
            if (reference != null) {
                ObjectType siteType = Utils.objectType((SiteType)reference.getSite().getType());
                Site site = workspace.getSite(siteType, reference.getSite().getName());
                Page target = site.getRootPage().getChild("pages").getChild(reference.getName());
                PageLink link = (PageLink)sourceNav.linkTo(ObjectType.PAGE_LINK);
                link.setPage(target);
            } else {
                PageLink link = (PageLink)sourceNav.linkTo(ObjectType.PAGE_LINK);
                link.setPage(null);
            }
            Described described = (Described)sourceNav.adapt(Described.class);
            described.setName(state.getLabel());
            Visible visible = (Visible)sourceNav.adapt(Visible.class);
            visible.setVisibility(state.getVisibility());
            visible.setStartPublicationDate(state.getStartPublicationDate());
            visible.setEndPublicationDate(state.getEndPublicationDate());
            Attributes attrs = sourceNav.getAttributes();
            attrs.setValue(MappedAttributes.ICON, (Object)state.getIcon());
            source.data = NavigationUtils.getNodeData(sourceNav);
            source.state = null;
            this.toUpdate.add(source.handle);
        }

        public void onMove(NodeContext<N> target, NodeContext<N> from, NodeContext<N> to, NodeContext<N> previous) throws NavigationServiceException {
            int index;
            Navigation sourceNav = (Navigation)this.session.findObjectById(ObjectType.NAVIGATION, target.data.id);
            Navigation fromNav = (Navigation)this.session.findObjectById(ObjectType.NAVIGATION, from.data.id);
            Navigation toNav = (Navigation)this.session.findObjectById(ObjectType.NAVIGATION, to.data.id);
            this.toEvict.add(sourceNav.getObjectId());
            this.toEvict.add(fromNav.getObjectId());
            this.toEvict.add(toNav.getObjectId());
            if (previous != null) {
                Navigation previousNav = (Navigation)this.session.findObjectById(ObjectType.NAVIGATION, previous.data.id);
                index = previousNav.getIndex() + 1;
            } else {
                index = 0;
            }
            toNav.getChildren().add(index, sourceNav);
            from.data = NavigationUtils.getNodeData(fromNav);
            to.data = NavigationUtils.getNodeData(toNav);
            target.data = NavigationUtils.getNodeData(sourceNav);
            this.toUpdate.add(target.handle);
            this.toUpdate.add(from.handle);
            this.toUpdate.add(to.handle);
        }

        public void onRename(NodeContext<N> target, NodeContext<N> parent, String name) throws NavigationServiceException {
            Navigation sourceNav = (Navigation)this.session.findObjectById(ObjectType.NAVIGATION, target.data.id);
            Navigation parentNav = (Navigation)this.session.findObjectById(ObjectType.NAVIGATION, parent.data.id);
            this.toEvict.add(sourceNav.getObjectId());
            this.toEvict.add(parentNav.getObjectId());
            sourceNav.setName(name);
            target.data = NavigationUtils.getNodeData(sourceNav);
            target.name = null;
            parent.data = NavigationUtils.getNodeData(parentNav);
            this.toUpdate.add(parent.handle);
            this.toUpdate.add(target.handle);
        }
    }

    private static class NodeDataUpdateAdapter
    implements TreeUpdateAdapter<NodeData> {
        private final DataCache dataCache;
        private final POMSession session;

        static NodeDataUpdateAdapter create(DataCache dataCache, POMSession session) {
            return new NodeDataUpdateAdapter(dataCache, session);
        }

        private NodeDataUpdateAdapter(DataCache dataCache, POMSession session) {
            this.dataCache = dataCache;
            this.session = session;
        }

        public String getHandle(NodeData node) {
            return node.id;
        }

        public String[] getChildren(NodeData node) {
            return node.children;
        }

        public NodeData getDescendant(NodeData node, String handle) {
            NodeData data;
            NodeData current = data = this.dataCache.getNodeData(this.session, handle);
            while (current != null) {
                if (node.id.equals(current.id)) {
                    return data;
                }
                if (current.parentId != null) {
                    current = this.dataCache.getNodeData(this.session, current.parentId);
                    continue;
                }
                current = null;
            }
            return null;
        }

        public NodeData getData(NodeData node) {
            return node;
        }

        public NodeState getState(NodeData node) {
            return null;
        }

        public String getName(NodeData node) {
            return null;
        }
    }

    private static class NodeContextUpdateAdapter<N>
    implements TreeUpdateAdapter<NodeContext<N>> {
        private static final NodeContextUpdateAdapter<?> _instance = new NodeContextUpdateAdapter();

        private NodeContextUpdateAdapter() {
        }

        static <N> NodeContextUpdateAdapter<N> create() {
            NodeContextUpdateAdapter<?> instance = _instance;
            return instance;
        }

        public String getHandle(NodeContext<N> node) {
            return node.handle;
        }

        public String[] getChildren(NodeContext<N> node) {
            if (node.getFirst() != null) {
                ArrayList<String> tmp = new ArrayList<String>();
                for (NodeContext current = (NodeContext)node.getFirst(); current != null; current = (NodeContext)current.getNext()) {
                    tmp.add(current.handle);
                }
                return tmp.toArray(new String[tmp.size()]);
            }
            return Utils.EMPTY_STRING_ARRAY;
        }

        public NodeContext<N> getDescendant(NodeContext<N> node, String handle) {
            return node.getDescendant(handle);
        }

        public NodeData getData(NodeContext<N> node) {
            return node.data;
        }

        public NodeState getState(NodeContext<N> node) {
            return node.state;
        }

        public String getName(NodeContext<N> node) {
            return node.name;
        }
    }
}

