/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.include;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.exoplatform.wiki.rendering.macro.include.IncludePageMacroParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component(value="includepage")
public class IncludePageMacro
extends AbstractMacro<IncludePageMacroParameters> {
    private static final String DESCRIPTION = "Includes the contents of a page within current";

    public IncludePageMacro() {
        super("Include Page", DESCRIPTION, IncludePageMacroParameters.class);
        this.setDefaultCategory("Content");
    }

    public List<Block> execute(IncludePageMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        RawBlock includePageBlock = new RawBlock("<exo-wiki-include-page page-name=\"" + parameters.getPage() + "\"></exo-wiki-include-page>", Syntax.XHTML_1_0);
        GroupBlock container = new GroupBlock(Arrays.asList(includePageBlock));
        container.setParameter("class", "wiki-include-page");
        return Collections.singletonList(container);
    }

    public boolean supportsInlineMode() {
        return true;
    }
}

