/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.impl;

import java.util.Map;
import org.xwiki.rendering.internal.renderer.xhtml.XHTMLChainingRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.image.XHTMLImageRenderer;
import org.xwiki.rendering.internal.renderer.xhtml.link.XHTMLLinkRenderer;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;

public class CustomXHTMLChainingRenderer
extends XHTMLChainingRenderer {
    private int rowCount = 0;

    public CustomXHTMLChainingRenderer(XHTMLLinkRenderer linkRenderer, XHTMLImageRenderer imageRenderer, ListenerChain listenerChain) {
        super(linkRenderer, imageRenderer, listenerChain);
    }

    public void beginTable(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLStartElement("figure", parameters);
        this.rowCount = 0;
        super.beginTable(parameters);
    }

    public void endTable(Map<String, String> parameters) {
        this.getXHTMLWikiPrinter().printXMLEndElement("tbody");
        super.endTable(parameters);
        this.getXHTMLWikiPrinter().printXMLEndElement("figure");
    }

    public void beginTableRow(Map<String, String> parameters) {
        if (this.rowCount == 0) {
            this.getXHTMLWikiPrinter().printXMLStartElement("thead");
        } else if (this.rowCount == 1) {
            this.getXHTMLWikiPrinter().printXMLStartElement("tbody");
        }
        super.beginTableRow(parameters);
    }

    public void endTableRow(Map<String, String> parameters) {
        super.endTableRow(parameters);
        if (this.rowCount == 0) {
            this.getXHTMLWikiPrinter().printXMLEndElement("thead");
        }
        ++this.rowCount;
    }

    public void onImage(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        if (reference.getType().equals((Object)ResourceType.ICON)) {
            switch (reference.getReference()) {
                case "emoticon_smile": {
                    this.getXHTMLWikiPrinter().printRaw("&#x1F642\ufe0f");
                    break;
                }
                case "emoticon_unhappy": {
                    this.getXHTMLWikiPrinter().printRaw("&#x1F641\ufe0f");
                    break;
                }
                case "emoticon_tongue": {
                    this.getXHTMLWikiPrinter().printRaw("&#x1F61B;");
                    break;
                }
                case "emoticon_grin": {
                    this.getXHTMLWikiPrinter().printRaw("&#x1F600;");
                    break;
                }
                case "emoticon_wink": {
                    this.getXHTMLWikiPrinter().printRaw("&#x1F609;");
                    break;
                }
                case "thumb_up": {
                    this.getXHTMLWikiPrinter().printRaw("&#x1F44D;");
                    break;
                }
                case "thumb_down": {
                    this.getXHTMLWikiPrinter().printRaw("&#x1F44E;");
                    break;
                }
                case "information": {
                    this.getXHTMLWikiPrinter().printRaw("\u2139\ufe0f");
                    break;
                }
                case "accept": {
                    this.getXHTMLWikiPrinter().printRaw("\u2705\ufe0f");
                    break;
                }
                case "cancel": {
                    this.getXHTMLWikiPrinter().printRaw("\u274c");
                    break;
                }
                case "error": {
                    this.getXHTMLWikiPrinter().printRaw("\u26a0\ufe0f");
                    break;
                }
                case "add": {
                    this.getXHTMLWikiPrinter().printRaw("\u2795");
                    break;
                }
                case "delete": {
                    this.getXHTMLWikiPrinter().printRaw("\u2796");
                    break;
                }
                case "help": {
                    this.getXHTMLWikiPrinter().printRaw("\u2753");
                    break;
                }
                case "lightbulb": {
                    this.getXHTMLWikiPrinter().printRaw("&#x1F4A1;");
                    break;
                }
                case "lightbulb_off": {
                    this.getXHTMLWikiPrinter().printRaw("&#x1F3C1;");
                    break;
                }
                case "star": {
                    this.getXHTMLWikiPrinter().printRaw("\u2b50");
                    break;
                }
            }
        } else {
            super.onImage(reference, isFreeStandingURI, parameters);
        }
    }

    public void onVerbatim(String protectedString, boolean isInline, Map<String, String> parameters) {
        if (isInline) {
            this.getXHTMLWikiPrinter().printXMLStartElement("tt", (String[][])new String[][]{{"class", "wikimodel-verbatim"}});
            this.getXHTMLWikiPrinter().printXML(protectedString);
            this.getXHTMLWikiPrinter().printXMLEndElement("tt");
        } else {
            this.getXHTMLWikiPrinter().printXMLStartElement("pre", parameters);
            this.getXHTMLWikiPrinter().printXMLStartElement("code", (String[][])new String[][]{{"class", "language-plaintext"}});
            this.getXHTMLWikiPrinter().printXML(protectedString);
            this.getXHTMLWikiPrinter().printXMLEndElement("code");
            this.getXHTMLWikiPrinter().printXMLEndElement("pre");
        }
    }
}

