package org.exoplatform.addon.ethereum.wallet.contract;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import rx.Observable;
import rx.functions.Func1;

/**
 * <p>Auto generated code.
 * <p><strong>Do not modify!</strong>
 * <p>Please use the <a href="https://docs.web3j.io/command_line.html">web3j command line tools</a>,
 * or the org.web3j.codegen.SolidityFunctionWrapperGenerator in the 
 * <a href="https://github.com/web3j/web3j/tree/master/codegen">codegen module</a> to update.
 *
 * <p>Generated with web3j version 3.6.0.
 */
public class ERTToken extends Contract {
    private static final String BINARY = "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";

    public static final String FUNC_VERSION = "version";

    public static final String FUNC_PAUSED = "paused";

    public static final String FUNC_UPGRADEDATA = "upgradeData";

    public static final String FUNC_OWNER = "owner";

    public static final String FUNC_SETPROXY = "setProxy";

    public static final String FUNC_UPGRADEIMPLEMENTATION = "upgradeImplementation";

    public static final String FUNC_IMPLEMENTATIONADDRESS = "implementationAddress";

    public static final String FUNC_PROXY = "proxy";

    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";

    public static final Event UPGRADED_EVENT = new Event("Upgraded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint16>() {}, new TypeReference<Address>() {}));
    ;

    public static final Event UPGRADEDDATA_EVENT = new Event("UpgradedData", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint16>() {}, new TypeReference<Address>() {}));
    ;

    public static final Event TRANSFEROWNERSHIP_EVENT = new Event("TransferOwnership", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    public static final Event TRANSFERPROXYOWNERSHIP_EVENT = new Event("TransferProxyOwnership", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    @Deprecated
    protected ERTToken(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected ERTToken(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected ERTToken(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected ERTToken(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public RemoteCall<BigInteger> version() {
        final Function function = new Function(FUNC_VERSION, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint16>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> paused() {
        final Function function = new Function(FUNC_PAUSED, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> upgradeData(BigInteger _dataVersion, String _dataAddress) {
        final Function function = new Function(
                FUNC_UPGRADEDATA, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint16(_dataVersion), 
                new org.web3j.abi.datatypes.Address(_dataAddress)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> owner() {
        final Function function = new Function(FUNC_OWNER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> setProxy(String _proxy) {
        final Function function = new Function(
                FUNC_SETPROXY, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_proxy)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> upgradeImplementation(BigInteger _version, String _newImplementation) {
        final Function function = new Function(
                FUNC_UPGRADEIMPLEMENTATION, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint16(_version), 
                new org.web3j.abi.datatypes.Address(_newImplementation)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> implementationAddress() {
        final Function function = new Function(FUNC_IMPLEMENTATIONADDRESS, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<String> proxy() {
        final Function function = new Function(FUNC_PROXY, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> transferOwnership(String _newOwner) {
        final Function function = new Function(
                FUNC_TRANSFEROWNERSHIP, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_newOwner)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public static RemoteCall<ERTToken> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String _implementationAddress, String _dataAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_implementationAddress), 
                new org.web3j.abi.datatypes.Address(_dataAddress)));
        return deployRemoteCall(ERTToken.class, web3j, credentials, contractGasProvider, BINARY, encodedConstructor);
    }

    public static RemoteCall<ERTToken> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String _implementationAddress, String _dataAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_implementationAddress), 
                new org.web3j.abi.datatypes.Address(_dataAddress)));
        return deployRemoteCall(ERTToken.class, web3j, transactionManager, contractGasProvider, BINARY, encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<ERTToken> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String _implementationAddress, String _dataAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_implementationAddress), 
                new org.web3j.abi.datatypes.Address(_dataAddress)));
        return deployRemoteCall(ERTToken.class, web3j, credentials, gasPrice, gasLimit, BINARY, encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<ERTToken> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String _implementationAddress, String _dataAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_implementationAddress), 
                new org.web3j.abi.datatypes.Address(_dataAddress)));
        return deployRemoteCall(ERTToken.class, web3j, transactionManager, gasPrice, gasLimit, BINARY, encodedConstructor);
    }

    public List<UpgradedEventResponse> getUpgradedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(UPGRADED_EVENT, transactionReceipt);
        ArrayList<UpgradedEventResponse> responses = new ArrayList<UpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedEventResponse typedResponse = new UpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.implementationVersion = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.implementationAddress = (String) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<UpgradedEventResponse> upgradedEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, UpgradedEventResponse>() {
            @Override
            public UpgradedEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(UPGRADED_EVENT, log);
                UpgradedEventResponse typedResponse = new UpgradedEventResponse();
                typedResponse.log = log;
                typedResponse.implementationVersion = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.implementationAddress = (String) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<UpgradedEventResponse> upgradedEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(UPGRADED_EVENT));
        return upgradedEventObservable(filter);
    }

    public List<UpgradedDataEventResponse> getUpgradedDataEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(UPGRADEDDATA_EVENT, transactionReceipt);
        ArrayList<UpgradedDataEventResponse> responses = new ArrayList<UpgradedDataEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedDataEventResponse typedResponse = new UpgradedDataEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.dataVersion = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.DataAddress = (String) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<UpgradedDataEventResponse> upgradedDataEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, UpgradedDataEventResponse>() {
            @Override
            public UpgradedDataEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(UPGRADEDDATA_EVENT, log);
                UpgradedDataEventResponse typedResponse = new UpgradedDataEventResponse();
                typedResponse.log = log;
                typedResponse.dataVersion = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.DataAddress = (String) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<UpgradedDataEventResponse> upgradedDataEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(UPGRADEDDATA_EVENT));
        return upgradedDataEventObservable(filter);
    }

    public List<TransferOwnershipEventResponse> getTransferOwnershipEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, transactionReceipt);
        ArrayList<TransferOwnershipEventResponse> responses = new ArrayList<TransferOwnershipEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newOwner = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TransferOwnershipEventResponse> transferOwnershipEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, TransferOwnershipEventResponse>() {
            @Override
            public TransferOwnershipEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, log);
                TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
                typedResponse.log = log;
                typedResponse.newOwner = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TransferOwnershipEventResponse> transferOwnershipEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSFEROWNERSHIP_EVENT));
        return transferOwnershipEventObservable(filter);
    }

    public List<TransferProxyOwnershipEventResponse> getTransferProxyOwnershipEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSFERPROXYOWNERSHIP_EVENT, transactionReceipt);
        ArrayList<TransferProxyOwnershipEventResponse> responses = new ArrayList<TransferProxyOwnershipEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferProxyOwnershipEventResponse typedResponse = new TransferProxyOwnershipEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.proxy = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TransferProxyOwnershipEventResponse> transferProxyOwnershipEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, TransferProxyOwnershipEventResponse>() {
            @Override
            public TransferProxyOwnershipEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSFERPROXYOWNERSHIP_EVENT, log);
                TransferProxyOwnershipEventResponse typedResponse = new TransferProxyOwnershipEventResponse();
                typedResponse.log = log;
                typedResponse.proxy = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TransferProxyOwnershipEventResponse> transferProxyOwnershipEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSFERPROXYOWNERSHIP_EVENT));
        return transferProxyOwnershipEventObservable(filter);
    }

    @Deprecated
    public static ERTToken load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTToken(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static ERTToken load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTToken(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static ERTToken load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new ERTToken(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static ERTToken load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new ERTToken(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static class UpgradedEventResponse {
        public Log log;

        public BigInteger implementationVersion;

        public String implementationAddress;
    }

    public static class UpgradedDataEventResponse {
        public Log log;

        public BigInteger dataVersion;

        public String DataAddress;
    }

    public static class TransferOwnershipEventResponse {
        public Log log;

        public String newOwner;
    }

    public static class TransferProxyOwnershipEventResponse {
        public Log log;

        public String proxy;
    }
}
