package org.exoplatform.addon.ethereum.wallet.contract;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import rx.Observable;
import rx.functions.Func1;

/**
 * <p>Auto generated code.
 * <p><strong>Do not modify!</strong>
 * <p>Please use the <a href="https://docs.web3j.io/command_line.html">web3j command line tools</a>,
 * or the org.web3j.codegen.SolidityFunctionWrapperGenerator in the 
 * <a href="https://github.com/web3j/web3j/tree/master/codegen">codegen module</a> to update.
 *
 * <p>Generated with web3j version 3.6.0.
 */
public class ERTTokenV1 extends Contract {
    private static final String BINARY = "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";

    public static final String FUNC_NAME = "name";

    public static final String FUNC_APPROVE = "approve";

    public static final String FUNC_GETALLOWANCE = "getAllowance";

    public static final String FUNC_INITIALIZED = "initialized";

    public static final String FUNC_REMOVEADMIN = "removeAdmin";

    public static final String FUNC_TOTALSUPPLY = "totalSupply";

    public static final String FUNC_TRANSFERFROM = "transferFrom";

    public static final String FUNC_DECIMALS = "decimals";

    public static final String FUNC_GETSELLPRICE = "getSellPrice";

    public static final String FUNC_ISADMIN = "isAdmin";

    public static final String FUNC_ADDADMIN = "addAdmin";

    public static final String FUNC_VERSION = "version";

    public static final String FUNC_UPGRADEIMPLEMENTATIONTO = "upgradeImplementationTo";

    public static final String FUNC_PAUSED = "paused";

    public static final String FUNC_DISAPPROVEACCOUNT = "disapproveAccount";

    public static final String FUNC_BALANCEOF = "balanceOf";

    public static final String FUNC_PAUSE = "pause";

    public static final String FUNC_OWNER = "owner";

    public static final String FUNC_GETDATAADDRESS = "getDataAddress";

    public static final String FUNC_SYMBOL = "symbol";

    public static final String FUNC_SETPROXY = "setProxy";

    public static final String FUNC_TRANSFER = "transfer";

    public static final String FUNC_ISAPPROVEDACCOUNT = "isApprovedAccount";

    public static final String FUNC_GETADMINLEVEL = "getAdminLevel";

    public static final String FUNC_ISPAUSED = "isPaused";

    public static final String FUNC_SETSYMBOL = "setSymbol";

    public static final String FUNC_IMPLEMENTATIONADDRESS = "implementationAddress";

    public static final String FUNC_SETNAME = "setName";

    public static final String FUNC_ALLOWANCE = "allowance";

    public static final String FUNC_INITIALIZE = "initialize";

    public static final String FUNC_BALANCE = "balance";

    public static final String FUNC_PROXY = "proxy";

    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";

    public static final String FUNC_UNPAUSE = "unPause";

    public static final String FUNC_APPROVEACCOUNT = "approveAccount";

    public static final String FUNC_SETSELLPRICE = "setSellPrice";

    public static final Event TOKENPRICECHANGED_EVENT = new Event("TokenPriceChanged", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
    ;

    public static final Event TRANSACTIONFEE_EVENT = new Event("TransactionFee", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event NOSUFFICIENTFUND_EVENT = new Event("NoSufficientFund", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
    ;

    public static final Event DEPOSITRECEIVED_EVENT = new Event("DepositReceived", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event TRANSFER_EVENT = new Event("Transfer", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event APPROVAL_EVENT = new Event("Approval", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event APPROVEDACCOUNT_EVENT = new Event("ApprovedAccount", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    public static final Event DISAPPROVEDACCOUNT_EVENT = new Event("DisapprovedAccount", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    public static final Event CONTRACTPAUSED_EVENT = new Event("ContractPaused", 
            Arrays.<TypeReference<?>>asList());
    ;

    public static final Event CONTRACTUNPAUSED_EVENT = new Event("ContractUnPaused", 
            Arrays.<TypeReference<?>>asList());
    ;

    public static final Event ADDEDADMIN_EVENT = new Event("AddedAdmin", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Uint8>() {}));
    ;

    public static final Event REMOVEDADMIN_EVENT = new Event("RemovedAdmin", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    public static final Event TRANSFEROWNERSHIP_EVENT = new Event("TransferOwnership", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    public static final Event TRANSFERPROXYOWNERSHIP_EVENT = new Event("TransferProxyOwnership", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    @Deprecated
    protected ERTTokenV1(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected ERTTokenV1(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected ERTTokenV1(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected ERTTokenV1(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public RemoteCall<String> name() {
        final Function function = new Function(FUNC_NAME, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> approve(String _spender, BigInteger _value) {
        final Function function = new Function(
                FUNC_APPROVE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_spender), 
                new org.web3j.abi.datatypes.generated.Uint256(_value)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> getAllowance(String _account, String _spender) {
        final Function function = new Function(FUNC_GETALLOWANCE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_account), 
                new org.web3j.abi.datatypes.Address(_spender)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> initialized() {
        final Function function = new Function(FUNC_INITIALIZED, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> removeAdmin(String _target) {
        final Function function = new Function(
                FUNC_REMOVEADMIN, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> totalSupply() {
        final Function function = new Function(FUNC_TOTALSUPPLY, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> transferFrom(String _from, String _to, BigInteger _value) {
        final Function function = new Function(
                FUNC_TRANSFERFROM, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_from), 
                new org.web3j.abi.datatypes.Address(_to), 
                new org.web3j.abi.datatypes.generated.Uint256(_value)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> decimals() {
        final Function function = new Function(FUNC_DECIMALS, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint8>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<BigInteger> getSellPrice() {
        final Function function = new Function(FUNC_GETSELLPRICE, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> isAdmin(String _target, BigInteger _level) {
        final Function function = new Function(FUNC_ISADMIN, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target), 
                new org.web3j.abi.datatypes.generated.Uint8(_level)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> addAdmin(String _target, BigInteger _level) {
        final Function function = new Function(
                FUNC_ADDADMIN, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target), 
                new org.web3j.abi.datatypes.generated.Uint8(_level)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> version() {
        final Function function = new Function(FUNC_VERSION, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint16>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> upgradeImplementationTo(String _newImplementation) {
        final Function function = new Function(
                FUNC_UPGRADEIMPLEMENTATIONTO, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_newImplementation)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> paused() {
        final Function function = new Function(FUNC_PAUSED, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> disapproveAccount(String _target) {
        final Function function = new Function(
                FUNC_DISAPPROVEACCOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> balanceOf(String _target) {
        final Function function = new Function(FUNC_BALANCEOF, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> pause() {
        final Function function = new Function(
                FUNC_PAUSE, 
                Arrays.<Type>asList(), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> owner() {
        final Function function = new Function(FUNC_OWNER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<String> getDataAddress(BigInteger _version) {
        final Function function = new Function(FUNC_GETDATAADDRESS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint16(_version)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<String> symbol() {
        final Function function = new Function(FUNC_SYMBOL, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> setProxy(String _proxy) {
        final Function function = new Function(
                FUNC_SETPROXY, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_proxy)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> transfer(String _to, BigInteger _value) {
        final Function function = new Function(
                FUNC_TRANSFER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_to), 
                new org.web3j.abi.datatypes.generated.Uint256(_value)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<Boolean> isApprovedAccount(String _target) {
        final Function function = new Function(FUNC_ISAPPROVEDACCOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<BigInteger> getAdminLevel(String _target) {
        final Function function = new Function(FUNC_GETADMINLEVEL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint8>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<Boolean> isPaused() {
        final Function function = new Function(FUNC_ISPAUSED, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteCall<TransactionReceipt> setSymbol(String _symbol) {
        final Function function = new Function(
                FUNC_SETSYMBOL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(_symbol)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<String> implementationAddress() {
        final Function function = new Function(FUNC_IMPLEMENTATIONADDRESS, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> setName(String _name) {
        final Function function = new Function(
                FUNC_SETNAME, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(_name)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> allowance(String _target, String _spender) {
        final Function function = new Function(FUNC_ALLOWANCE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target), 
                new org.web3j.abi.datatypes.Address(_spender)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<TransactionReceipt> initialize(String _proxyAddress, BigInteger _initialAmount, String _tokenName, BigInteger _decimalUnits, String _tokenSymbol) {
        final Function function = new Function(
                FUNC_INITIALIZE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_proxyAddress), 
                new org.web3j.abi.datatypes.generated.Uint256(_initialAmount), 
                new org.web3j.abi.datatypes.Utf8String(_tokenName), 
                new org.web3j.abi.datatypes.generated.Uint8(_decimalUnits), 
                new org.web3j.abi.datatypes.Utf8String(_tokenSymbol)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<BigInteger> balance(String _target) {
        final Function function = new Function(FUNC_BALANCE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteCall<String> proxy() {
        final Function function = new Function(FUNC_PROXY, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> transferOwnership(String _newOwner) {
        final Function function = new Function(
                FUNC_TRANSFEROWNERSHIP, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_newOwner)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> unPause() {
        final Function function = new Function(
                FUNC_UNPAUSE, 
                Arrays.<Type>asList(), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> approveAccount(String _target) {
        final Function function = new Function(
                FUNC_APPROVEACCOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_target)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteCall<TransactionReceipt> setSellPrice(BigInteger _value) {
        final Function function = new Function(
                FUNC_SETSELLPRICE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_value)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String _dataAddress, String _proxyAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_dataAddress), 
                new org.web3j.abi.datatypes.Address(_proxyAddress)));
        return deployRemoteCall(ERTTokenV1.class, web3j, credentials, contractGasProvider, BINARY, encodedConstructor);
    }

    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String _dataAddress, String _proxyAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_dataAddress), 
                new org.web3j.abi.datatypes.Address(_proxyAddress)));
        return deployRemoteCall(ERTTokenV1.class, web3j, transactionManager, contractGasProvider, BINARY, encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String _dataAddress, String _proxyAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_dataAddress), 
                new org.web3j.abi.datatypes.Address(_proxyAddress)));
        return deployRemoteCall(ERTTokenV1.class, web3j, credentials, gasPrice, gasLimit, BINARY, encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String _dataAddress, String _proxyAddress) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_dataAddress), 
                new org.web3j.abi.datatypes.Address(_proxyAddress)));
        return deployRemoteCall(ERTTokenV1.class, web3j, transactionManager, gasPrice, gasLimit, BINARY, encodedConstructor);
    }

    public List<TokenPriceChangedEventResponse> getTokenPriceChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TOKENPRICECHANGED_EVENT, transactionReceipt);
        ArrayList<TokenPriceChangedEventResponse> responses = new ArrayList<TokenPriceChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TokenPriceChangedEventResponse typedResponse = new TokenPriceChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.tokenPrice = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TokenPriceChangedEventResponse> tokenPriceChangedEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, TokenPriceChangedEventResponse>() {
            @Override
            public TokenPriceChangedEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TOKENPRICECHANGED_EVENT, log);
                TokenPriceChangedEventResponse typedResponse = new TokenPriceChangedEventResponse();
                typedResponse.log = log;
                typedResponse.tokenPrice = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TokenPriceChangedEventResponse> tokenPriceChangedEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TOKENPRICECHANGED_EVENT));
        return tokenPriceChangedEventObservable(filter);
    }

    public List<TransactionFeeEventResponse> getTransactionFeeEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSACTIONFEE_EVENT, transactionReceipt);
        ArrayList<TransactionFeeEventResponse> responses = new ArrayList<TransactionFeeEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransactionFeeEventResponse typedResponse = new TransactionFeeEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.tokenFee = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            typedResponse.etherFeeRefund = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TransactionFeeEventResponse> transactionFeeEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, TransactionFeeEventResponse>() {
            @Override
            public TransactionFeeEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSACTIONFEE_EVENT, log);
                TransactionFeeEventResponse typedResponse = new TransactionFeeEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.tokenFee = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                typedResponse.etherFeeRefund = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TransactionFeeEventResponse> transactionFeeEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSACTIONFEE_EVENT));
        return transactionFeeEventObservable(filter);
    }

    public List<NoSufficientFundEventResponse> getNoSufficientFundEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(NOSUFFICIENTFUND_EVENT, transactionReceipt);
        ArrayList<NoSufficientFundEventResponse> responses = new ArrayList<NoSufficientFundEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            NoSufficientFundEventResponse typedResponse = new NoSufficientFundEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.balance = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<NoSufficientFundEventResponse> noSufficientFundEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, NoSufficientFundEventResponse>() {
            @Override
            public NoSufficientFundEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(NOSUFFICIENTFUND_EVENT, log);
                NoSufficientFundEventResponse typedResponse = new NoSufficientFundEventResponse();
                typedResponse.log = log;
                typedResponse.balance = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<NoSufficientFundEventResponse> noSufficientFundEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(NOSUFFICIENTFUND_EVENT));
        return noSufficientFundEventObservable(filter);
    }

    public List<DepositReceivedEventResponse> getDepositReceivedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(DEPOSITRECEIVED_EVENT, transactionReceipt);
        ArrayList<DepositReceivedEventResponse> responses = new ArrayList<DepositReceivedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DepositReceivedEventResponse typedResponse = new DepositReceivedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<DepositReceivedEventResponse> depositReceivedEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, DepositReceivedEventResponse>() {
            @Override
            public DepositReceivedEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(DEPOSITRECEIVED_EVENT, log);
                DepositReceivedEventResponse typedResponse = new DepositReceivedEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<DepositReceivedEventResponse> depositReceivedEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(DEPOSITRECEIVED_EVENT));
        return depositReceivedEventObservable(filter);
    }

    public List<TransferEventResponse> getTransferEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSFER_EVENT, transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferEventResponse typedResponse = new TransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TransferEventResponse> transferEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, TransferEventResponse>() {
            @Override
            public TransferEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSFER_EVENT, log);
                TransferEventResponse typedResponse = new TransferEventResponse();
                typedResponse.log = log;
                typedResponse._from = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._to = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TransferEventResponse> transferEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSFER_EVENT));
        return transferEventObservable(filter);
    }

    public List<ApprovalEventResponse> getApprovalEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(APPROVAL_EVENT, transactionReceipt);
        ArrayList<ApprovalEventResponse> responses = new ArrayList<ApprovalEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalEventResponse typedResponse = new ApprovalEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._owner = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse._spender = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<ApprovalEventResponse> approvalEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, ApprovalEventResponse>() {
            @Override
            public ApprovalEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(APPROVAL_EVENT, log);
                ApprovalEventResponse typedResponse = new ApprovalEventResponse();
                typedResponse.log = log;
                typedResponse._owner = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse._spender = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse._value = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<ApprovalEventResponse> approvalEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(APPROVAL_EVENT));
        return approvalEventObservable(filter);
    }

    public List<ApprovedAccountEventResponse> getApprovedAccountEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(APPROVEDACCOUNT_EVENT, transactionReceipt);
        ArrayList<ApprovedAccountEventResponse> responses = new ArrayList<ApprovedAccountEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovedAccountEventResponse typedResponse = new ApprovedAccountEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<ApprovedAccountEventResponse> approvedAccountEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, ApprovedAccountEventResponse>() {
            @Override
            public ApprovedAccountEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(APPROVEDACCOUNT_EVENT, log);
                ApprovedAccountEventResponse typedResponse = new ApprovedAccountEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<ApprovedAccountEventResponse> approvedAccountEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(APPROVEDACCOUNT_EVENT));
        return approvedAccountEventObservable(filter);
    }

    public List<DisapprovedAccountEventResponse> getDisapprovedAccountEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(DISAPPROVEDACCOUNT_EVENT, transactionReceipt);
        ArrayList<DisapprovedAccountEventResponse> responses = new ArrayList<DisapprovedAccountEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DisapprovedAccountEventResponse typedResponse = new DisapprovedAccountEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<DisapprovedAccountEventResponse> disapprovedAccountEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, DisapprovedAccountEventResponse>() {
            @Override
            public DisapprovedAccountEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(DISAPPROVEDACCOUNT_EVENT, log);
                DisapprovedAccountEventResponse typedResponse = new DisapprovedAccountEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<DisapprovedAccountEventResponse> disapprovedAccountEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(DISAPPROVEDACCOUNT_EVENT));
        return disapprovedAccountEventObservable(filter);
    }

    public List<ContractPausedEventResponse> getContractPausedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(CONTRACTPAUSED_EVENT, transactionReceipt);
        ArrayList<ContractPausedEventResponse> responses = new ArrayList<ContractPausedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ContractPausedEventResponse typedResponse = new ContractPausedEventResponse();
            typedResponse.log = eventValues.getLog();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<ContractPausedEventResponse> contractPausedEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, ContractPausedEventResponse>() {
            @Override
            public ContractPausedEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(CONTRACTPAUSED_EVENT, log);
                ContractPausedEventResponse typedResponse = new ContractPausedEventResponse();
                typedResponse.log = log;
                return typedResponse;
            }
        });
    }

    public Observable<ContractPausedEventResponse> contractPausedEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(CONTRACTPAUSED_EVENT));
        return contractPausedEventObservable(filter);
    }

    public List<ContractUnPausedEventResponse> getContractUnPausedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(CONTRACTUNPAUSED_EVENT, transactionReceipt);
        ArrayList<ContractUnPausedEventResponse> responses = new ArrayList<ContractUnPausedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ContractUnPausedEventResponse typedResponse = new ContractUnPausedEventResponse();
            typedResponse.log = eventValues.getLog();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<ContractUnPausedEventResponse> contractUnPausedEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, ContractUnPausedEventResponse>() {
            @Override
            public ContractUnPausedEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(CONTRACTUNPAUSED_EVENT, log);
                ContractUnPausedEventResponse typedResponse = new ContractUnPausedEventResponse();
                typedResponse.log = log;
                return typedResponse;
            }
        });
    }

    public Observable<ContractUnPausedEventResponse> contractUnPausedEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(CONTRACTUNPAUSED_EVENT));
        return contractUnPausedEventObservable(filter);
    }

    public List<AddedAdminEventResponse> getAddedAdminEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(ADDEDADMIN_EVENT, transactionReceipt);
        ArrayList<AddedAdminEventResponse> responses = new ArrayList<AddedAdminEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AddedAdminEventResponse typedResponse = new AddedAdminEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.level = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<AddedAdminEventResponse> addedAdminEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, AddedAdminEventResponse>() {
            @Override
            public AddedAdminEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(ADDEDADMIN_EVENT, log);
                AddedAdminEventResponse typedResponse = new AddedAdminEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.level = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<AddedAdminEventResponse> addedAdminEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(ADDEDADMIN_EVENT));
        return addedAdminEventObservable(filter);
    }

    public List<RemovedAdminEventResponse> getRemovedAdminEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(REMOVEDADMIN_EVENT, transactionReceipt);
        ArrayList<RemovedAdminEventResponse> responses = new ArrayList<RemovedAdminEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RemovedAdminEventResponse typedResponse = new RemovedAdminEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<RemovedAdminEventResponse> removedAdminEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, RemovedAdminEventResponse>() {
            @Override
            public RemovedAdminEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(REMOVEDADMIN_EVENT, log);
                RemovedAdminEventResponse typedResponse = new RemovedAdminEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<RemovedAdminEventResponse> removedAdminEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(REMOVEDADMIN_EVENT));
        return removedAdminEventObservable(filter);
    }

    public List<TransferOwnershipEventResponse> getTransferOwnershipEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, transactionReceipt);
        ArrayList<TransferOwnershipEventResponse> responses = new ArrayList<TransferOwnershipEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newOwner = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TransferOwnershipEventResponse> transferOwnershipEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, TransferOwnershipEventResponse>() {
            @Override
            public TransferOwnershipEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, log);
                TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
                typedResponse.log = log;
                typedResponse.newOwner = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TransferOwnershipEventResponse> transferOwnershipEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSFEROWNERSHIP_EVENT));
        return transferOwnershipEventObservable(filter);
    }

    public List<TransferProxyOwnershipEventResponse> getTransferProxyOwnershipEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = extractEventParametersWithLog(TRANSFERPROXYOWNERSHIP_EVENT, transactionReceipt);
        ArrayList<TransferProxyOwnershipEventResponse> responses = new ArrayList<TransferProxyOwnershipEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferProxyOwnershipEventResponse typedResponse = new TransferProxyOwnershipEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.proxy = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Observable<TransferProxyOwnershipEventResponse> transferProxyOwnershipEventObservable(EthFilter filter) {
        return web3j.ethLogObservable(filter).map(new Func1<Log, TransferProxyOwnershipEventResponse>() {
            @Override
            public TransferProxyOwnershipEventResponse call(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSFERPROXYOWNERSHIP_EVENT, log);
                TransferProxyOwnershipEventResponse typedResponse = new TransferProxyOwnershipEventResponse();
                typedResponse.log = log;
                typedResponse.proxy = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Observable<TransferProxyOwnershipEventResponse> transferProxyOwnershipEventObservable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSFERPROXYOWNERSHIP_EVENT));
        return transferProxyOwnershipEventObservable(filter);
    }

    @Deprecated
    public static ERTTokenV1 load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTTokenV1(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static ERTTokenV1 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTTokenV1(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static ERTTokenV1 load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new ERTTokenV1(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static ERTTokenV1 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new ERTTokenV1(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static class TokenPriceChangedEventResponse {
        public Log log;

        public BigInteger tokenPrice;
    }

    public static class TransactionFeeEventResponse {
        public Log log;

        public String from;

        public BigInteger tokenFee;

        public BigInteger etherFeeRefund;
    }

    public static class NoSufficientFundEventResponse {
        public Log log;

        public BigInteger balance;
    }

    public static class DepositReceivedEventResponse {
        public Log log;

        public String from;

        public BigInteger amount;
    }

    public static class TransferEventResponse {
        public Log log;

        public String _from;

        public String _to;

        public BigInteger _value;
    }

    public static class ApprovalEventResponse {
        public Log log;

        public String _owner;

        public String _spender;

        public BigInteger _value;
    }

    public static class ApprovedAccountEventResponse {
        public Log log;

        public String target;
    }

    public static class DisapprovedAccountEventResponse {
        public Log log;

        public String target;
    }

    public static class ContractPausedEventResponse {
        public Log log;
    }

    public static class ContractUnPausedEventResponse {
        public Log log;
    }

    public static class AddedAdminEventResponse {
        public Log log;

        public String target;

        public BigInteger level;
    }

    public static class RemovedAdminEventResponse {
        public Log log;

        public String target;
    }

    public static class TransferOwnershipEventResponse {
        public Log log;

        public String newOwner;
    }

    public static class TransferProxyOwnershipEventResponse {
        public Log log;

        public String proxy;
    }
}
