/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.AccountDetail;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.model.FundsRequest;
import org.exoplatform.addon.ethereum.wallet.model.GlobalSettings;
import org.exoplatform.addon.ethereum.wallet.model.UserPreferences;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.json.JSONArray;
import org.picocontainer.Startable;

public class EthereumWalletService
implements Startable {
    private static final char[] SIMPLE_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletService.class);
    public static final String DEFAULT_NETWORK_ID = "defaultNetworkId";
    public static final String DEFAULT_NETWORK_URL = "defaultNetworkURL";
    public static final String DEFAULT_NETWORK_WS_URL = "defaultNetworkWSURL";
    public static final String DEFAULT_ACCESS_PERMISSION = "defaultAccessPermission";
    public static final String DEFAULT_GAS = "defaultGas";
    public static final String DEFAULT_BLOCKS_TO_RETRIEVE = "defaultBlocksToRetrieve";
    public static final String DEFAULT_CONTRACTS_ADDRESSES = "defaultContractAddresses";
    public static final String SCOPE_NAME = "ADDONS_ETHEREUM_WALLET";
    public static final String GLOBAL_SETTINGS_KEY_NAME = "GLOBAL_SETTINGS";
    public static final String ADDRESS_KEY_NAME = "ADDONS_ETHEREUM_WALLET_ADDRESS";
    public static final String LAST_BLOCK_NUMBER_KEY_NAME = "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER";
    public static final String SETTINGS_KEY_NAME = "ADDONS_ETHEREUM_WALLET_SETTINGS";
    public static final Context WALLET_CONTEXT = Context.GLOBAL;
    public static final Scope WALLET_SCOPE = Scope.APPLICATION.id("ADDONS_ETHEREUM_WALLET");
    public static final String WALLET_DEFAULT_CONTRACTS_NAME = "WALLET_DEFAULT_CONTRACTS";
    public static final String WALLET_USER_TRANSACTION_NAME = "WALLET_USER_TRANSACTION";
    public static final String WALLET_BROWSER_PHRASE_NAME = "WALLET_BROWSER_PHRASE";
    public static final String ABI_PATH_PARAMETER = "contract.abi.path";
    public static final String BIN_PATH_PARAMETER = "contract.bin.path";
    private SettingService settingService;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private ListenerService listenerService;
    private ConfigurationManager configurationManager;
    private GlobalSettings defaultSettings = new GlobalSettings();
    private GlobalSettings storedSettings;
    private String contractAbiPath;
    private JSONArray contractAbi;
    private String contractBinaryPath;
    private String contractBinary;

    public EthereumWalletService(SettingService settingService, SpaceService spaceService, IdentityManager identityManager, ListenerService listenerService, ConfigurationManager configurationManager, InitParams params) {
        String defaultContractsToDisplay;
        String value;
        this.configurationManager = configurationManager;
        this.settingService = settingService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.listenerService = listenerService;
        if (params.containsKey((Object)DEFAULT_NETWORK_ID)) {
            value = params.getValueParam(DEFAULT_NETWORK_ID).getValue();
            long defaultNetworkId = Long.parseLong(value);
            this.defaultSettings.setDefaultNetworkId(defaultNetworkId);
        }
        if (params.containsKey((Object)DEFAULT_NETWORK_URL)) {
            String defaultNetworkURL = params.getValueParam(DEFAULT_NETWORK_URL).getValue();
            this.defaultSettings.setProviderURL(defaultNetworkURL);
        }
        if (params.containsKey((Object)DEFAULT_ACCESS_PERMISSION)) {
            String defaultAccessPermission = params.getValueParam(DEFAULT_ACCESS_PERMISSION).getValue();
            this.defaultSettings.setAccessPermission(defaultAccessPermission);
        }
        if (params.containsKey((Object)DEFAULT_GAS)) {
            value = params.getValueParam(DEFAULT_GAS).getValue();
            int defaultGas = Integer.parseInt(value);
            this.defaultSettings.setDefaultGas(defaultGas);
        }
        if (params.containsKey((Object)DEFAULT_BLOCKS_TO_RETRIEVE)) {
            value = params.getValueParam(DEFAULT_BLOCKS_TO_RETRIEVE).getValue();
            int defaultBlocksToRetrieve = Integer.parseInt(value);
            this.defaultSettings.setDefaultBlocksToRetrieve(defaultBlocksToRetrieve);
        }
        if (params.containsKey((Object)DEFAULT_CONTRACTS_ADDRESSES) && StringUtils.isNotBlank((String)(defaultContractsToDisplay = params.getValueParam(DEFAULT_CONTRACTS_ADDRESSES).getValue()))) {
            List<String> defaultContracts = Arrays.stream(defaultContractsToDisplay.split(",")).map(contractAddress -> contractAddress.trim().toLowerCase()).filter(contractAddress -> !contractAddress.isEmpty()).collect(Collectors.toList());
            this.defaultSettings.setDefaultContractsToDisplay(defaultContracts);
        }
        if (params.containsKey((Object)ABI_PATH_PARAMETER)) {
            this.contractAbiPath = params.getValueParam(ABI_PATH_PARAMETER).getValue();
        }
        if (StringUtils.isBlank((String)this.contractAbiPath)) {
            LOG.warn((Object)"Contract ABI path is empty, thus no contract deployment is possible");
        }
        if (params.containsKey((Object)BIN_PATH_PARAMETER)) {
            this.contractBinaryPath = params.getValueParam(BIN_PATH_PARAMETER).getValue();
        }
        if (StringUtils.isBlank((String)this.contractBinaryPath)) {
            LOG.warn((Object)"Contract BIN path is empty, thus no contract deployment is possible");
        }
    }

    public void start() {
        try {
            String contractAbiString = IOUtil.getStreamContentAsString((InputStream)this.configurationManager.getInputStream(this.contractAbiPath));
            this.contractAbi = new JSONArray(contractAbiString);
            this.contractBinary = IOUtil.getStreamContentAsString((InputStream)this.configurationManager.getInputStream(this.contractBinaryPath));
            if (!this.contractBinary.startsWith("0x")) {
                this.contractBinary = "0x" + this.contractBinary;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Can't read ABI/BIN files content", (Throwable)e);
        }
    }

    public void stop() {
    }

    public JSONArray getContractAbi() {
        return this.contractAbi;
    }

    public String getContractBinary() {
        return this.contractBinary;
    }

    public void saveSettings(GlobalSettings newGlobalSettings) {
        if (newGlobalSettings == null) {
            throw new IllegalArgumentException("globalSettings parameter is mandatory");
        }
        GlobalSettings oldGlobalSettings = this.getSettings();
        this.settingService.set(WALLET_CONTEXT, WALLET_SCOPE, GLOBAL_SETTINGS_KEY_NAME, SettingValue.create((String)newGlobalSettings.toJSONString(false)));
        this.storedSettings = null;
        try {
            this.listenerService.broadcast("exo.addon.wallet.settings.changed", (Object)oldGlobalSettings, (Object)newGlobalSettings);
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while broadcasting wallet settings modification event", (Throwable)e);
        }
    }

    public GlobalSettings getSettings() {
        if (this.storedSettings != null) {
            return this.storedSettings;
        }
        this.storedSettings = this.getSettings(null);
        return this.storedSettings;
    }

    public GlobalSettings getSettings(Long networkId) {
        return this.getSettings(networkId, null);
    }

    public GlobalSettings getSettings(Long networkId, String spaceId) {
        SettingValue globalSettingsValue = this.settingService.get(WALLET_CONTEXT, WALLET_SCOPE, GLOBAL_SETTINGS_KEY_NAME);
        String username = Utils.getCurrentUserId();
        GlobalSettings globalSettings = this.defaultSettings;
        if (globalSettingsValue != null && globalSettingsValue.getValue() != null && StringUtils.isNotBlank((String)(globalSettings = GlobalSettings.parseStringToObject(this.defaultSettings, globalSettingsValue.getValue().toString())).getAccessPermission())) {
            Space space = this.spaceService.getSpaceByPrettyName(globalSettings.getAccessPermission());
            if (space == null && (space = this.spaceService.getSpaceByUrl(globalSettings.getAccessPermission())) == null) {
                space = this.spaceService.getSpaceByGroupId("/spaces/" + globalSettings.getAccessPermission());
            }
            if (username != null && space != null && !this.spaceService.isMember(space, username) && !this.spaceService.isSuperManager(username)) {
                globalSettings = new GlobalSettings();
                globalSettings.setWalletEnabled(false);
            }
        }
        if (globalSettings.isWalletEnabled()) {
            if ((networkId == null || networkId == 0L) && globalSettings.getDefaultNetworkId() != null) {
                networkId = globalSettings.getDefaultNetworkId();
            }
            globalSettings.setDefaultContractsToDisplay(this.getDefaultContractsAddresses(networkId));
            if (username != null) {
                SettingValue userSettingsValue = this.settingService.get(Context.USER.id(username), WALLET_SCOPE, SETTINGS_KEY_NAME);
                UserPreferences userSettings = null;
                userSettings = userSettingsValue != null && userSettingsValue.getValue() != null ? UserPreferences.parseStringToObject(userSettingsValue.getValue().toString()) : new UserPreferences();
                globalSettings.setUserPreferences(userSettings);
                if (StringUtils.isNotBlank((String)spaceId)) {
                    userSettings.setWalletAddress(this.getSpaceAddress(spaceId));
                    userSettings.setPhrase(this.getSpacePhrase(spaceId));
                } else {
                    userSettings.setWalletAddress(this.getUserAddress(username));
                    userSettings.setPhrase(this.getUserPhrase(username));
                }
            }
        }
        globalSettings.setContractAbi(this.getContractAbi());
        globalSettings.setContractBin(this.getContractBinary());
        return globalSettings;
    }

    public void saveDefaultContract(ContractDetail contractDetail) {
        if (StringUtils.isBlank((String)contractDetail.getAddress())) {
            throw new IllegalArgumentException("address parameter is mandatory");
        }
        if (contractDetail.getNetworkId() == null || contractDetail.getNetworkId() == 0L) {
            throw new IllegalArgumentException("networkId parameter is mandatory");
        }
        String defaultContractsParamKey = WALLET_DEFAULT_CONTRACTS_NAME + contractDetail.getNetworkId();
        String address = contractDetail.getAddress().toLowerCase();
        this.settingService.set(WALLET_CONTEXT, WALLET_SCOPE, address + contractDetail.getNetworkId(), SettingValue.create((String)contractDetail.toJSONString()));
        SettingValue defaultContractsAddressesValue = this.settingService.get(WALLET_CONTEXT, WALLET_SCOPE, defaultContractsParamKey);
        String defaultContractsAddresses = defaultContractsAddressesValue == null ? address : defaultContractsAddressesValue.getValue().toString() + "," + address;
        this.settingService.set(WALLET_CONTEXT, WALLET_SCOPE, defaultContractsParamKey, SettingValue.create((String)defaultContractsAddresses));
        this.storedSettings = null;
    }

    public boolean removeDefaultContract(String address, Long networkId) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn((Object)"Can't remove empty address for contract");
            return false;
        }
        if (networkId == null || networkId == 0L) {
            LOG.warn((Object)"Can't remove empty network id for contract");
            return false;
        }
        String defaultContractsParamKey = WALLET_DEFAULT_CONTRACTS_NAME + networkId;
        String defaultAddressToSave = address.toLowerCase();
        SettingValue defaultContractsAddressesValue = this.settingService.get(WALLET_CONTEXT, WALLET_SCOPE, defaultContractsParamKey);
        if (defaultContractsAddressesValue != null) {
            String[] contractAddresses = defaultContractsAddressesValue.getValue().toString().split(",");
            Set contractAddressList = Arrays.stream(contractAddresses).filter(contractAddress -> !contractAddress.equalsIgnoreCase(defaultAddressToSave)).collect(Collectors.toSet());
            String contractAddressValue = StringUtils.join(contractAddressList, (String)",");
            this.settingService.remove(WALLET_CONTEXT, WALLET_SCOPE, address + networkId);
            this.settingService.set(WALLET_CONTEXT, WALLET_SCOPE, defaultContractsParamKey, SettingValue.create((String)contractAddressValue));
        }
        this.storedSettings = null;
        return true;
    }

    public ContractDetail getDefaultContractDetail(String address, Long networkId) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn((Object)"Can't remove empty address for contract");
            return null;
        }
        if (networkId == null || networkId == 0L) {
            LOG.warn((Object)"Can't remove empty network id for contract");
            return null;
        }
        SettingValue contractDetailValue = this.settingService.get(WALLET_CONTEXT, WALLET_SCOPE, address + networkId);
        if (contractDetailValue != null) {
            return ContractDetail.parseStringToObject((String)contractDetailValue.getValue());
        }
        return null;
    }

    public List<String> getDefaultContractsAddresses(Long networkId) {
        if (networkId == null || networkId == 0L) {
            return Collections.emptyList();
        }
        List<String> contractAddressList = null;
        String defaultContractsParamKey = WALLET_DEFAULT_CONTRACTS_NAME + networkId;
        SettingValue defaultContractsAddressesValue = this.settingService.get(WALLET_CONTEXT, WALLET_SCOPE, defaultContractsParamKey);
        if (defaultContractsAddressesValue != null) {
            String[] contractAddresses = defaultContractsAddressesValue.getValue().toString().split(",");
            contractAddressList = Arrays.stream(contractAddresses).map(String::toLowerCase).collect(Collectors.toList());
        } else {
            contractAddressList = Collections.emptyList();
        }
        return contractAddressList;
    }

    public void saveUserPreferences(String userId, UserPreferences userPreferences) {
        if (userPreferences == null) {
            throw new IllegalArgumentException("userPreferences parameter is mandatory");
        }
        this.settingService.set(Context.USER.id(userId), WALLET_SCOPE, SETTINGS_KEY_NAME, SettingValue.create((String)userPreferences.toJSONString()));
        this.storedSettings = null;
    }

    public AccountDetail getSpaceDetails(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id parameter is mandatory");
        }
        Space space = this.getSpace(id);
        if (space == null) {
            return null;
        }
        String avatarUrl = space.getAvatarUrl();
        if (StringUtils.isBlank((String)avatarUrl)) {
            avatarUrl = "/rest/v1/social/spaces/" + id + "/avatar";
        }
        return new AccountDetail(id, space.getId(), "space", space.getDisplayName(), null, this.spaceService.isManager(space, Utils.getCurrentUserId()) || this.spaceService.isSuperManager(Utils.getCurrentUserId()), avatarUrl);
    }

    public AccountDetail getUserDetails(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id parameter is mandatory");
        }
        Identity identity = this.identityManager.getOrCreateIdentity("organization", id, true);
        if (identity == null || identity.getProfile() == null) {
            return null;
        }
        String avatarUrl = identity.getProfile().getAvatarUrl();
        if (StringUtils.isBlank((String)avatarUrl)) {
            avatarUrl = "/rest/v1/social/users/" + id + "/avatar";
        }
        return new AccountDetail(id, identity.getId(), "user", identity.getProfile().getFullName(), null, false, avatarUrl);
    }

    public AccountDetail getAccountDetailsByAddress(String address) {
        if (address == null) {
            throw new IllegalArgumentException("address parameter is mandatory");
        }
        address = address.toLowerCase();
        AccountDetail accountDetail = null;
        SettingValue walletAddressValue = this.settingService.get(WALLET_CONTEXT, WALLET_SCOPE, address);
        if (walletAddressValue != null && walletAddressValue.getValue() != null) {
            String idAndType = walletAddressValue.getValue().toString();
            String id = null;
            if (idAndType.startsWith("user")) {
                id = idAndType.replaceFirst("user", "");
                accountDetail = this.getUserDetails(id);
            } else if (idAndType.startsWith("space")) {
                id = idAndType.replaceFirst("space", "");
                accountDetail = this.getSpaceDetails(id);
            }
            if (accountDetail == null) {
                LOG.info("Can't find the user/space with id {} associated to address {}", new Object[]{id, address});
            } else {
                accountDetail.setAddress(address);
            }
        }
        return accountDetail;
    }

    public String getSpaceAddress(String id) {
        SettingValue spaceWalletAddressValue = this.settingService.get(WALLET_CONTEXT, WALLET_SCOPE, id);
        String address = null;
        if (spaceWalletAddressValue != null && spaceWalletAddressValue.getValue() != null) {
            address = spaceWalletAddressValue.getValue().toString().toLowerCase();
        }
        return address;
    }

    public String getUserAddress(String id) {
        SettingValue userWalletAddressValue = this.settingService.get(Context.USER.id(id), WALLET_SCOPE, ADDRESS_KEY_NAME);
        String address = null;
        if (userWalletAddressValue != null && userWalletAddressValue.getValue() != null) {
            address = userWalletAddressValue.getValue().toString().toLowerCase();
        }
        return address;
    }

    public String saveWalletAddress(AccountDetail accountDetail) throws Exception {
        String currentUserId = Utils.getCurrentUserId();
        String id = accountDetail.getId();
        String type = accountDetail.getType();
        String address = accountDetail.getAddress();
        address = address.toLowerCase();
        if (StringUtils.isBlank((String)id) || StringUtils.isBlank((String)type) || !StringUtils.equals((String)type, (String)"user") && !StringUtils.equals((String)type, (String)"space")) {
            LOG.warn("Bad request sent to server with id '{}', type '{}' and address '{}'", new Object[]{id, type, address});
            throw new IllegalStateException();
        }
        String oldAddress = null;
        if (StringUtils.equals((String)type, (String)"user")) {
            if (!StringUtils.equals((String)currentUserId, (String)id)) {
                LOG.error("User '{}' attempts to modify wallet address of user '{}'", new Object[]{currentUserId, id});
                throw new IllegalAccessException();
            }
            oldAddress = this.getUserAddress(id);
            if (oldAddress != null && !StringUtils.equals((String)oldAddress, (String)address)) {
                AccountDetail userDetailsByOldAddress = this.getAccountDetailsByAddress(oldAddress);
                if (userDetailsByOldAddress != null) {
                    LOG.info("The address {} was assigned to user {} and changed to user {}", new Object[]{oldAddress, userDetailsByOldAddress.getId(), currentUserId});
                    this.settingService.remove(Context.USER.id(userDetailsByOldAddress.getId()), WALLET_SCOPE, ADDRESS_KEY_NAME);
                }
                this.settingService.remove(WALLET_CONTEXT, WALLET_SCOPE, oldAddress);
            }
            this.settingService.set(WALLET_CONTEXT, WALLET_SCOPE, address, SettingValue.create((String)(type + id)));
            this.settingService.set(Context.USER.id(id), WALLET_SCOPE, ADDRESS_KEY_NAME, SettingValue.create((String)address));
        } else if (StringUtils.equals((String)type, (String)"space")) {
            this.checkCurrentUserIsSpaceManager(id);
            oldAddress = this.getSpaceAddress(id);
            if (oldAddress != null && !StringUtils.equals((String)oldAddress, (String)address)) {
                this.settingService.remove(WALLET_CONTEXT, WALLET_SCOPE, oldAddress);
            }
            this.settingService.set(WALLET_CONTEXT, WALLET_SCOPE, address, SettingValue.create((String)(type + id)));
            this.settingService.set(WALLET_CONTEXT, WALLET_SCOPE, id, SettingValue.create((String)address));
        } else {
            return null;
        }
        if (StringUtils.isBlank((String)oldAddress)) {
            this.listenerService.broadcast("exo.addon.wallet.addressAssociation.new", (Object)this, (Object)accountDetail);
        } else {
            this.listenerService.broadcast("exo.addon.wallet.addressAssociation.modification", (Object)this, (Object)accountDetail);
        }
        return this.generateSecurityPhrase(accountDetail);
    }

    public long getLastWatchedBlockNumber(long networkId) {
        SettingValue lastBlockNumberValue = this.settingService.get(WALLET_CONTEXT, WALLET_SCOPE, LAST_BLOCK_NUMBER_KEY_NAME + networkId);
        if (lastBlockNumberValue != null && lastBlockNumberValue.getValue() != null) {
            return Long.valueOf(lastBlockNumberValue.getValue().toString());
        }
        return 0L;
    }

    public void saveLastWatchedBlockNumber(long networkId, long lastWatchedBlockNumber) {
        LOG.debug("Save watched block number {} on network {}", new Object[]{lastWatchedBlockNumber, networkId});
        this.settingService.set(WALLET_CONTEXT, WALLET_SCOPE, LAST_BLOCK_NUMBER_KEY_NAME + networkId, SettingValue.create((Long)lastWatchedBlockNumber));
    }

    private Space getSpace(String id) {
        Space space = this.spaceService.getSpaceByPrettyName(id);
        if (space == null && (space = this.spaceService.getSpaceByUrl(id)) == null) {
            space = this.spaceService.getSpaceByDisplayName(id);
        }
        if (space == null) {
            return null;
        }
        return space;
    }

    public void saveAccountTransaction(Long networkId, String address, String hash) {
        String addressTransactions;
        if (StringUtils.isBlank((String)address)) {
            throw new IllegalArgumentException("address parameter is mandatory");
        }
        if (StringUtils.isBlank((String)hash)) {
            throw new IllegalArgumentException("transaction hash parameter is mandatory");
        }
        address = address.toLowerCase();
        String addressTransactionsParamName = WALLET_USER_TRANSACTION_NAME + address + networkId;
        SettingValue addressTransactionsValue = this.settingService.get(WALLET_CONTEXT, WALLET_SCOPE, addressTransactionsParamName);
        String string = addressTransactions = addressTransactionsValue == null ? "" : addressTransactionsValue.getValue().toString();
        if (!addressTransactions.contains(hash)) {
            addressTransactions = addressTransactions.isEmpty() ? hash : hash + "," + addressTransactions;
            this.settingService.set(WALLET_CONTEXT, WALLET_SCOPE, addressTransactionsParamName, SettingValue.create((String)addressTransactions));
        }
    }

    public List<String> getAccountTransactions(Long networkId, String address) {
        String addressTransactionsParamName = WALLET_USER_TRANSACTION_NAME + address + networkId;
        SettingValue addressTransactionsValue = this.settingService.get(WALLET_CONTEXT, WALLET_SCOPE, addressTransactionsParamName);
        String addressTransactions = addressTransactionsValue == null ? "" : addressTransactionsValue.getValue().toString();
        String[] addressTransactionsArray = addressTransactions.isEmpty() ? new String[]{} : addressTransactions.split(",");
        return Arrays.asList(addressTransactionsArray);
    }

    public void requestFunds(FundsRequest fundsRequest) throws IllegalAccessException {
        String currentUser = Utils.getCurrentUserId();
        AccountDetail requestSender = this.getAccountDetailsByAddress(fundsRequest.getAddress());
        if (requestSender == null) {
            throw new IllegalStateException("Bad request sent to server with invalid sender address");
        }
        String requestSenderId = requestSender.getId();
        String requestSenderType = requestSender.getType();
        if (StringUtils.equals((String)requestSenderType, (String)"user") && !StringUtils.equals((String)currentUser, (String)requestSenderId)) {
            LOG.warn((Object)"Bad request sent to server with invalid sender address");
            throw new IllegalAccessException("Bad request sent to server with invalid sender address");
        }
        if (StringUtils.equals((String)requestSenderType, (String)"space")) {
            this.checkCurrentUserIsSpaceManager(requestSenderId);
        }
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        GlobalSettings settings = this.getSettings();
        if (!StringUtils.isBlank((String)fundsRequest.getContract())) {
            ContractDetail contractDetail = this.getDefaultContractDetail(fundsRequest.getContract(), settings.getDefaultNetworkId());
            if (contractDetail == null) {
                throw new IllegalStateException("Bad request sent to server with invalid contract address (O ly default addresses are permitted)");
            }
            ctx.append(Utils.CONTRACT_DETAILS_PARAMETER, (Object)contractDetail);
        }
        String requestReceipientId = fundsRequest.getReceipient();
        String requestReceipientType = fundsRequest.getReceipientType();
        AccountDetail requestReceipient = null;
        if ("user".equals(requestReceipientType)) {
            requestReceipient = this.getUserDetails(requestReceipientId);
        } else if ("space".equals(requestReceipientType)) {
            requestReceipient = this.getSpaceDetails(requestReceipientId);
        }
        ctx.append(Utils.FUNDS_REQUEST_SENDER_DETAIL_PARAMETER, (Object)this.getUserDetails(Utils.getCurrentUserId()));
        ctx.append(Utils.SENDER_ACCOUNT_DETAIL_PARAMETER, (Object)requestSender);
        ctx.append(Utils.RECEIVER_ACCOUNT_DETAIL_PARAMETER, (Object)requestReceipient);
        ctx.append(Utils.FUNDS_REQUEST_PARAMETER, (Object)fundsRequest);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"FundsRequestNotificationPlugin"))).execute(ctx);
    }

    private String generateSecurityPhrase(AccountDetail accountDetail) throws IllegalAccessException {
        String currentUser = Utils.getCurrentUserId();
        String id = accountDetail.getId();
        String type = accountDetail.getType();
        Context context = null;
        String paramName = null;
        if (StringUtils.equals((String)type, (String)"user") && StringUtils.equals((String)currentUser, (String)id)) {
            context = Context.USER.id(id);
            paramName = WALLET_BROWSER_PHRASE_NAME;
        } else if (StringUtils.equals((String)type, (String)"space")) {
            this.checkCurrentUserIsSpaceManager(id);
            context = WALLET_CONTEXT;
            paramName = WALLET_BROWSER_PHRASE_NAME + id;
        } else {
            return null;
        }
        SettingValue browserWalletPhraseValue = this.settingService.get(context, WALLET_SCOPE, paramName);
        if (browserWalletPhraseValue != null && browserWalletPhraseValue.getValue() != null) {
            return browserWalletPhraseValue.getValue().toString();
        }
        String phrase = RandomStringUtils.random((int)20, (char[])SIMPLE_CHARS);
        this.settingService.set(context, WALLET_SCOPE, paramName, SettingValue.create((String)phrase));
        return phrase;
    }

    private String getUserPhrase(String username) {
        SettingValue browserWalletPhraseValue = this.settingService.get(Context.USER.id(username), WALLET_SCOPE, WALLET_BROWSER_PHRASE_NAME);
        if (browserWalletPhraseValue != null && browserWalletPhraseValue.getValue() != null) {
            return browserWalletPhraseValue.getValue().toString();
        }
        return null;
    }

    private String getSpacePhrase(String spaceId) {
        try {
            boolean isSpaceManager = this.checkCurrentUserIsSpaceManager(spaceId, false);
            if (!isSpaceManager) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        SettingValue browserWalletPhraseValue = this.settingService.get(WALLET_CONTEXT, WALLET_SCOPE, WALLET_BROWSER_PHRASE_NAME + spaceId);
        if (browserWalletPhraseValue != null && browserWalletPhraseValue.getValue() != null) {
            return browserWalletPhraseValue.getValue().toString();
        }
        return null;
    }

    private boolean checkCurrentUserIsSpaceManager(String id) throws IllegalAccessException {
        return this.checkCurrentUserIsSpaceManager(id, true);
    }

    private boolean checkCurrentUserIsSpaceManager(String id, boolean throwException) throws IllegalAccessException {
        String currentUserId = Utils.getCurrentUserId();
        Space space = this.getSpace(id);
        if (space == null) {
            LOG.warn("Space not found with id '{}'", new Object[]{id});
            throw new IllegalStateException();
        }
        if (!this.spaceService.isManager(space, currentUserId) && !this.spaceService.isSuperManager(currentUserId)) {
            if (throwException) {
                LOG.error("User '{}' attempts to modify wallet address of space '{}'", new Object[]{currentUserId, space.getDisplayName()});
                throw new IllegalAccessException();
            }
            return false;
        }
        return true;
    }
}

