/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/contract")
@RolesAllowed(value={"administrators"})
public class EthereumWalletContractREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletContractREST.class);
    private EthereumWalletService ethereumWalletService;

    public EthereumWalletContractREST(EthereumWalletService ethereumWalletService) {
        this.ethereumWalletService = ethereumWalletService;
    }

    @GET
    @Path(value="bin/{name}")
    @RolesAllowed(value={"administrators"})
    public Response getBin(@PathParam(value="name") String name) {
        if (StringUtils.isBlank((String)name)) {
            LOG.warn((Object)"Empty resource name");
            return Response.status((int)400).build();
        }
        if (name.contains("..")) {
            LOG.error((Object)"Forbidden path character is used: '..'");
            return Response.status((int)403).build();
        }
        try {
            String contractAbi = this.ethereumWalletService.getContract(name, "bin");
            return Response.ok((Object)contractAbi).build();
        }
        catch (Exception e) {
            LOG.warn((Object)("Error retrieving contract BIN: " + name), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="abi/{name}")
    @RolesAllowed(value={"administrators"})
    public Response getAbi(@PathParam(value="name") String name) {
        if (StringUtils.isBlank((String)name)) {
            LOG.warn((Object)"Empty resource name");
            return Response.status((int)400).build();
        }
        if (name.contains("..")) {
            LOG.error((Object)"Forbidden path character is used: '..'");
            return Response.status((int)403).build();
        }
        try {
            String contractAbi = this.ethereumWalletService.getContract(name, "json");
            return Response.ok((Object)contractAbi).build();
        }
        catch (Exception e) {
            LOG.warn((Object)("Error retrieving contract ABI: " + name), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="save")
    @RolesAllowed(value={"administrators"})
    public Response saveContract(ContractDetail contractDetail) {
        if (contractDetail == null) {
            LOG.warn((Object)"Can't save empty contract");
            return Response.status((int)400).build();
        }
        if (contractDetail.getAddress() == null) {
            LOG.warn((Object)"Can't save empty address for contract");
            return Response.status((int)400).build();
        }
        if (contractDetail.getNetworkId() == null || contractDetail.getNetworkId() == 0L) {
            LOG.warn((Object)"Can't remove empty network id for contract");
            return Response.status((int)400).build();
        }
        contractDetail.setAddress(contractDetail.getAddress().toLowerCase());
        try {
            this.ethereumWalletService.saveDefaultContract(contractDetail);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error saving contract as default: " + contractDetail.getAddress()), (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="remove")
    @RolesAllowed(value={"administrators"})
    public Response removeContract(@FormParam(value="address") String address, @FormParam(value="networkId") Long networkId) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn((Object)"Can't remove empty address for contract");
            return Response.status((int)400).build();
        }
        if (networkId == null || networkId == 0L) {
            LOG.warn((Object)"Can't remove empty network id for contract");
            return Response.status((int)400).build();
        }
        try {
            this.ethereumWalletService.removeDefaultContract(address.toLowerCase(), networkId);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error removing default contract: " + address), (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }
}

