/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.ext.kudos.model;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.json.JSONException;
import org.json.JSONObject;

public class KudosTransaction
implements Serializable {
    private static final long serialVersionUID = 658273092293607458L;
    private Long networkId;
    private String periodType;
    private long startDateInSeconds;
    private String hash;
    private String receiverType;
    private String receiverId;
    private String receiverIdentityId;
    private String tokensAmountSent;

    public static KudosTransaction fromStoredValue(String storedTransactionDetails) {
        KudosTransaction transactionMessage = new KudosTransaction();
        if (StringUtils.isNotBlank((String)storedTransactionDetails)) {
            String[] transactionDetailsArray = storedTransactionDetails.split(";");
            transactionMessage.setHash(transactionDetailsArray[0]);
            transactionMessage.setReceiverType(transactionDetailsArray.length > 1 ? Utils.decodeString(transactionDetailsArray[1]) : null);
            transactionMessage.setReceiverId(transactionDetailsArray.length > 2 ? Utils.decodeString(transactionDetailsArray[2]) : null);
            transactionMessage.setTokensAmountSent(transactionDetailsArray.length > 3 ? Utils.decodeString(transactionDetailsArray[3]) : null);
            transactionMessage.setReceiverIdentityId(transactionDetailsArray.length > 4 ? Utils.decodeString(transactionDetailsArray[4]) : null);
        }
        return transactionMessage;
    }

    public String getToStoreValue() {
        if (StringUtils.isBlank((String)this.receiverType)) {
            throw new IllegalStateException("receiverType is mandatory");
        }
        if (StringUtils.isBlank((String)this.receiverId)) {
            throw new IllegalStateException("receiverId is mandatory");
        }
        return this.hash + ";" + Utils.encodeString(this.receiverType) + ";" + Utils.encodeString(this.receiverId) + ";" + Utils.encodeString(this.tokensAmountSent) + ";" + this.receiverIdentityId;
    }

    public String toJSONString() {
        return this.toJSONObject().toString();
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            if (this.networkId != null && this.networkId > 0L) {
                jsonObject.put("networkId", (Object)this.networkId);
            }
            if (StringUtils.isNotBlank((String)this.hash)) {
                jsonObject.put("hash", (Object)this.hash);
            }
            if (StringUtils.isNotBlank((String)this.receiverType)) {
                jsonObject.put("receiverType", (Object)this.receiverType);
            }
            if (StringUtils.isNotBlank((String)this.receiverId)) {
                jsonObject.put("receiverId", (Object)this.receiverId);
            }
            if (StringUtils.isNotBlank((String)this.receiverIdentityId)) {
                jsonObject.put("receiverIdentityId", (Object)this.receiverIdentityId);
            }
            if (StringUtils.isNotBlank((String)this.tokensAmountSent)) {
                jsonObject.put("tokensAmountSent", (Object)this.tokensAmountSent);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Error while converting Object to JSON", e);
        }
        return jsonObject;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof KudosTransaction)) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((String)this.hash, (String)((KudosTransaction)obj).getHash());
    }

    public Long getNetworkId() {
        return this.networkId;
    }

    public String getPeriodType() {
        return this.periodType;
    }

    public long getStartDateInSeconds() {
        return this.startDateInSeconds;
    }

    public String getHash() {
        return this.hash;
    }

    public String getReceiverType() {
        return this.receiverType;
    }

    public String getReceiverId() {
        return this.receiverId;
    }

    public String getReceiverIdentityId() {
        return this.receiverIdentityId;
    }

    public String getTokensAmountSent() {
        return this.tokensAmountSent;
    }

    public void setNetworkId(Long networkId) {
        this.networkId = networkId;
    }

    public void setPeriodType(String periodType) {
        this.periodType = periodType;
    }

    public void setStartDateInSeconds(long startDateInSeconds) {
        this.startDateInSeconds = startDateInSeconds;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setReceiverType(String receiverType) {
        this.receiverType = receiverType;
    }

    public void setReceiverId(String receiverId) {
        this.receiverId = receiverId;
    }

    public void setReceiverIdentityId(String receiverIdentityId) {
        this.receiverIdentityId = receiverIdentityId;
    }

    public void setTokensAmountSent(String tokensAmountSent) {
        this.tokensAmountSent = tokensAmountSent;
    }

    public KudosTransaction(Long networkId, String periodType, long startDateInSeconds, String hash, String receiverType, String receiverId, String receiverIdentityId, String tokensAmountSent) {
        this.networkId = networkId;
        this.periodType = periodType;
        this.startDateInSeconds = startDateInSeconds;
        this.hash = hash;
        this.receiverType = receiverType;
        this.receiverId = receiverId;
        this.receiverIdentityId = receiverIdentityId;
        this.tokensAmountSent = tokensAmountSent;
    }

    public KudosTransaction() {
    }

    public String toString() {
        return "KudosTransaction(networkId=" + this.getNetworkId() + ", periodType=" + this.getPeriodType() + ", startDateInSeconds=" + this.getStartDateInSeconds() + ", hash=" + this.getHash() + ", receiverType=" + this.getReceiverType() + ", receiverId=" + this.getReceiverId() + ", receiverIdentityId=" + this.getReceiverIdentityId() + ", tokensAmountSent=" + this.getTokensAmountSent() + ")";
    }
}

