/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.ext.reward.model;

import java.time.LocalDateTime;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationSettings;
import org.exoplatform.addon.ethereum.wallet.ext.reward.model.RewardPeriodType;
import org.json.JSONException;
import org.json.JSONObject;

public class RewardPeriod {
    private long startDateInSeconds;
    private long endDateInSeconds;

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("startDateInSeconds", this.startDateInSeconds);
            jsonObject.put("endDateInSeconds", this.endDateInSeconds);
        }
        catch (JSONException e) {
            throw new RuntimeException("Error while converting Object to JSON", e);
        }
        return jsonObject;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public static RewardPeriod getCurrentPeriod(GamificationSettings gamificationSettings) {
        return RewardPeriod.getPeriodOfTime(gamificationSettings, LocalDateTime.now());
    }

    public static RewardPeriod getPeriodOfTime(GamificationSettings gamificationSettings, LocalDateTime localDateTime) {
        RewardPeriodType gamificationPeriodType = null;
        gamificationPeriodType = gamificationSettings == null || gamificationSettings.getPeriodType() == null ? RewardPeriodType.DEFAULT : gamificationSettings.getPeriodType();
        return gamificationPeriodType.getPeriodOfTime(localDateTime);
    }

    public long getStartDateInSeconds() {
        return this.startDateInSeconds;
    }

    public long getEndDateInSeconds() {
        return this.endDateInSeconds;
    }

    public void setStartDateInSeconds(long startDateInSeconds) {
        this.startDateInSeconds = startDateInSeconds;
    }

    public void setEndDateInSeconds(long endDateInSeconds) {
        this.endDateInSeconds = endDateInSeconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RewardPeriod)) {
            return false;
        }
        RewardPeriod other = (RewardPeriod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartDateInSeconds() != other.getStartDateInSeconds()) {
            return false;
        }
        return this.getEndDateInSeconds() == other.getEndDateInSeconds();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RewardPeriod;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startDateInSeconds = this.getStartDateInSeconds();
        result = result * 59 + (int)($startDateInSeconds >>> 32 ^ $startDateInSeconds);
        long $endDateInSeconds = this.getEndDateInSeconds();
        result = result * 59 + (int)($endDateInSeconds >>> 32 ^ $endDateInSeconds);
        return result;
    }

    public RewardPeriod() {
    }

    public RewardPeriod(long startDateInSeconds, long endDateInSeconds) {
        this.startDateInSeconds = startDateInSeconds;
        this.endDateInSeconds = endDateInSeconds;
    }
}

