/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.GlobalSettings;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/global-settings")
public class EthereumWalletGlobalSettingsREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletGlobalSettingsREST.class);
    private EthereumWalletService ethereumWalletService;

    public EthereumWalletGlobalSettingsREST(EthereumWalletService ethereumWalletService) {
        this.ethereumWalletService = ethereumWalletService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getSettings(@QueryParam(value="networkId") Long networkId, @QueryParam(value="spaceId") String spaceId) {
        GlobalSettings globalSettings = this.ethereumWalletService.getSettings(networkId, spaceId);
        return Response.ok((Object)globalSettings.toJSONString(true)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="save")
    @RolesAllowed(value={"administrators"})
    public Response saveSettings(GlobalSettings globalSettings) {
        if (globalSettings == null) {
            LOG.warn((Object)"Bad request sent to server with empty settings");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)globalSettings.getProviderURL())) {
            LOG.warn((Object)"Bad request sent to server with empty setting 'providerURL'");
            return Response.status((int)400).build();
        }
        if (globalSettings.getDefaultNetworkId() == null) {
            LOG.warn((Object)"Bad request sent to server with empty setting 'defaultNetworkId'");
            return Response.status((int)400).build();
        }
        if (globalSettings.getDefaultGas() == null) {
            LOG.warn((Object)"Bad request sent to server with empty setting 'defaultGas'");
            return Response.status((int)400).build();
        }
        try {
            this.ethereumWalletService.saveSettings(globalSettings);
            LOG.info("{} saved wallet settings details '{}'", new Object[]{Utils.getCurrentUserId(), globalSettings.toJSONString(false)});
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving global settings", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }
}

