/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.AccountDetail;
import org.exoplatform.addon.ethereum.wallet.model.AccountDetailCacheId;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.model.FundsRequest;
import org.exoplatform.addon.ethereum.wallet.model.GlobalSettings;
import org.exoplatform.addon.ethereum.wallet.model.TransactionDetail;
import org.exoplatform.addon.ethereum.wallet.model.UserPreferences;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.picocontainer.Startable;

public class EthereumWalletService
implements Startable {
    private static final String ADDRESS_PARAMETER_IS_MANDATORY_MESSAGE = "address parameter is mandatory";
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletService.class);
    private ExoContainer container;
    private SettingService settingService;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private UserACL userACL;
    private WebNotificationStorage webNotificationStorage;
    private ListenerService listenerService;
    private ConfigurationManager configurationManager;
    private GlobalSettings defaultSettings = new GlobalSettings();
    private GlobalSettings storedSettings;
    private String contractAbiPath;
    private JSONArray contractAbi;
    private String contractBinaryPath;
    private String contractBinary;
    private ExoCache<String, TransactionDetail> transactionDetailsCache = null;
    private ExoCache<AccountDetailCacheId, AccountDetail> accountDetailCache = null;
    private FutureExoCache<AccountDetailCacheId, AccountDetail, ServiceContext<AccountDetail>> accountDetailFutureCache = null;
    private long walletsCount = 0L;
    private ScheduledExecutorService scheduledExecutorService = null;

    public EthereumWalletService(SettingService settingService, SpaceService spaceService, WebNotificationStorage webNotificationStorage, IdentityManager identityManager, ListenerService listenerService, UserACL userACL, CacheService cacheService, ExoContainer exoContainer, ConfigurationManager configurationManager, InitParams params) {
        String defaultContractsToDisplay;
        String value;
        this.container = exoContainer;
        this.configurationManager = configurationManager;
        this.settingService = settingService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.webNotificationStorage = webNotificationStorage;
        this.listenerService = listenerService;
        this.userACL = userACL;
        this.transactionDetailsCache = cacheService.getCacheInstance("wallet.transactionsMessages");
        this.accountDetailCache = cacheService.getCacheInstance("wallet.accountDetailCache");
        if (params.containsKey((Object)"defaultNetworkId")) {
            value = params.getValueParam("defaultNetworkId").getValue();
            long defaultNetworkId = Long.parseLong(value);
            this.defaultSettings.setDefaultNetworkId(defaultNetworkId);
        }
        if (params.containsKey((Object)"defaultNetworkURL")) {
            String defaultNetworkURL = params.getValueParam("defaultNetworkURL").getValue();
            this.defaultSettings.setProviderURL(defaultNetworkURL);
        }
        if (params.containsKey((Object)"defaultAccessPermission")) {
            String defaultAccessPermission = params.getValueParam("defaultAccessPermission").getValue();
            this.defaultSettings.setAccessPermission(defaultAccessPermission);
        }
        if (params.containsKey((Object)"defaultGas")) {
            value = params.getValueParam("defaultGas").getValue();
            long defaultGas = Long.parseLong(value);
            this.defaultSettings.setDefaultGas(defaultGas);
        }
        if (params.containsKey((Object)"minGasPrice")) {
            value = params.getValueParam("minGasPrice").getValue();
            long minGasPrice = Long.parseLong(value);
            this.defaultSettings.setMinGasPrice(minGasPrice);
        }
        if (params.containsKey((Object)"normalGasPrice")) {
            value = params.getValueParam("normalGasPrice").getValue();
            long normalGasPrice = Long.parseLong(value);
            this.defaultSettings.setNormalGasPrice(normalGasPrice);
        }
        if (params.containsKey((Object)"maxGasPrice")) {
            value = params.getValueParam("maxGasPrice").getValue();
            long maxGasPrice = Long.parseLong(value);
            this.defaultSettings.setMaxGasPrice(maxGasPrice);
        }
        if (params.containsKey((Object)"defaultContractAddresses") && StringUtils.isNotBlank((String)(defaultContractsToDisplay = params.getValueParam("defaultContractAddresses").getValue()))) {
            Set<String> defaultContracts = Arrays.stream(defaultContractsToDisplay.split(",")).map(contractAddress -> contractAddress.trim().toLowerCase()).filter(contractAddress -> !contractAddress.isEmpty()).collect(Collectors.toSet());
            this.defaultSettings.setDefaultContractsToDisplay(defaultContracts);
        }
        if (params.containsKey((Object)"contract.abi.path")) {
            this.contractAbiPath = params.getValueParam("contract.abi.path").getValue();
        }
        if (StringUtils.isBlank((String)this.contractAbiPath)) {
            LOG.warn((Object)"Contract ABI path is empty, thus no contract deployment is possible");
        }
        if (params.containsKey((Object)"contract.bin.path")) {
            this.contractBinaryPath = params.getValueParam("contract.bin.path").getValue();
        }
        if (StringUtils.isBlank((String)this.contractBinaryPath)) {
            LOG.warn((Object)"Contract BIN path is empty, thus no contract deployment is possible");
        }
        this.accountDetailFutureCache = new FutureExoCache((Loader)new Loader<AccountDetailCacheId, AccountDetail, ServiceContext<AccountDetail>>(){

            public AccountDetail retrieve(ServiceContext<AccountDetail> context, AccountDetailCacheId key) throws Exception {
                return context.execute();
            }
        }, this.accountDetailCache);
    }

    public void start() {
        try {
            String contractAbiString = IOUtil.getStreamContentAsString((InputStream)this.configurationManager.getInputStream(this.contractAbiPath));
            this.contractAbi = new JSONArray(contractAbiString);
            this.contractBinary = IOUtil.getStreamContentAsString((InputStream)this.configurationManager.getInputStream(this.contractBinaryPath));
            if (!this.contractBinary.startsWith("0x")) {
                this.contractBinary = "0x" + this.contractBinary;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Can't read ABI/BIN files content", (Throwable)e);
        }
        this.checkDataToUpgrade(this.getSettings());
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Ethereum-cache-populator-%d").build();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
            RequestLifeCycle.begin((ExoContainer)this.container);
            try {
                this.walletsCount = 0L;
                this.listWallets();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while retrieving list of wallets for cache population", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }, 10L, this.accountDetailCache.getLiveTime() > 0L ? this.accountDetailCache.getLiveTime() : 86400L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.scheduledExecutorService.shutdown();
    }

    public JSONArray getContractAbi() {
        return this.contractAbi;
    }

    public String getContractBinary() {
        return this.contractBinary;
    }

    public void saveSettings(GlobalSettings newGlobalSettings) {
        if (newGlobalSettings == null) {
            throw new IllegalArgumentException("globalSettings parameter is mandatory");
        }
        GlobalSettings oldGlobalSettings = this.getSettings();
        LOG.debug("Saving new global settings", new Object[]{newGlobalSettings.toJSONString(false)});
        this.settingService.set(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, "GLOBAL_SETTINGS", SettingValue.create((String)newGlobalSettings.toJSONString(false)));
        this.storedSettings = null;
        try {
            this.listenerService.broadcast("exo.addon.wallet.settings.changed", (Object)oldGlobalSettings, (Object)newGlobalSettings);
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while broadcasting wallet settings modification event", (Throwable)e);
        }
    }

    public GlobalSettings getSettings() {
        if (this.storedSettings != null) {
            return this.storedSettings;
        }
        this.storedSettings = this.getSettings(null);
        return this.storedSettings;
    }

    public GlobalSettings getSettings(Long networkId) {
        return this.getSettings(networkId, null);
    }

    public GlobalSettings getSettings(Long networkId, String spaceId) {
        SettingValue globalSettingsValue = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, "GLOBAL_SETTINGS");
        String username = Utils.getCurrentUserId();
        GlobalSettings globalSettings = this.defaultSettings;
        if (globalSettingsValue != null && globalSettingsValue.getValue() != null) {
            globalSettings = GlobalSettings.parseStringToObject(this.defaultSettings, globalSettingsValue.getValue().toString());
            if (StringUtils.isNotBlank((String)globalSettings.getAccessPermission())) {
                Space space = Utils.getSpace(globalSettings.getAccessPermission());
                if (username != null && space != null && !this.spaceService.isMember(space, username) && !this.spaceService.isSuperManager(username)) {
                    LOG.info("Wallet is disabled for user {} because he's not member of space {}", new Object[]{username, space.getPrettyName()});
                    globalSettings.setWalletEnabled(false);
                }
            }
            globalSettings.setAdmin(this.isUserAdmin());
        }
        if (globalSettings.isWalletEnabled() || globalSettings.isAdmin()) {
            if ((networkId == null || networkId == 0L) && globalSettings.getDefaultNetworkId() != null) {
                networkId = globalSettings.getDefaultNetworkId();
            }
            globalSettings.setDefaultContractsToDisplay(this.getDefaultContractsAddresses(networkId));
            if (StringUtils.isBlank((String)username)) {
                String defaultPrincipalAccount = globalSettings.getDefaultPrincipalAccount();
                if (StringUtils.isNotBlank((String)defaultPrincipalAccount)) {
                    ContractDetail principalContractDetails = this.getContractDetail(defaultPrincipalAccount, globalSettings.getDefaultNetworkId());
                    globalSettings.setPrincipalContractAdminAddress(principalContractDetails == null ? null : principalContractDetails.getOwner());
                }
            } else {
                SettingValue userSettingsValue = this.settingService.get(Context.USER.id(username), Utils.WALLET_SCOPE, "ADDONS_ETHEREUM_WALLET_SETTINGS");
                UserPreferences userSettings = null;
                if (userSettingsValue != null && userSettingsValue.getValue() != null) {
                    userSettings = UserPreferences.parseStringToObject(userSettingsValue.getValue().toString());
                    this.checkDataToUpgrade(username, userSettings);
                } else {
                    userSettings = new UserPreferences();
                }
                globalSettings.setUserPreferences(userSettings);
                if (StringUtils.isNotBlank((String)spaceId)) {
                    userSettings.setWalletAddress(this.getSpaceAddress(spaceId));
                    userSettings.setPhrase(this.getSpacePhrase(spaceId));
                } else {
                    userSettings.setWalletAddress(this.getUserAddress(username));
                    userSettings.setPhrase(this.getUserPhrase(username));
                }
                if (this.storedSettings != null && StringUtils.isNotBlank((String)this.storedSettings.getPrincipalContractAdminAddress())) {
                    globalSettings.setPrincipalContractAdminAddress(this.storedSettings.getPrincipalContractAdminAddress());
                }
            }
            globalSettings.setContractAbi(this.getContractAbi());
            globalSettings.setContractBin(this.getContractBinary());
        } else {
            globalSettings = new GlobalSettings();
            globalSettings.setWalletEnabled(false);
        }
        return globalSettings;
    }

    public void saveContract(ContractDetail contractDetail) {
        if (StringUtils.isBlank((String)contractDetail.getAddress())) {
            throw new IllegalArgumentException(ADDRESS_PARAMETER_IS_MANDATORY_MESSAGE);
        }
        if (contractDetail.getNetworkId() == null || contractDetail.getNetworkId() == 0L) {
            throw new IllegalArgumentException("networkId parameter is mandatory");
        }
        String defaultContractsParamKey = "WALLET_DEFAULT_CONTRACTS" + contractDetail.getNetworkId();
        String address = contractDetail.getAddress().toLowerCase();
        this.settingService.set(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, address + contractDetail.getNetworkId(), SettingValue.create((String)contractDetail.toJSONString()));
        if (contractDetail.isDefaultContract()) {
            SettingValue defaultContractsAddressesValue = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, defaultContractsParamKey);
            String defaultContractsAddresses = defaultContractsAddressesValue == null ? address : defaultContractsAddressesValue.getValue().toString() + "," + address;
            this.settingService.set(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, defaultContractsParamKey, SettingValue.create((String)defaultContractsAddresses));
            this.storedSettings = null;
        }
    }

    public boolean removeDefaultContract(String address, Long networkId) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn((Object)"Can't remove empty address for contract");
            return false;
        }
        if (networkId == null || networkId == 0L) {
            LOG.warn((Object)"Can't remove empty network id for contract");
            return false;
        }
        String defaultContractsParamKey = "WALLET_DEFAULT_CONTRACTS" + networkId;
        String defaultAddressToSave = address.toLowerCase();
        SettingValue defaultContractsAddressesValue = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, defaultContractsParamKey);
        if (defaultContractsAddressesValue != null) {
            String[] contractAddresses = defaultContractsAddressesValue.getValue().toString().split(",");
            Set contractAddressList = Arrays.stream(contractAddresses).filter(contractAddress -> !contractAddress.equalsIgnoreCase(defaultAddressToSave)).collect(Collectors.toSet());
            String contractAddressValue = StringUtils.join(contractAddressList, (String)",");
            this.settingService.remove(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, address + networkId);
            this.settingService.set(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, defaultContractsParamKey, SettingValue.create((String)contractAddressValue));
        }
        this.storedSettings = null;
        return true;
    }

    public ContractDetail getContractDetail(String address, Long networkId) {
        Set<String> defaultContracts;
        if (StringUtils.isBlank((String)address)) {
            LOG.warn((Object)"Can't get default contract detail with empty address");
            return null;
        }
        if (networkId == null || networkId == 0L) {
            GlobalSettings settings = this.getSettings();
            networkId = settings == null ? 0L : settings.getDefaultNetworkId();
        }
        if ((defaultContracts = this.getDefaultContractsAddresses(networkId)) != null && !defaultContracts.contains(address)) {
            return null;
        }
        SettingValue contractDetailValue = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, address + networkId);
        if (contractDetailValue != null) {
            return ContractDetail.parseStringToObject((String)contractDetailValue.getValue());
        }
        return null;
    }

    public Set<String> getDefaultContractsAddresses(Long networkId) {
        if (networkId == null || networkId == 0L) {
            return Collections.emptySet();
        }
        if (this.storedSettings != null && networkId == this.storedSettings.getDefaultNetworkId() && this.storedSettings.getDefaultContractsToDisplay() != null) {
            return this.storedSettings.getDefaultContractsToDisplay();
        }
        String defaultContractsParamKey = "WALLET_DEFAULT_CONTRACTS" + networkId;
        SettingValue defaultContractsAddressesValue = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, defaultContractsParamKey);
        if (defaultContractsAddressesValue != null) {
            String defaultContractsAddressesString = defaultContractsAddressesValue.getValue().toString().toLowerCase();
            String[] contractAddresses = defaultContractsAddressesString.split(",");
            return Arrays.stream(contractAddresses).map(String::toLowerCase).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public void saveUserPreferences(String userId, UserPreferences userPreferences) {
        if (userPreferences == null) {
            throw new IllegalArgumentException("userPreferences parameter is mandatory");
        }
        this.settingService.set(Context.USER.id(userId), Utils.WALLET_SCOPE, "ADDONS_ETHEREUM_WALLET_SETTINGS", SettingValue.create((String)userPreferences.toJSONString()));
        this.storedSettings = null;
    }

    public AccountDetail getSpaceDetails(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id parameter is mandatory");
        }
        AccountDetail accountDetails = this.getAccountDetailsFromCache(new AccountDetailCacheId("space", id));
        if (accountDetails != null && StringUtils.isNotBlank((String)accountDetails.getAddress())) {
            this.putInCache(accountDetails);
        }
        return accountDetails;
    }

    public AccountDetail getUserDetails(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id parameter is mandatory");
        }
        AccountDetail accountDetails = this.getAccountDetailsFromCache(new AccountDetailCacheId("user", id));
        if (accountDetails != null && StringUtils.isNotBlank((String)accountDetails.getAddress())) {
            this.putInCache(accountDetails);
        }
        return accountDetails;
    }

    public AccountDetail getAccountDetailsByAddress(String address) {
        if (address == null) {
            throw new IllegalArgumentException(ADDRESS_PARAMETER_IS_MANDATORY_MESSAGE);
        }
        AccountDetail accountDetails = this.getAccountDetailsFromCache(new AccountDetailCacheId(address.toLowerCase()));
        if (accountDetails != null && StringUtils.isNotBlank((String)accountDetails.getAddress())) {
            this.putInCache(accountDetails);
        }
        return accountDetails;
    }

    public String getSpaceAddress(String id) {
        AccountDetail accountDetail = this.getAccountDetailsFromCache(new AccountDetailCacheId("space", id));
        if (accountDetail != null) {
            return accountDetail.getAddress();
        }
        return this.getSpaceAddressFromStorage(id);
    }

    public String getUserAddress(String id) {
        AccountDetail accountDetail = this.getAccountDetailsFromCache(new AccountDetailCacheId("user", id));
        if (accountDetail != null) {
            return accountDetail.getAddress();
        }
        return this.getUserAddressFromStorage(id);
    }

    public String saveWalletAddress(AccountDetail accountDetail) throws Exception {
        String currentUserId = Utils.getCurrentUserId();
        String id = accountDetail.getId();
        String type = accountDetail.getType();
        String address = accountDetail.getAddress();
        address = address.toLowerCase();
        this.removeFromCache(address);
        if (StringUtils.isBlank((String)id) || StringUtils.isBlank((String)type) || !StringUtils.equals((String)type, (String)"user") && !StringUtils.equals((String)type, (String)"space")) {
            LOG.warn("Bad request sent to server with id '{}', type '{}' and address '{}'", new Object[]{id, type, address});
            throw new IllegalStateException();
        }
        String oldAddress = null;
        if (StringUtils.equals((String)type, (String)"user")) {
            if (!StringUtils.equals((String)currentUserId, (String)id)) {
                LOG.error("User '{}' attempts to modify wallet address of user '{}'", new Object[]{currentUserId, id});
                throw new IllegalAccessException();
            }
            oldAddress = this.getUserAddress(id);
            if (oldAddress != null && !StringUtils.equals((String)oldAddress, (String)address)) {
                AccountDetail userDetailsByOldAddress = this.getAccountDetailsByAddress(oldAddress);
                if (userDetailsByOldAddress != null) {
                    LOG.info("The address {} was assigned to user {} and changed to user {}", new Object[]{oldAddress, userDetailsByOldAddress.getId(), currentUserId});
                    this.settingService.remove(Context.USER.id(userDetailsByOldAddress.getId()), Utils.WALLET_SCOPE, "ADDONS_ETHEREUM_WALLET_ADDRESS");
                }
                this.settingService.remove(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, oldAddress);
            }
            if (StringUtils.isNotBlank((String)oldAddress)) {
                this.removeFromCache(oldAddress);
            }
            this.settingService.set(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, address, SettingValue.create((String)(type + id)));
            this.settingService.set(Context.USER.id(id), Utils.WALLET_SCOPE, "ADDONS_ETHEREUM_WALLET_ADDRESS", SettingValue.create((String)address));
        } else if (StringUtils.equals((String)type, (String)"space")) {
            this.checkCurrentUserIsSpaceManager(id);
            oldAddress = this.getSpaceAddress(id);
            if (oldAddress != null && !StringUtils.equals((String)oldAddress, (String)address)) {
                this.settingService.remove(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, oldAddress);
            }
            if (StringUtils.isNotBlank((String)oldAddress)) {
                this.removeFromCache(oldAddress);
            }
            this.settingService.set(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, address, SettingValue.create((String)(type + id)));
            this.settingService.set(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, id, SettingValue.create((String)address));
        } else {
            LOG.warn("Account type {} is not recognized", new Object[]{type});
            return null;
        }
        this.removeFromCache(type, id);
        if (StringUtils.isBlank((String)oldAddress)) {
            this.listenerService.broadcast("exo.addon.wallet.addressAssociation.new", (Object)this, (Object)accountDetail);
        } else {
            this.listenerService.broadcast("exo.addon.wallet.addressAssociation.modification", (Object)this, (Object)accountDetail);
        }
        this.getAccountDetailsFromCache(new AccountDetailCacheId(accountDetail.getAddress()));
        this.getAccountDetailsFromCache(new AccountDetailCacheId(accountDetail.getType(), accountDetail.getId()));
        if (StringUtils.isBlank((String)oldAddress)) {
            ++this.walletsCount;
        }
        return this.generateSecurityPhrase(accountDetail);
    }

    public long getLastWatchedBlockNumber(long networkId) {
        SettingValue lastBlockNumberValue = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER" + networkId);
        if (lastBlockNumberValue != null && lastBlockNumberValue.getValue() != null) {
            return Long.valueOf(lastBlockNumberValue.getValue().toString());
        }
        return 0L;
    }

    public void saveLastWatchedBlockNumber(long networkId, long lastWatchedBlockNumber) {
        LOG.debug("Save watched block number {} on network {}", new Object[]{lastWatchedBlockNumber, networkId});
        this.settingService.set(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER" + networkId, SettingValue.create((Long)lastWatchedBlockNumber));
    }

    public void saveAccountTransaction(Long networkId, String address, String hash, boolean sender) {
        String addressTransactions;
        if (StringUtils.isBlank((String)address)) {
            throw new IllegalArgumentException(ADDRESS_PARAMETER_IS_MANDATORY_MESSAGE);
        }
        if (StringUtils.isBlank((String)hash)) {
            throw new IllegalArgumentException("transaction hash parameter is mandatory");
        }
        address = address.toLowerCase();
        String addressTransactionsParamName = "WALLET_USER_TRANSACTION" + address + networkId;
        SettingValue addressTransactionsValue = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, addressTransactionsParamName);
        String string = addressTransactions = addressTransactionsValue == null ? "" : addressTransactionsValue.getValue().toString();
        if (!addressTransactions.contains(hash)) {
            String content = hash;
            TransactionDetail transactionMessage = (TransactionDetail)this.transactionDetailsCache.get((Serializable)((Object)hash));
            if (transactionMessage != null) {
                content = transactionMessage.getToStoreValue(sender);
            }
            addressTransactions = addressTransactions.isEmpty() ? content : content + "," + addressTransactions;
            this.settingService.set(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, addressTransactionsParamName, SettingValue.create((String)addressTransactions));
        }
    }

    public List<JSONObject> getAccountTransactions(Long networkId, String address) {
        Space space;
        boolean displayLabel;
        String addressTransactionsParamName = "WALLET_USER_TRANSACTION" + address + networkId;
        SettingValue addressTransactionsValue = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, addressTransactionsParamName);
        String addressTransactions = addressTransactionsValue == null ? "" : addressTransactionsValue.getValue().toString();
        String[] addressTransactionsArray = addressTransactions.isEmpty() ? new String[]{} : addressTransactions.split(",");
        AccountDetail accountDetails = this.getAccountDetailsByAddress(address);
        String currentUserId = Utils.getCurrentUserId();
        boolean bl = displayLabel = accountDetails != null && "user".equals(accountDetails.getId()) && StringUtils.equalsIgnoreCase((String)accountDetails.getId(), (String)currentUserId);
        if (!displayLabel && accountDetails != null && "space".equals(accountDetails.getType()) && (space = Utils.getSpace(accountDetails.getId())) != null && (this.spaceService.isManager(space, currentUserId) || this.spaceService.isSuperManager(currentUserId))) {
            displayLabel = true;
        }
        boolean displayLabelFinal = displayLabel;
        return Arrays.stream(addressTransactionsArray).map(transaction -> {
            AccountDetail txAccountDetails;
            TransactionDetail transactionDetail = TransactionDetail.fromStoredValue(transaction);
            TransactionDetail cachedTransactionDetail = this.getTransactionDetailFromCache(transactionDetail.getHash());
            if (cachedTransactionDetail != null) {
                transactionDetail = cachedTransactionDetail;
            }
            if (!(StringUtils.isBlank((String)transactionDetail.getFrom()) || StringUtils.equalsIgnoreCase((String)transactionDetail.getFrom(), (String)address) || displayLabelFinal || (txAccountDetails = this.getAccountDetailsByAddress(transactionDetail.getFrom())) == null || StringUtils.equalsIgnoreCase((String)txAccountDetails.getAddress(), (String)address))) {
                transactionDetail.setLabel(null);
            }
            return transactionDetail.toJSONObject();
        }).collect(Collectors.toList());
    }

    public void requestFunds(FundsRequest fundsRequest) throws IllegalAccessException {
        String currentUser = Utils.getCurrentUserId();
        AccountDetail requestSender = this.getAccountDetailsByAddress(fundsRequest.getAddress());
        if (requestSender == null) {
            throw new IllegalStateException("Bad request sent to server with unknown sender address");
        }
        String requestSenderId = requestSender.getId();
        String requestSenderType = requestSender.getType();
        if (StringUtils.equals((String)requestSenderType, (String)"user") && !StringUtils.equals((String)currentUser, (String)requestSenderId)) {
            LOG.warn("Bad request sent to server with invalid sender type or id {} / {}", new Object[]{requestSenderType, requestSenderId});
            throw new IllegalAccessException("Bad request sent to server with invalid sender");
        }
        if (StringUtils.equals((String)requestSenderType, (String)"space")) {
            this.checkCurrentUserIsSpaceManager(requestSenderId);
        }
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        GlobalSettings settings = this.getSettings();
        if (!StringUtils.isBlank((String)fundsRequest.getContract())) {
            ContractDetail contractDetail = this.getContractDetail(fundsRequest.getContract(), settings.getDefaultNetworkId());
            if (contractDetail == null) {
                throw new IllegalStateException("Bad request sent to server with invalid contract address (O ly default addresses are permitted)");
            }
            ctx.append(Utils.CONTRACT_DETAILS_PARAMETER, (Object)contractDetail);
        }
        String requestReceipientId = fundsRequest.getReceipient();
        String requestReceipientType = fundsRequest.getReceipientType();
        AccountDetail requestReceipient = null;
        if ("user".equals(requestReceipientType)) {
            requestReceipient = this.getUserDetails(requestReceipientId);
        } else if ("space".equals(requestReceipientType)) {
            requestReceipient = this.getSpaceDetails(requestReceipientId);
        }
        if (requestReceipient == null || requestReceipient.getTechnicalId() == null) {
            LOG.warn("Can't find fund request recipient with id {} and type {}", new Object[]{requestReceipientId, requestReceipientType});
        }
        ctx.append(Utils.FUNDS_REQUEST_SENDER_DETAIL_PARAMETER, (Object)this.getUserDetails(Utils.getCurrentUserId()));
        ctx.append(Utils.SENDER_ACCOUNT_DETAIL_PARAMETER, (Object)requestSender);
        ctx.append(Utils.RECEIVER_ACCOUNT_DETAIL_PARAMETER, (Object)requestReceipient);
        ctx.append(Utils.FUNDS_REQUEST_PARAMETER, (Object)fundsRequest);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"FundsRequestNotificationPlugin"))).execute(ctx);
    }

    public void markFundRequestAsSent(String notificationId, String currentUser) throws IllegalAccessException {
        NotificationInfo notificationInfo = this.webNotificationStorage.get(notificationId);
        if (notificationInfo == null) {
            throw new IllegalStateException("Notification with id " + notificationId + " wasn't found");
        }
        if (notificationInfo.getTo() == null || !currentUser.equals(notificationInfo.getTo())) {
            throw new IllegalAccessException("Target user of notification '" + notificationId + "' is different from current user");
        }
        notificationInfo.getOwnerParameter().put("sent", "true");
        this.webNotificationStorage.update(notificationInfo, false);
    }

    public boolean isFundRequestSent(String notificationId, String currentUser) throws IllegalAccessException {
        NotificationInfo notificationInfo = this.webNotificationStorage.get(notificationId);
        if (notificationInfo == null) {
            throw new IllegalStateException("Notification with id " + notificationId + " wasn't found");
        }
        if (notificationInfo.getTo() == null || !currentUser.equals(notificationInfo.getTo())) {
            throw new IllegalAccessException("Target user of notification '" + notificationId + "' is different from current user");
        }
        String fundRequestSentString = (String)notificationInfo.getOwnerParameter().get("sent");
        return Boolean.parseBoolean(fundRequestSentString);
    }

    public Set<AccountDetail> listWallets() throws Exception {
        int cacheSize = this.accountDetailCache.getCacheSize();
        if (cacheSize > 0 && (long)cacheSize >= this.walletsCount) {
            List cachedObjects = this.accountDetailCache.getCachedObjects();
            return new HashSet<AccountDetail>(cachedObjects);
        }
        LOG.info((Object)"Retrieve list of wallets");
        HashSet<AccountDetail> wallets = new HashSet<AccountDetail>();
        Map<String, String> usernames = this.getListOfWalletsOfType("user");
        for (Map.Entry<String, String> user : usernames.entrySet()) {
            AccountDetail accountDetail = this.getUserDetails(user.getKey());
            if (accountDetail == null) continue;
            accountDetail.setAddress(user.getValue());
            wallets.add(accountDetail);
        }
        this.walletsCount = this.accountDetailCache.getCacheSize() / 2;
        LOG.info("{} user wallets has been loaded", new Object[]{this.walletsCount});
        Map<String, String> spaces = this.getListOfWalletsOfType("space");
        for (Map.Entry entry : spaces.entrySet()) {
            AccountDetail details = this.getSpaceDetails((String)entry.getKey());
            if (details == null) continue;
            details.setAddress((String)entry.getValue());
            wallets.add(details);
        }
        long spaceWalletsCount = (long)(this.accountDetailCache.getCacheSize() / 2) - this.walletsCount;
        LOG.info("{} space wallets has been loaded", new Object[]{spaceWalletsCount});
        this.walletsCount = this.accountDetailCache.getCacheSize() / 2;
        LOG.info("{} total wallets has been loaded", new Object[]{this.walletsCount});
        return wallets;
    }

    public void saveTransactionDetail(TransactionDetail transactionMessage) {
        GlobalSettings settings = this.getSettings();
        if (settings != null && (transactionMessage.getNetworkId() == null || transactionMessage.getNetworkId() == 0L)) {
            transactionMessage.setNetworkId(settings.getDefaultNetworkId());
        }
        this.setTransactionDetailInCache(transactionMessage);
        AccountDetail senderAccount = null;
        if (StringUtils.isNotBlank((String)transactionMessage.getFrom()) && (senderAccount = this.getAccountDetailsByAddress(transactionMessage.getFrom())) != null) {
            this.saveAccountTransaction(transactionMessage.getNetworkId(), transactionMessage.getFrom(), transactionMessage.getHash(), true);
        }
        if (!transactionMessage.isAdminOperation() && StringUtils.isNotBlank((String)transactionMessage.getTo()) && this.getAccountDetailsByAddress(transactionMessage.getTo()) != null) {
            this.saveAccountTransaction(transactionMessage.getNetworkId(), transactionMessage.getTo(), transactionMessage.getHash(), false);
        }
        String contractAddress = transactionMessage.getContractAddress();
        ContractDetail contractDetail = null;
        if (StringUtils.isBlank((String)contractAddress) && (contractDetail = this.getContractDetail(transactionMessage.getTo(), transactionMessage.getNetworkId())) != null) {
            contractAddress = transactionMessage.getTo();
        }
        if (StringUtils.isNotBlank((String)contractAddress)) {
            if (contractDetail == null) {
                contractDetail = this.getContractDetail(contractAddress, transactionMessage.getNetworkId());
            }
            if (contractDetail != null) {
                boolean saveLabelToContractTransactionsList = transactionMessage.isAdminOperation() || senderAccount == null;
                this.saveAccountTransaction(transactionMessage.getNetworkId(), contractAddress, transactionMessage.getHash(), saveLabelToContractTransactionsList);
            }
        }
    }

    public void setTransactionDetailInCache(TransactionDetail transactionMessage) {
        this.transactionDetailsCache.put((Serializable)((Object)transactionMessage.getHash()), (Object)transactionMessage);
    }

    public TransactionDetail getTransactionDetailFromCache(String transactionHash) {
        TransactionDetail transactionDetail = (TransactionDetail)this.transactionDetailsCache.get((Serializable)((Object)transactionHash));
        return transactionDetail == null ? null : transactionDetail.copy();
    }

    public TransactionDetail removeTransactionDetailFromCache(String hash) {
        return (TransactionDetail)this.transactionDetailsCache.remove((Serializable)((Object)hash));
    }

    public String getContract(String name, String extension) throws IOException {
        try (InputStream abiInputStream = this.getClass().getClassLoader().getResourceAsStream("org/exoplatform/addon/ethereum/wallet/contract/" + name + "." + extension);){
            String string = IOUtils.toString((InputStream)abiInputStream);
            return string;
        }
    }

    public boolean isUserAdmin() {
        return this.userACL.isUserInGroup("/platform/administrators");
    }

    private Map<String, String> getListOfWalletsOfType(String walletType) throws Exception {
        if (StringUtils.isBlank((String)walletType) || !"user".equals(walletType) && !"space".equals(walletType)) {
            throw new IllegalArgumentException("Unrecognized wallet type: " + walletType);
        }
        HashMap<String, String> names = new HashMap<String, String>();
        if ("user".equals(walletType)) {
            int pageSize = 100;
            int current = 0;
            List contexts = null;
            do {
                if ((contexts = this.settingService.getContextsByTypeAndScopeAndSettingName(Context.USER.getName(), Utils.WALLET_SCOPE.getName(), Utils.WALLET_SCOPE.getId(), "ADDONS_ETHEREUM_WALLET_ADDRESS", current, pageSize)) != null && !contexts.isEmpty()) {
                    List usernames = contexts.stream().map(context -> context.getId()).collect(Collectors.toList());
                    for (String username : usernames) {
                        names.put(username, this.getUserAddress(username));
                    }
                }
                current += pageSize;
            } while (contexts != null && contexts.size() == pageSize);
        } else {
            int pageSize = 100;
            int current = 0;
            Space[] spaces = null;
            do {
                ListAccess spacesListAccress;
                if ((spaces = (Space[])(spacesListAccress = this.spaceService.getAllSpacesWithListAccess()).load(current, pageSize)) != null && spaces.length > 0) {
                    for (Space space : spaces) {
                        String spaceId = this.getSpaceId(space);
                        SettingValue spaceAddress = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, spaceId);
                        if (spaceAddress == null || spaceAddress.getValue() == null) continue;
                        names.put(spaceId, spaceAddress.getValue().toString());
                    }
                }
                current += pageSize;
            } while (spaces != null && spaces.length == pageSize);
        }
        return names;
    }

    private void checkDataToUpgrade(String username, UserPreferences userPreferences) {
        try {
            int userDataVersion;
            int n = userDataVersion = userPreferences.getDataVersion() == null ? 0 : userPreferences.getDataVersion();
            if (userDataVersion < 1) {
                if (userPreferences.getDataVersion() < 1) {
                    userPreferences.setDefaultGas(this.defaultSettings.getDefaultGas());
                }
                userPreferences.setDataVersion(1);
                this.saveUserPreferences(username, userPreferences);
                LOG.info("User {} preferences has been upgraded to version {}", new Object[]{username, 1});
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Can't upgrade data of user preferences: " + username), (Throwable)e);
        }
    }

    private void checkDataToUpgrade(GlobalSettings globalSettings) {
        try {
            int globalDataVersion;
            int n = globalDataVersion = globalSettings.getDataVersion() == null ? 0 : globalSettings.getDataVersion();
            if (globalDataVersion < 2) {
                if (globalSettings.getDataVersion() < 1) {
                    globalSettings.setDefaultGas(this.defaultSettings.getDefaultGas());
                }
                if (globalSettings.getDataVersion() < 1) {
                    globalSettings.setMinGasPrice(this.defaultSettings.getMinGasPrice());
                    globalSettings.setNormalGasPrice(this.defaultSettings.getNormalGasPrice());
                    globalSettings.setMaxGasPrice(this.defaultSettings.getMaxGasPrice());
                }
                globalSettings.setDataVersion(2);
                this.saveSettings(globalSettings);
                LOG.info("Global preferences has been upgraded to version {}", new Object[]{2});
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Can't upgrade global settings", (Throwable)e);
        }
    }

    private String getSpaceId(Space space) {
        return space.getGroupId().split("/")[2];
    }

    private String generateSecurityPhrase(AccountDetail accountDetail) throws IllegalAccessException {
        String currentUser = Utils.getCurrentUserId();
        String id = accountDetail.getId();
        String type = accountDetail.getType();
        Context context = null;
        String paramName = null;
        if (StringUtils.equals((String)type, (String)"user") && StringUtils.equals((String)currentUser, (String)id)) {
            context = Context.USER.id(id);
            paramName = "WALLET_BROWSER_PHRASE";
        } else if (StringUtils.equals((String)type, (String)"space")) {
            this.checkCurrentUserIsSpaceManager(id);
            context = Utils.WALLET_CONTEXT;
            paramName = "WALLET_BROWSER_PHRASE" + id;
        } else {
            return null;
        }
        SettingValue browserWalletPhraseValue = this.settingService.get(context, Utils.WALLET_SCOPE, paramName);
        if (browserWalletPhraseValue != null && browserWalletPhraseValue.getValue() != null) {
            return browserWalletPhraseValue.getValue().toString();
        }
        String phrase = RandomStringUtils.random((int)20, (char[])Utils.SIMPLE_CHARS);
        this.settingService.set(context, Utils.WALLET_SCOPE, paramName, SettingValue.create((String)phrase));
        return phrase;
    }

    private String getUserPhrase(String username) {
        SettingValue browserWalletPhraseValue = this.settingService.get(Context.USER.id(username), Utils.WALLET_SCOPE, "WALLET_BROWSER_PHRASE");
        if (browserWalletPhraseValue != null && browserWalletPhraseValue.getValue() != null) {
            return browserWalletPhraseValue.getValue().toString();
        }
        return null;
    }

    private String getSpacePhrase(String spaceId) {
        try {
            boolean isSpaceManager = this.checkCurrentUserIsSpaceManager(spaceId, false);
            if (!isSpaceManager) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        SettingValue browserWalletPhraseValue = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, "WALLET_BROWSER_PHRASE" + spaceId);
        if (browserWalletPhraseValue != null && browserWalletPhraseValue.getValue() != null) {
            return browserWalletPhraseValue.getValue().toString();
        }
        return null;
    }

    private boolean checkCurrentUserIsSpaceManager(String id) throws IllegalAccessException {
        return this.checkCurrentUserIsSpaceManager(id, true);
    }

    private boolean checkCurrentUserIsSpaceManager(String id, boolean throwException) throws IllegalAccessException {
        String currentUserId = Utils.getCurrentUserId();
        Space space = Utils.getSpace(id);
        if (space == null) {
            LOG.warn("Space not found with id '{}'", new Object[]{id});
            throw new IllegalStateException();
        }
        if (!this.spaceService.isManager(space, currentUserId) && !this.spaceService.isSuperManager(currentUserId)) {
            if (throwException) {
                LOG.error("User '{}' attempts to modify wallet address of space '{}'", new Object[]{currentUserId, space.getDisplayName()});
                throw new IllegalAccessException();
            }
            return false;
        }
        return true;
    }

    private AccountDetail getAccountDetailsFromCache(final AccountDetailCacheId accountDetailCacheId) {
        if (accountDetailCacheId == null || StringUtils.isBlank((String)accountDetailCacheId.getAddress()) && StringUtils.isBlank((String)accountDetailCacheId.getId())) {
            LOG.warn((Object)"cache key is mandatory");
            return null;
        }
        final String currentUserId = Utils.getCurrentUserId();
        AccountDetail accountDetails = (AccountDetail)this.accountDetailFutureCache.get((Object)new ServiceContext<AccountDetail>(){

            @Override
            public AccountDetail execute() {
                AccountDetail accountDetail = null;
                if (StringUtils.isNotBlank((String)accountDetailCacheId.getAddress())) {
                    String address = accountDetailCacheId.getAddress();
                    SettingValue walletAddressValue = EthereumWalletService.this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, address);
                    if (walletAddressValue != null && walletAddressValue.getValue() != null) {
                        String idAndType = walletAddressValue.getValue().toString();
                        String id = null;
                        if (idAndType.startsWith("user")) {
                            id = idAndType.replaceFirst("user", "");
                            accountDetail = EthereumWalletService.this.getUserDetails(id);
                        } else if (idAndType.startsWith("space")) {
                            id = idAndType.replaceFirst("space", "");
                            accountDetail = EthereumWalletService.this.getSpaceDetails(id);
                        }
                        if (accountDetail == null) {
                            LOG.info("Can't find the user/space with id {} associated to address {}", new Object[]{id, address});
                        } else {
                            accountDetail.setAddress(address);
                        }
                    }
                } else {
                    if ("user".equals(accountDetailCacheId.getType())) {
                        String id = accountDetailCacheId.getId();
                        Identity identity = EthereumWalletService.this.identityManager.getOrCreateIdentity("organization", id, true);
                        if (identity == null || identity.getProfile() == null) {
                            return null;
                        }
                        String avatarUrl = identity.getProfile().getAvatarUrl();
                        if (StringUtils.isBlank((String)avatarUrl)) {
                            avatarUrl = "/rest/v1/social/users/" + id + "/avatar";
                        }
                        return new AccountDetail(id, identity.getId(), "user", identity.getProfile().getFullName(), EthereumWalletService.this.getUserAddressFromStorage(id), false, identity.isEnable(), avatarUrl);
                    }
                    if ("space".equals(accountDetailCacheId.getType())) {
                        String id = accountDetailCacheId.getId();
                        Space space = Utils.getSpace(id);
                        if (space == null) {
                            return null;
                        }
                        String avatarUrl = space.getAvatarUrl();
                        if (StringUtils.isBlank((String)avatarUrl)) {
                            avatarUrl = "/rest/v1/social/spaces/" + space.getPrettyName() + "/avatar";
                        }
                        return new AccountDetail(id, space.getId(), "space", space.getDisplayName(), EthereumWalletService.this.getSpaceAddressFromStorage(id), EthereumWalletService.this.spaceService.isManager(space, currentUserId) || EthereumWalletService.this.spaceService.isSuperManager(currentUserId), true, avatarUrl);
                    }
                }
                return accountDetail;
            }
        }, (Object)accountDetailCacheId);
        if (accountDetails != null && StringUtils.isBlank((String)accountDetails.getAddress())) {
            this.removeFromCache(accountDetails.getType(), accountDetails.getId());
        }
        if (accountDetails != null && "space".equals(accountDetails.getType())) {
            Space space = Utils.getSpace(accountDetails.getId());
            if (space == null) {
                accountDetails.setSpaceAdministrator(false);
            } else {
                accountDetails.setSpaceAdministrator(this.spaceService.isManager(space, currentUserId) || this.spaceService.isSuperManager(currentUserId));
            }
        }
        return accountDetails;
    }

    private String getUserAddressFromStorage(String id) {
        SettingValue userWalletAddressValue = this.settingService.get(Context.USER.id(id), Utils.WALLET_SCOPE, "ADDONS_ETHEREUM_WALLET_ADDRESS");
        if (userWalletAddressValue != null && userWalletAddressValue.getValue() != null) {
            return userWalletAddressValue.getValue().toString().toLowerCase();
        }
        return null;
    }

    private String getSpaceAddressFromStorage(String id) {
        SettingValue spaceWalletAddressValue = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, id);
        if (spaceWalletAddressValue != null && spaceWalletAddressValue.getValue() != null) {
            return spaceWalletAddressValue.getValue().toString().toLowerCase();
        }
        return null;
    }

    private void removeFromCache(String oldAddress) {
        if (StringUtils.isBlank((String)oldAddress)) {
            LOG.warn((Object)"Enmpty cache key address");
            return;
        }
        this.accountDetailFutureCache.remove((Serializable)new AccountDetailCacheId(oldAddress));
    }

    private void removeFromCache(String type, String id) {
        if (StringUtils.isBlank((String)type) || StringUtils.isBlank((String)id)) {
            LOG.warn("Enmpty cache key: {}/{}", new Object[]{type, id});
            return;
        }
        this.accountDetailFutureCache.remove((Serializable)new AccountDetailCacheId(type, id));
    }

    private void putInCache(AccountDetail details) {
        if (details != null) {
            this.accountDetailCache.putLocal((Serializable)new AccountDetailCacheId(details.getAddress()), (Object)details);
            this.accountDetailCache.putLocal((Serializable)new AccountDetailCacheId(details.getType(), details.getId()), (Object)details);
        }
    }

    public static interface ServiceContext<V> {
        public V execute();
    }
}

