/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.storage;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.dao.WalletAccountDAO;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.model.WalletCacheKey;
import org.exoplatform.addon.ethereum.wallet.storage.AccountStorage;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.picocontainer.Startable;

public class CachedAccountStorage
extends AccountStorage
implements Startable {
    private CacheService cacheService;
    private FutureExoCache<WalletCacheKey, Wallet, Object> walletFutureCache = null;

    public CachedAccountStorage(WalletAccountDAO walletAccountDAO) {
        super(walletAccountDAO);
    }

    public void start() {
        ExoCache walletCache = this.getCacheService().getCacheInstance("wallet.account");
        Loader<WalletCacheKey, Wallet, Object> walletLoader = new Loader<WalletCacheKey, Wallet, Object>(){

            public Wallet retrieve(Object context, WalletCacheKey cacheKey) throws Exception {
                if (StringUtils.isNotBlank((String)cacheKey.getAddress())) {
                    return CachedAccountStorage.super.getWalletByAddress(cacheKey.getAddress());
                }
                return CachedAccountStorage.super.getWalletByIdentityId(cacheKey.getIdentityId());
            }
        };
        this.walletFutureCache = new FutureExoCache((Loader)walletLoader, walletCache);
    }

    @Override
    public Wallet getWalletByAddress(String address) {
        Wallet wallet = (Wallet)this.walletFutureCache.get(null, (Object)new WalletCacheKey(address));
        return wallet == null ? null : wallet.clone();
    }

    @Override
    public Wallet getWalletByIdentityId(long identityId) {
        Wallet wallet = (Wallet)this.walletFutureCache.get(null, (Object)new WalletCacheKey(identityId));
        return wallet == null ? null : wallet.clone();
    }

    @Override
    public void saveWallet(Wallet wallet, boolean isNew) {
        Wallet oldWallet = null;
        if (!isNew) {
            oldWallet = this.getWalletByIdentityId(wallet.getTechnicalId());
        }
        super.saveWallet(wallet, isNew);
        if (oldWallet != null) {
            this.walletFutureCache.remove((Serializable)new WalletCacheKey(oldWallet.getAddress()));
        }
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getTechnicalId()));
    }

    @Override
    public Wallet removeWallet(long identityId) {
        Wallet wallet = super.removeWallet(identityId);
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getAddress()));
        this.walletFutureCache.remove((Serializable)new WalletCacheKey(wallet.getTechnicalId()));
        return wallet;
    }

    public void stop() {
    }

    private CacheService getCacheService() {
        if (this.cacheService == null) {
            this.cacheService = (CacheService)CommonsUtils.getService(CacheService.class);
        }
        return this.cacheService;
    }
}

