/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.model.TransactionDetail;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.model.WalletType;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletAccountService;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletContractService;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.addon.ethereum.wallet.storage.TransactionStorage;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.json.JSONObject;

public class EthereumWalletTransactionService {
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletTransactionService.class);
    private TransactionStorage walletTransactionStorage;
    private EthereumWalletAccountService walletAccountService;
    private EthereumWalletContractService contractService;
    private SpaceService spaceService;
    private ListenerService listenerService;
    private long watchedTreatedTransactionsCount;

    public EthereumWalletTransactionService(EthereumWalletAccountService walletAccountService, TransactionStorage walletTransactionStorage, EthereumWalletContractService contractService) {
        this.walletTransactionStorage = walletTransactionStorage;
        this.walletAccountService = walletAccountService;
        this.contractService = contractService;
    }

    public List<TransactionDetail> getPendingTransactions() {
        return this.walletTransactionStorage.getPendingTransactions();
    }

    public List<TransactionDetail> getTransactions(long networkId, String address, String contractAddress, String hash, int limit, boolean onlyPending, boolean administration, String currentUser) throws IllegalAccessException {
        if (this.contractService.isContract(address, networkId)) {
            return this.getContractTransactions(networkId, address, limit, currentUser);
        }
        return this.getWalletTransactions(networkId, address, contractAddress, hash, limit, onlyPending, administration, currentUser);
    }

    public TransactionDetail getTransactionByHash(String hash, boolean onlyPending) {
        return this.walletTransactionStorage.getTransactionByHash(hash, onlyPending);
    }

    public void saveTransactionDetail(TransactionDetail transactionDetail, String currentUser, boolean transactionMined) throws IllegalAccessException {
        String senderAddress;
        Wallet senderWallet;
        if (!transactionMined && (senderWallet = this.walletAccountService.getWalletByAddress(senderAddress = StringUtils.isBlank((String)transactionDetail.getBy()) ? transactionDetail.getFrom() : transactionDetail.getBy())) != null) {
            this.walletAccountService.checkCanSaveWallet(senderWallet, senderWallet, currentUser);
        }
        this.walletTransactionStorage.saveTransactionDetail(transactionDetail);
        if (transactionMined) {
            this.broadcastNewTransactionEvent(transactionDetail);
        }
    }

    public long getWatchedTreatedTransactionsCount() {
        return this.watchedTreatedTransactionsCount;
    }

    private List<TransactionDetail> getContractTransactions(Long networkId, String contractAddress, int limit, String currentUser) throws IllegalAccessException {
        ContractDetail contractDetail = this.contractService.getContractDetail(contractAddress, networkId);
        if (contractDetail == null) {
            throw new IllegalStateException("Can't find contract with address " + contractAddress);
        }
        if (!Utils.isUserAdmin(currentUser) && !Utils.isUserRewardingAdmin(currentUser)) {
            throw new IllegalAccessException("User " + currentUser + " attempts to access contract transactions with address " + contractAddress);
        }
        List<TransactionDetail> transactionDetails = this.walletTransactionStorage.getContractTransactions(networkId, contractAddress, limit);
        transactionDetails.stream().forEach(transactionDetail -> this.retrieveWalletsDetails((TransactionDetail)transactionDetail, currentUser));
        return transactionDetails;
    }

    private List<TransactionDetail> getWalletTransactions(long networkId, String address, String contractAddress, String hash, int limit, boolean pending, boolean administration, String currentUser) throws IllegalAccessException {
        Wallet wallet = this.walletAccountService.getWalletByAddress(address);
        if (wallet == null) {
            return Collections.emptyList();
        }
        if (!this.walletAccountService.canAccessWallet(wallet, currentUser)) {
            throw new IllegalAccessException("Can't access wallet with address " + address);
        }
        List<TransactionDetail> transactionDetails = this.walletTransactionStorage.getWalletTransactions(networkId, address, contractAddress, hash, limit, pending, administration);
        transactionDetails.stream().forEach(transactionDetail -> this.retrieveWalletsDetails((TransactionDetail)transactionDetail, currentUser));
        return transactionDetails;
    }

    private void retrieveWalletsDetails(TransactionDetail transactionDetail, String currentUser) {
        Wallet senderWallet = this.walletAccountService.getWalletByAddress(transactionDetail.getFrom());
        transactionDetail.setFromWallet(senderWallet);
        if (senderWallet != null) {
            senderWallet.setPassPhrase(null);
        }
        if (StringUtils.isNotBlank((String)transactionDetail.getTo())) {
            Wallet receiverWallet = this.walletAccountService.getWalletByAddress(transactionDetail.getTo());
            if (receiverWallet != null) {
                receiverWallet.setPassPhrase(null);
            }
            transactionDetail.setToWallet(receiverWallet);
        }
        if (StringUtils.isNotBlank((String)transactionDetail.getBy())) {
            Wallet senderWalletBy = this.walletAccountService.getWalletByAddress(transactionDetail.getBy());
            if (senderWalletBy != null) {
                senderWalletBy.setPassPhrase(null);
            }
            transactionDetail.setByWallet(senderWalletBy);
            if (!this.displayTransactionsLabel(senderWalletBy, currentUser)) {
                transactionDetail.setLabel(null);
            }
        } else if (!this.displayTransactionsLabel(senderWallet, currentUser)) {
            transactionDetail.setLabel(null);
        }
    }

    private boolean displayTransactionsLabel(Wallet senderWallet, String currentUserId) {
        if (senderWallet == null) {
            return Utils.isUserAdmin(currentUserId);
        }
        String accountId = senderWallet.getId();
        String accountType = senderWallet.getType();
        if (StringUtils.isBlank((String)accountId) || StringUtils.isBlank((String)accountType)) {
            return Utils.isUserAdmin(currentUserId);
        }
        if (WalletType.isSpace(senderWallet.getType())) {
            if (this.getSpaceService().isSuperManager(currentUserId)) {
                return true;
            }
            Space space = Utils.getSpace(accountId);
            return space != null && this.getSpaceService().isManager(space, currentUserId);
        }
        return StringUtils.equalsIgnoreCase((String)accountId, (String)currentUserId);
    }

    private void broadcastNewTransactionEvent(TransactionDetail transactionDetail) {
        try {
            JSONObject transaction = new JSONObject();
            transaction.put("hash", (Object)transactionDetail.getHash());
            transaction.put("address", (Object)transactionDetail.getFrom());
            transaction.put("status", transactionDetail.isSucceeded());
            this.getListenerService().broadcast("exo.addon.wallet.transaction.mined", null, (Object)transaction);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting transaction mined event: {}", new Object[]{transactionDetail, e});
        }
        ++this.watchedTreatedTransactionsCount;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        }
        return this.spaceService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

