/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.reward.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.addon.ethereum.wallet.reward.model.RewardTeam;
import org.exoplatform.addon.ethereum.wallet.reward.service.RewardTeamService;
import org.exoplatform.addon.ethereum.wallet.reward.service.utils.RewardUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/reward/team")
@RolesAllowed(value={"rewarding", "administrators"})
public class RewardTeamREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RewardTeamREST.class);
    private RewardTeamService rewardTeamService;

    public RewardTeamREST(RewardTeamService rewardTeamService) {
        this.rewardTeamService = rewardTeamService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="list")
    @RolesAllowed(value={"rewarding", "administrators"})
    public Response listTeams() {
        try {
            return Response.ok(this.rewardTeamService.getTeams()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting computed reward", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="remove")
    @RolesAllowed(value={"rewarding", "administrators"})
    public Response removeTeam(@QueryParam(value="id") Long id) {
        if (id == null || id == 0L) {
            return Response.status((int)400).build();
        }
        try {
            RewardTeam team = this.rewardTeamService.removeTeam(id);
            LOG.info("{} removed reward pool {}", new Object[]{RewardUtils.getCurrentUserId(), team.toString()});
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.warn((Object)("Error removing reward pool with id: " + id), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="save")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"rewarding", "administrators"})
    public Response saveTeam(RewardTeam rewardTeam) {
        if (rewardTeam == null) {
            LOG.warn((Object)"Bad request sent to server with empty team");
            return Response.status((int)400).build();
        }
        try {
            rewardTeam = this.rewardTeamService.saveTeam(rewardTeam);
            LOG.info("{} saved reward pool {}", new Object[]{RewardUtils.getCurrentUserId(), rewardTeam.getName()});
            return Response.ok((Object)rewardTeam).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving reward pool", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

