/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.reward.service;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.addon.ethereum.wallet.reward.dao.RewardTeamDAO;
import org.exoplatform.addon.ethereum.wallet.reward.entity.RewardTeamEntity;
import org.exoplatform.addon.ethereum.wallet.reward.model.RewardTeam;
import org.exoplatform.addon.ethereum.wallet.reward.service.utils.RewardUtils;

public class RewardTeamService {
    private RewardTeamDAO rewardTeamDAO;

    public RewardTeamService(RewardTeamDAO rewardTeamDAO) {
        this.rewardTeamDAO = rewardTeamDAO;
    }

    public List<RewardTeam> getTeams() {
        List teamEntities = this.rewardTeamDAO.findAll();
        return teamEntities.stream().map(teamEntity -> RewardUtils.toDTO(teamEntity)).collect(Collectors.toList());
    }

    public RewardTeam saveTeam(RewardTeam rewardTeam) {
        if (rewardTeam == null) {
            throw new IllegalArgumentException("Empty team to save");
        }
        RewardTeamEntity teamEntity = RewardUtils.fromDTO(rewardTeam);
        teamEntity = teamEntity.getId() == null || teamEntity.getId() == 0L ? (RewardTeamEntity)this.rewardTeamDAO.create(teamEntity) : (RewardTeamEntity)this.rewardTeamDAO.update(teamEntity);
        return RewardUtils.toDTO((RewardTeamEntity)this.rewardTeamDAO.find(teamEntity.getId()));
    }

    public RewardTeam removeTeam(Long id) {
        if (id == null || id == 0L) {
            throw new IllegalArgumentException("Team id is required");
        }
        RewardTeamEntity entity = (RewardTeamEntity)this.rewardTeamDAO.find(id);
        if (entity != null) {
            this.rewardTeamDAO.delete(entity);
        }
        return RewardUtils.toDTO(entity);
    }
}

