/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.scheduled;

import java.time.Duration;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.GlobalSettings;
import org.exoplatform.addon.ethereum.wallet.model.TransactionDetail;
import org.exoplatform.addon.ethereum.wallet.service.EthereumClientConnector;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletTransactionService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.web3j.protocol.core.methods.response.Transaction;

@DisallowConcurrentExecution
public class BlockchainTransactionVerifierJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(BlockchainTransactionVerifierJob.class);
    private EthereumWalletService ethereumWalletService;
    private EthereumClientConnector ethereumClientConnector;
    private EthereumWalletTransactionService transactionService;
    private ListenerService listenerService;
    private ExoContainer container;

    public BlockchainTransactionVerifierJob() {
        this((ExoContainer)PortalContainer.getInstance());
    }

    public BlockchainTransactionVerifierJob(ExoContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            GlobalSettings settings = this.getEthereumWalletService().getSettings();
            if (settings == null || settings.getDefaultNetworkId() == null) {
                LOG.debug((Object)"Empty network id on settings, ignore blockchain listening");
                return;
            }
            List<TransactionDetail> pendingTransactions = this.getPendingTransactions(settings.getDefaultNetworkId());
            if (pendingTransactions != null && !pendingTransactions.isEmpty()) {
                LOG.debug("Checking on blockchain the status of {} transactions marked as pending in database", new Object[]{pendingTransactions.size()});
                long pendingTransactionMaxDays = this.getTransactionService().getPendingTransactionMaxDays();
                for (TransactionDetail pendingTransactionDetail : pendingTransactions) {
                    this.verifyTransactionStatusOnBlockchain(pendingTransactionDetail, pendingTransactionMaxDays);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking pending transactions", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    private void verifyTransactionStatusOnBlockchain(TransactionDetail pendingTransactionDetail, long pendingTransactionMaxDays) {
        String hash = pendingTransactionDetail.getHash();
        try {
            String blockHash;
            Transaction transaction = this.getEthereumClientConnector().getTransaction(hash);
            String string = blockHash = transaction == null ? null : transaction.getBlockHash();
            if (!StringUtils.isBlank((String)blockHash) && !StringUtils.equalsIgnoreCase((String)"0x0000000000000000000000000000000000000000000000000000000000000000", (String)blockHash) && transaction.getBlockNumber() != null) {
                this.getListenerService().broadcast("exo.addon.wallet.transaction.loaded", (Object)transaction, null);
            } else if (pendingTransactionMaxDays > 0L) {
                Duration duration;
                long creationTimestamp = pendingTransactionDetail.getTimestamp();
                if (transaction == null && creationTimestamp > 0L && (duration = Duration.ofMillis(System.currentTimeMillis() - creationTimestamp)).toDays() >= pendingTransactionMaxDays) {
                    LOG.info("Transaction '{}' was not found on blockchain for more than '{}' days, so mark it as failed", new Object[]{hash, pendingTransactionMaxDays});
                    this.getListenerService().broadcast("exo.addon.wallet.transaction.loaded", (Object)hash, null);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Error treating pending transaction: {}", new Object[]{hash, e});
        }
    }

    private List<TransactionDetail> getPendingTransactions(long networkId) {
        return this.getTransactionService().getPendingTransactions(networkId);
    }

    private EthereumWalletService getEthereumWalletService() {
        if (this.ethereumWalletService == null) {
            this.ethereumWalletService = (EthereumWalletService)CommonsUtils.getService(EthereumWalletService.class);
        }
        return this.ethereumWalletService;
    }

    private EthereumClientConnector getEthereumClientConnector() {
        if (this.ethereumClientConnector == null) {
            this.ethereumClientConnector = (EthereumClientConnector)CommonsUtils.getService(EthereumClientConnector.class);
        }
        return this.ethereumClientConnector;
    }

    private EthereumWalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (EthereumWalletTransactionService)CommonsUtils.getService(EthereumWalletTransactionService.class);
        }
        return this.transactionService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

