/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.model.FundsRequest;
import org.exoplatform.addon.ethereum.wallet.model.GlobalSettings;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.model.WalletPreferences;
import org.exoplatform.addon.ethereum.wallet.model.WalletType;
import org.exoplatform.addon.ethereum.wallet.service.EthereumClientConnector;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletAccountService;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletContractService;
import org.exoplatform.addon.ethereum.wallet.service.mbean.EthereumWalletServiceManaged;
import org.exoplatform.addon.ethereum.wallet.utils.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.picocontainer.Startable;

@ManagedBy(value=EthereumWalletServiceManaged.class)
public class EthereumWalletService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletService.class);
    private ExoContainer container;
    private EthereumWalletContractService contractService;
    private EthereumWalletAccountService accountService;
    private EthereumClientConnector clientConnector;
    private SettingService settingService;
    private SpaceService spaceService;
    private WebNotificationStorage webNotificationStorage;
    private ListenerService listenerService;
    private GlobalSettings defaultSettings;
    private GlobalSettings storedSettings;

    public EthereumWalletService(EthereumClientConnector clientConnector, EthereumWalletContractService contractService, EthereumWalletAccountService accountService, SettingService settingService, SpaceService spaceService, WebNotificationStorage webNotificationStorage, PortalContainer container, InitParams params) {
        String defaultContractsToDisplay;
        String value;
        this.container = container;
        this.settingService = settingService;
        this.clientConnector = clientConnector;
        this.accountService = accountService;
        this.contractService = contractService;
        this.spaceService = spaceService;
        this.webNotificationStorage = webNotificationStorage;
        this.defaultSettings = new GlobalSettings();
        this.defaultSettings.setDataVersion(2);
        if (params.containsKey((Object)"defaultNetworkId")) {
            value = params.getValueParam("defaultNetworkId").getValue();
            long defaultNetworkId = Long.parseLong(value);
            this.defaultSettings.setDefaultNetworkId(defaultNetworkId);
        }
        if (params.containsKey((Object)"defaultNetworkURL")) {
            String defaultNetworkURL = params.getValueParam("defaultNetworkURL").getValue();
            this.defaultSettings.setProviderURL(defaultNetworkURL);
        }
        if (params.containsKey((Object)"defaultNetworkWSURL")) {
            String defaultNetworkWsURL = params.getValueParam("defaultNetworkWSURL").getValue();
            this.defaultSettings.setWebsocketProviderURL(defaultNetworkWsURL);
        }
        if (params.containsKey((Object)"defaultAccessPermission")) {
            String defaultAccessPermission = params.getValueParam("defaultAccessPermission").getValue();
            this.defaultSettings.setAccessPermission(defaultAccessPermission);
        }
        if (params.containsKey((Object)"defaultGas")) {
            value = params.getValueParam("defaultGas").getValue();
            long defaultGas = Long.parseLong(value);
            this.defaultSettings.setDefaultGas(defaultGas);
        }
        if (params.containsKey((Object)"minGasPrice")) {
            value = params.getValueParam("minGasPrice").getValue();
            long minGasPrice = Long.parseLong(value);
            this.defaultSettings.setMinGasPrice(minGasPrice);
        }
        if (params.containsKey((Object)"normalGasPrice")) {
            value = params.getValueParam("normalGasPrice").getValue();
            long normalGasPrice = Long.parseLong(value);
            this.defaultSettings.setNormalGasPrice(normalGasPrice);
        }
        if (params.containsKey((Object)"maxGasPrice")) {
            value = params.getValueParam("maxGasPrice").getValue();
            long maxGasPrice = Long.parseLong(value);
            this.defaultSettings.setMaxGasPrice(maxGasPrice);
        }
        if (params.containsKey((Object)"defaultContractAddresses") && StringUtils.isNotBlank((String)(defaultContractsToDisplay = params.getValueParam("defaultContractAddresses").getValue()))) {
            Set<String> defaultContracts = Arrays.stream(defaultContractsToDisplay.split(",")).map(contractAddress -> contractAddress.trim().toLowerCase()).filter(contractAddress -> !contractAddress.isEmpty()).collect(Collectors.toSet());
            this.defaultSettings.setDefaultContractsToDisplay(defaultContracts);
        }
    }

    public void start() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            GlobalSettings settings = this.getSettings();
            this.clientConnector.start(settings);
            this.checkDataToUpgrade(settings);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
        this.clientConnector.stop();
    }

    public void saveSettings(GlobalSettings newGlobalSettings) {
        if (newGlobalSettings == null) {
            throw new IllegalArgumentException("globalSettings parameter is mandatory");
        }
        GlobalSettings oldGlobalSettings = this.getSettings();
        this.saveSettings(newGlobalSettings, oldGlobalSettings.getDataVersion());
    }

    public void saveSettings(GlobalSettings newGlobalSettings, Integer dataVersion) {
        if (newGlobalSettings == null) {
            throw new IllegalArgumentException("globalSettings parameter is mandatory");
        }
        GlobalSettings oldGlobalSettings = this.getSettings();
        newGlobalSettings.setDataVersion(dataVersion);
        newGlobalSettings.setUserPreferences(null);
        newGlobalSettings.setContractAbi(null);
        newGlobalSettings.setContractBin(null);
        newGlobalSettings.setWalletEnabled(false);
        newGlobalSettings.setAdmin(false);
        LOG.debug("Saving new global settings", new Object[]{newGlobalSettings.toJSONString(false)});
        this.settingService.set(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, "GLOBAL_SETTINGS", SettingValue.create((String)newGlobalSettings.toJSONString(false)));
        this.storedSettings = null;
        try {
            this.getListenerService().broadcast("exo.addon.wallet.settings.changed", (Object)oldGlobalSettings, (Object)newGlobalSettings);
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while broadcasting wallet settings modification event", (Throwable)e);
        }
    }

    public GlobalSettings getSettings() {
        if (this.storedSettings != null) {
            this.retrieveContractsPreferences(this.storedSettings, this.storedSettings.getDefaultNetworkId());
            return this.storedSettings;
        }
        this.storedSettings = this.getSettings(null);
        return this.storedSettings.clone();
    }

    public GlobalSettings getSettings(Long networkId) {
        GlobalSettings globalSettings = null;
        globalSettings = this.storedSettings == null ? this.getSettings(networkId, null, null) : this.storedSettings.clone();
        if (globalSettings == null) {
            globalSettings = this.defaultSettings.clone();
        }
        if ((networkId == null || networkId == 0L) && globalSettings.getDefaultNetworkId() != null) {
            networkId = globalSettings.getDefaultNetworkId();
        }
        this.retrieveContractsPreferences(globalSettings, networkId);
        return globalSettings;
    }

    public GlobalSettings getSettings(Long networkId, String spaceId, String currentUser) {
        Space space;
        GlobalSettings globalSettings = null;
        if (StringUtils.isBlank((String)currentUser)) {
            return this.getStoredGlobalSettings();
        }
        globalSettings = this.getSettings(networkId);
        globalSettings.setAdmin(Utils.isUserAdmin(currentUser));
        globalSettings.setWalletEnabled(true);
        if (StringUtils.isNotBlank((String)globalSettings.getAccessPermission()) && (space = Utils.getSpace(globalSettings.getAccessPermission())) != null && !this.spaceService.isMember(space, currentUser) && !this.spaceService.isSuperManager(currentUser)) {
            LOG.debug("Wallet is disabled for user {} because he's not member of space {}", new Object[]{currentUser, space.getPrettyName()});
            globalSettings.setWalletEnabled(false);
        }
        Wallet wallet = null;
        if (StringUtils.isNotBlank((String)spaceId)) {
            wallet = this.accountService.getWalletByTypeAndId(WalletType.SPACE.getId(), spaceId, currentUser);
            if (wallet != null && !Utils.canAccessWallet(wallet, currentUser)) {
                LOG.warn("User {} is not allowed to display space wallet {}", new Object[]{currentUser, spaceId});
                globalSettings.setWalletEnabled(false);
            }
        } else {
            wallet = this.accountService.getWalletByTypeAndId(WalletType.USER.getId(), currentUser, currentUser);
        }
        if (wallet != null) {
            globalSettings.setWalletEnabled(globalSettings.isWalletEnabled() && wallet.isEnabled());
        }
        if (globalSettings.isWalletEnabled() || globalSettings.isAdmin()) {
            SettingValue userSettingsValue = this.settingService.get(Context.USER.id(currentUser), Utils.WALLET_SCOPE, "ADDONS_ETHEREUM_WALLET_SETTINGS");
            WalletPreferences userSettings = null;
            if (userSettingsValue != null && userSettingsValue.getValue() != null) {
                userSettings = WalletPreferences.parseStringToObject(userSettingsValue.getValue().toString());
                this.checkDataToUpgrade(currentUser, userSettings);
            } else {
                userSettings = new WalletPreferences();
            }
            globalSettings.setUserPreferences(userSettings);
            if (wallet != null) {
                userSettings.setPhrase(wallet.getPassPhrase());
                userSettings.setWalletAddress(wallet.getAddress());
                userSettings.setWallet(wallet);
            }
            userSettings.setAddresesLabels(this.accountService.getAddressesLabelsVisibleBy(currentUser));
            globalSettings.setContractAbi(this.contractService.getContractAbi());
            globalSettings.setContractBin(this.contractService.getContractBinary());
        }
        return globalSettings;
    }

    public void saveUserPreferences(String currentUser, WalletPreferences userPreferences) {
        if (userPreferences == null) {
            throw new IllegalArgumentException("userPreferences parameter is mandatory");
        }
        this.settingService.set(Context.USER.id(currentUser), Utils.WALLET_SCOPE, "ADDONS_ETHEREUM_WALLET_SETTINGS", SettingValue.create((String)userPreferences.toJSONString()));
    }

    public void requestFunds(FundsRequest fundsRequest) throws IllegalAccessException {
        String currentUser = Utils.getCurrentUserId();
        Wallet requestSender = this.accountService.getWalletByAddress(fundsRequest.getAddress());
        if (requestSender == null) {
            throw new IllegalStateException("Bad request sent to server with unknown sender address");
        }
        String requestSenderId = requestSender.getId();
        String requestSenderType = requestSender.getType();
        if (WalletType.isUser(requestSenderType) && !StringUtils.equals((String)currentUser, (String)requestSenderId)) {
            LOG.warn("Bad request sent to server with invalid sender type or id {} / {}", new Object[]{requestSenderType, requestSenderId});
            throw new IllegalAccessException("Bad request sent to server with invalid sender");
        }
        if (WalletType.isSpace(requestSenderType) && !Utils.isUserSpaceMember(requestSenderId, fundsRequest.getReceipient())) {
            throw new IllegalAccessException("Request sender is not allowed to request funds from space");
        }
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        GlobalSettings settings = this.getSettings();
        if (!StringUtils.isBlank((String)fundsRequest.getContract())) {
            ContractDetail contractDetail = this.contractService.getContractDetail(fundsRequest.getContract(), settings.getDefaultNetworkId());
            if (contractDetail == null) {
                throw new IllegalStateException("Bad request sent to server with invalid contract address (O ly default addresses are permitted)");
            }
            ctx.append(Utils.CONTRACT_DETAILS_PARAMETER, (Object)contractDetail);
        }
        String requestReceipientId = fundsRequest.getReceipient();
        String requestReceipientType = fundsRequest.getReceipientType();
        Wallet requestReceipient = this.accountService.getWalletByTypeAndId(WalletType.getType(requestReceipientType).getId(), requestReceipientId);
        if (requestReceipient == null || requestReceipient.getTechnicalId() == 0L) {
            LOG.warn("Can't find fund request recipient with id {} and type {}", new Object[]{requestReceipientId, requestReceipientType});
        }
        ctx.append(Utils.FUNDS_REQUEST_SENDER_DETAIL_PARAMETER, (Object)this.accountService.getWalletByTypeAndId(WalletType.USER.getId(), Utils.getCurrentUserId()));
        ctx.append(Utils.SENDER_ACCOUNT_DETAIL_PARAMETER, (Object)requestSender);
        ctx.append(Utils.RECEIVER_ACCOUNT_DETAIL_PARAMETER, (Object)requestReceipient);
        ctx.append(Utils.FUNDS_REQUEST_PARAMETER, (Object)fundsRequest);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"FundsRequestNotificationPlugin"))).execute(ctx);
    }

    public void markFundRequestAsSent(String notificationId, String currentUser) throws IllegalAccessException {
        NotificationInfo notificationInfo = this.webNotificationStorage.get(notificationId);
        if (notificationInfo == null) {
            throw new IllegalStateException("Notification with id " + notificationId + " wasn't found");
        }
        if (notificationInfo.getTo() == null || !currentUser.equals(notificationInfo.getTo())) {
            throw new IllegalAccessException("Target user of notification '" + notificationId + "' is different from current user");
        }
        notificationInfo.getOwnerParameter().put("sent", "true");
        this.webNotificationStorage.update(notificationInfo, false);
    }

    public boolean isFundRequestSent(String notificationId, String currentUser) throws IllegalAccessException {
        NotificationInfo notificationInfo = this.webNotificationStorage.get(notificationId);
        if (notificationInfo == null) {
            throw new IllegalStateException("Notification with id " + notificationId + " wasn't found");
        }
        if (notificationInfo.getTo() == null || !currentUser.equals(notificationInfo.getTo())) {
            throw new IllegalAccessException("Target user of notification '" + notificationId + "' is different from current user");
        }
        String fundRequestSentString = (String)notificationInfo.getOwnerParameter().get("sent");
        return Boolean.parseBoolean(fundRequestSentString);
    }

    private GlobalSettings getStoredGlobalSettings() {
        GlobalSettings globalSettings = null;
        SettingValue globalSettingsValue = this.settingService.get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, "GLOBAL_SETTINGS");
        if (globalSettingsValue != null && globalSettingsValue.getValue() != null) {
            globalSettings = GlobalSettings.parseStringToObject(this.defaultSettings, globalSettingsValue.getValue().toString());
        }
        return globalSettings;
    }

    private void retrieveContractsPreferences(GlobalSettings globalSettings, Long networkId) {
        if ((networkId == null || networkId == 0L) && globalSettings.getDefaultNetworkId() != null) {
            networkId = globalSettings.getDefaultNetworkId();
        }
        globalSettings.setDefaultContractsToDisplay(this.contractService.getDefaultContractsAddresses(networkId));
        String defaultPrincipalAccount = globalSettings.getDefaultPrincipalAccount();
        if (StringUtils.isNotBlank((String)defaultPrincipalAccount)) {
            ContractDetail principalContractDetails = this.contractService.getContractDetail(defaultPrincipalAccount, networkId);
            globalSettings.setPrincipalContractAdminAddress(principalContractDetails == null ? null : principalContractDetails.getOwner());
        }
    }

    private void checkDataToUpgrade(String username, WalletPreferences userPreferences) {
        try {
            int userDataVersion;
            int n = userDataVersion = userPreferences.getDataVersion() == null ? 0 : userPreferences.getDataVersion();
            if (userDataVersion < 1) {
                if (userPreferences.getDataVersion() < 1) {
                    userPreferences.setDefaultGas(this.defaultSettings.getDefaultGas());
                }
                userPreferences.setDataVersion(1);
                this.saveUserPreferences(username, userPreferences);
                LOG.info("User {} preferences has been upgraded to version {}", new Object[]{username, 1});
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Can't upgrade data of user preferences: " + username), (Throwable)e);
        }
    }

    private void checkDataToUpgrade(GlobalSettings globalSettings) {
        try {
            int globalDataVersion;
            int n = globalDataVersion = globalSettings.getDataVersion() == null ? 0 : globalSettings.getDataVersion();
            if (globalDataVersion < 2) {
                if (globalSettings.getDataVersion() < 1) {
                    globalSettings.setDefaultGas(this.defaultSettings.getDefaultGas());
                }
                if (globalSettings.getDataVersion() < 1) {
                    globalSettings.setMinGasPrice(this.defaultSettings.getMinGasPrice());
                    globalSettings.setNormalGasPrice(this.defaultSettings.getNormalGasPrice());
                    globalSettings.setMaxGasPrice(this.defaultSettings.getMaxGasPrice());
                }
                this.saveSettings(globalSettings, 2);
                LOG.info("Global preferences has been upgraded to version {}", new Object[]{2});
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Can't upgrade global settings", (Throwable)e);
        }
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

