/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service.mbean;

import org.exoplatform.addon.ethereum.wallet.service.EthereumClientConnector;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.addon.ethereum.wallet.service.WalletAccountService;
import org.exoplatform.addon.ethereum.wallet.service.WalletTransactionService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;

@Managed
@NameTemplate(value={@Property(key="service", value="ethereum"), @Property(key="view", value="wallet")})
@ManagedDescription(value="Ethereum blockchain wallet service")
public class EthereumWalletServiceManaged {
    private EthereumClientConnector clientConnector;
    private WalletAccountService accountService;
    private WalletTransactionService transactionService;

    public EthereumWalletServiceManaged(EthereumWalletService ethereumWalletService) {
    }

    @Managed
    @ManagedDescription(value="Get ethereum blockchain known treated transactions")
    public long getKnownTreatedTransactionsCount() {
        return this.getTransactionService().getWatchedTreatedTransactionsCount();
    }

    @Managed
    @ManagedDescription(value="Get ethereum wallets count")
    public long getWalletsCount() {
        return this.getAccountService().getWalletsCount();
    }

    @Managed
    @ManagedDescription(value="Get ethereum blockchain connection interruption count")
    public int getConnectionInterruptionCount() {
        return this.getClientConnector().getConnectionInterruptionCount();
    }

    public WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    public WalletAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.accountService;
    }

    public EthereumClientConnector getClientConnector() {
        if (this.clientConnector == null) {
            this.clientConnector = (EthereumClientConnector)CommonsUtils.getService(EthereumClientConnector.class);
        }
        return this.clientConnector;
    }
}

