/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.WalletPreferences;
import org.exoplatform.addon.ethereum.wallet.utils.Utils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GlobalSettings
implements Serializable,
Cloneable {
    private static final String USER_WALLET_PARAM = "wallet";
    private static final long serialVersionUID = -4672745644323864680L;
    private static final String CONTRACT_BIN_PARAM = "contractBin";
    private static final String CONTRACT_ABI_PARAM = "contractAbi";
    private static final String DEFAULT_CONTRACTS_TO_DISPLAY_PARAM = "defaultContractsToDisplay";
    private static final String PRINCIPAL_CONTRACT_ADMIN_ADDRESS_PARAM = "principalContractAdminAddress";
    private static final String PRINCIPAL_CONTRACT_ADMIN_NAME_PARAM = "principalContractAdminName";
    private static final String USER_PREFERENCES_PARAM = "userPreferences";
    private static final String USER_HAS_SERVER_KEY_PARAM = "hasKeyOnServerSide";
    private static final String IS_WALLET_ENABLED_PARAM = "isWalletEnabled";
    private static final String IS_ADMIN_PARAM = "isAdmin";
    private static final String DEFAULT_OVERVIEW_ACCOUNTS_PARAM = "defaultOverviewAccounts";
    private static final String DEFAULT_PRINCIPAL_ACCOUNT_PARAM = "defaultPrincipalAccount";
    private static final String INITIAL_FUNDS_PARAM = "initialFunds";
    private static final String DATA_VERSION_PARAM = "dataVersion";
    private static final String MAX_GAS_PRICE_PARAM = "maxGasPrice";
    private static final String NORMAL_GAS_PRICE_PARAM = "normalGasPrice";
    private static final String MIN_GAS_PRICE_PARAM = "minGasPrice";
    private static final String DEFAULT_GAS_PARAM = "defaultGas";
    private static final String DEFAULT_NETWORK_ID_PARAM = "defaultNetworkId";
    private static final String WEBSOCKET_PROVIDER_URL_PARAM = "websocketProviderURL";
    private static final String PROVIDER_URL_PARAM = "providerURL";
    private static final String FUNDS_HOLDER_TYPE_PARAM = "fundsHolderType";
    private static final String FUNDS_HOLDER_PARAM = "fundsHolder";
    private static final String INITIAL_FUNDS_REQUEST_MESSAGE_PARAM = "initialFundsRequestMessage";
    private static final String ACCESS_PERMISSION_PARAM = "accessPermission";
    private static final String ENABLE_DELEGATION_PARAM = "enableDelegation";
    private Integer dataVersion = 0;
    private boolean enableDelegation = false;
    private String accessPermission = null;
    private String fundsHolder = null;
    private String initialFundsRequestMessage = null;
    private String fundsHolderType = null;
    private String providerURL = null;
    private String websocketProviderURL = null;
    private Long defaultNetworkId = 0L;
    private Long defaultGas = 0L;
    private Long minGasPrice = 4000000000L;
    private Long normalGasPrice = 8000000000L;
    private Long maxGasPrice = 15000000000L;
    private String principalContractAdminName = "Admin";
    private String principalContractAdminAddress = null;
    private String defaultPrincipalAccount = null;
    private Set<String> defaultOverviewAccounts;
    private Map<String, Double> initialFunds;
    private boolean walletEnabled = true;
    private boolean isAdmin = false;
    private WalletPreferences userPreferences;
    private Set<String> defaultContractsToDisplay;
    private transient JSONArray contractAbi = null;
    private String contractBin = null;

    public String toJSONString(boolean includeTransient) {
        return this.toJSONObject(includeTransient).toString();
    }

    public JSONObject toJSONObject(boolean includeTransient) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(ENABLE_DELEGATION_PARAM, this.enableDelegation);
            if (StringUtils.isNotBlank((CharSequence)this.accessPermission)) {
                jsonObject.put(ACCESS_PERMISSION_PARAM, (Object)this.accessPermission);
            }
            if (StringUtils.isNotBlank((CharSequence)this.initialFundsRequestMessage)) {
                jsonObject.put(INITIAL_FUNDS_REQUEST_MESSAGE_PARAM, (Object)this.initialFundsRequestMessage);
            }
            if (StringUtils.isNotBlank((CharSequence)this.fundsHolder)) {
                jsonObject.put(FUNDS_HOLDER_PARAM, (Object)this.fundsHolder);
            }
            if (StringUtils.isNotBlank((CharSequence)this.fundsHolderType)) {
                jsonObject.put(FUNDS_HOLDER_TYPE_PARAM, (Object)this.fundsHolderType);
            }
            if (StringUtils.isNotBlank((CharSequence)this.providerURL)) {
                jsonObject.put(PROVIDER_URL_PARAM, (Object)this.providerURL);
            }
            if (StringUtils.isNotBlank((CharSequence)this.websocketProviderURL)) {
                jsonObject.put(WEBSOCKET_PROVIDER_URL_PARAM, (Object)this.websocketProviderURL);
            }
            if (this.defaultNetworkId != null && this.defaultNetworkId != 0L) {
                jsonObject.put(DEFAULT_NETWORK_ID_PARAM, (Object)this.defaultNetworkId);
            }
            if (this.defaultGas != null && this.defaultGas != 0L) {
                jsonObject.put(DEFAULT_GAS_PARAM, (Object)this.defaultGas);
            }
            if (this.minGasPrice != null && this.minGasPrice != 0L) {
                jsonObject.put(MIN_GAS_PRICE_PARAM, (Object)this.minGasPrice);
            }
            if (this.normalGasPrice != null && this.normalGasPrice != 0L) {
                jsonObject.put(NORMAL_GAS_PRICE_PARAM, (Object)this.normalGasPrice);
            }
            if (this.maxGasPrice != null && this.maxGasPrice != 0L) {
                jsonObject.put(MAX_GAS_PRICE_PARAM, (Object)this.maxGasPrice);
            }
            if (this.dataVersion != null && this.dataVersion != 0) {
                jsonObject.put(DATA_VERSION_PARAM, (Object)this.dataVersion);
            }
            if (this.initialFunds != null && !this.initialFunds.isEmpty()) {
                JSONArray array = new JSONArray();
                Set<String> addresses = this.initialFunds.keySet();
                for (String address : addresses) {
                    JSONObject obj = new JSONObject();
                    obj.put("address", (Object)address);
                    obj.put("amount", (Object)this.initialFunds.get(address));
                    array.put((Object)obj);
                }
                jsonObject.put(INITIAL_FUNDS_PARAM, (Object)array);
            }
            if (StringUtils.isNotBlank((CharSequence)this.defaultPrincipalAccount)) {
                jsonObject.put(DEFAULT_PRINCIPAL_ACCOUNT_PARAM, (Object)this.defaultPrincipalAccount);
            }
            if (this.defaultOverviewAccounts != null && !this.defaultOverviewAccounts.isEmpty()) {
                jsonObject.put(DEFAULT_OVERVIEW_ACCOUNTS_PARAM, (Object)new JSONArray(this.defaultOverviewAccounts));
            }
            if (includeTransient) {
                jsonObject.put(IS_ADMIN_PARAM, this.isAdmin);
                jsonObject.put(IS_WALLET_ENABLED_PARAM, this.walletEnabled);
                if (this.userPreferences != null) {
                    JSONObject userPrefsObject = this.userPreferences.toJSONObject();
                    if (this.userPreferences.getWallet() != null) {
                        userPrefsObject.put(USER_WALLET_PARAM, (Object)new JSONObject((Object)this.userPreferences.getWallet()));
                        userPrefsObject.put(USER_HAS_SERVER_KEY_PARAM, this.userPreferences.isHasKeyOnServerSide());
                    }
                    jsonObject.put(USER_PREFERENCES_PARAM, (Object)userPrefsObject);
                }
                if (StringUtils.isNotBlank((CharSequence)this.principalContractAdminName)) {
                    jsonObject.put(PRINCIPAL_CONTRACT_ADMIN_NAME_PARAM, (Object)this.principalContractAdminName);
                }
                if (StringUtils.isNotBlank((CharSequence)this.principalContractAdminAddress)) {
                    jsonObject.put(PRINCIPAL_CONTRACT_ADMIN_ADDRESS_PARAM, (Object)this.principalContractAdminAddress);
                }
                if (this.defaultContractsToDisplay != null && !this.defaultContractsToDisplay.isEmpty()) {
                    jsonObject.put(DEFAULT_CONTRACTS_TO_DISPLAY_PARAM, (Object)new JSONArray(this.defaultContractsToDisplay));
                }
                if (this.contractAbi != null && this.contractAbi.length() > 0) {
                    jsonObject.put(CONTRACT_ABI_PARAM, (Object)this.contractAbi);
                }
                if (StringUtils.isNotBlank((CharSequence)this.contractBin)) {
                    jsonObject.put(CONTRACT_BIN_PARAM, (Object)this.contractBin);
                }
            }
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error while converting Object to JSON", e);
        }
        return jsonObject;
    }

    public String toString() {
        return this.toJSONString(false);
    }

    public static final GlobalSettings parseStringToObject(GlobalSettings defaultSettings, String jsonString) {
        if (defaultSettings == null) {
            defaultSettings = new GlobalSettings();
        }
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return defaultSettings.clone();
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            GlobalSettings globalSettings = new GlobalSettings();
            String storedFundsHolder = jsonObject.has(FUNDS_HOLDER_PARAM) ? jsonObject.getString(FUNDS_HOLDER_PARAM) : defaultSettings.getFundsHolder();
            globalSettings.setFundsHolder(storedFundsHolder);
            String storedFundsHolderType = jsonObject.has(FUNDS_HOLDER_TYPE_PARAM) ? jsonObject.getString(FUNDS_HOLDER_TYPE_PARAM) : defaultSettings.getFundsHolderType();
            globalSettings.setFundsHolderType(storedFundsHolderType);
            Map<String, Double> storedInitialFunds = jsonObject.has(INITIAL_FUNDS_PARAM) ? GlobalSettings.toMap(jsonObject.getJSONArray(INITIAL_FUNDS_PARAM)) : defaultSettings.getInitialFunds();
            globalSettings.setInitialFunds(storedInitialFunds);
            String storedAccessPermission = jsonObject.has(ACCESS_PERMISSION_PARAM) ? jsonObject.getString(ACCESS_PERMISSION_PARAM) : defaultSettings.getAccessPermission();
            globalSettings.setAccessPermission(storedAccessPermission);
            String storedInitialfundsRequestMessage = jsonObject.has(INITIAL_FUNDS_REQUEST_MESSAGE_PARAM) ? jsonObject.getString(INITIAL_FUNDS_REQUEST_MESSAGE_PARAM) : defaultSettings.getInitialFundsRequestMessage();
            globalSettings.setInitialFundsRequestMessage(storedInitialfundsRequestMessage);
            String storedProviderURL = jsonObject.has(PROVIDER_URL_PARAM) ? jsonObject.getString(PROVIDER_URL_PARAM) : defaultSettings.getProviderURL();
            globalSettings.setProviderURL(storedProviderURL);
            String storedWebsocketProviderURL = jsonObject.has(WEBSOCKET_PROVIDER_URL_PARAM) ? jsonObject.getString(WEBSOCKET_PROVIDER_URL_PARAM) : defaultSettings.getWebsocketProviderURL();
            globalSettings.setWebsocketProviderURL(storedWebsocketProviderURL);
            long storedDefaultNetworkId = jsonObject.has(DEFAULT_NETWORK_ID_PARAM) ? jsonObject.getLong(DEFAULT_NETWORK_ID_PARAM) : defaultSettings.getDefaultNetworkId().longValue();
            globalSettings.setDefaultNetworkId(storedDefaultNetworkId);
            long storedDefaultGas = jsonObject.has(DEFAULT_GAS_PARAM) ? jsonObject.getLong(DEFAULT_GAS_PARAM) : defaultSettings.getDefaultGas().longValue();
            globalSettings.setDefaultGas(storedDefaultGas);
            long storedMinGasPrice = jsonObject.has(MIN_GAS_PRICE_PARAM) ? jsonObject.getLong(MIN_GAS_PRICE_PARAM) : defaultSettings.getMinGasPrice().longValue();
            globalSettings.setMinGasPrice(storedMinGasPrice);
            long storedNormalGasPrice = jsonObject.has(NORMAL_GAS_PRICE_PARAM) ? jsonObject.getLong(NORMAL_GAS_PRICE_PARAM) : defaultSettings.getNormalGasPrice().longValue();
            globalSettings.setNormalGasPrice(storedNormalGasPrice);
            long storedMaxGasPrice = jsonObject.has(MAX_GAS_PRICE_PARAM) ? jsonObject.getLong(MAX_GAS_PRICE_PARAM) : defaultSettings.getMaxGasPrice().longValue();
            globalSettings.setMaxGasPrice(storedMaxGasPrice);
            boolean storedEnableDelegation = jsonObject.has(ENABLE_DELEGATION_PARAM) ? jsonObject.getBoolean(ENABLE_DELEGATION_PARAM) : defaultSettings.isEnableDelegation();
            globalSettings.setEnableDelegation(storedEnableDelegation);
            String storedDefaultPrincipalAccount = jsonObject.has(DEFAULT_PRINCIPAL_ACCOUNT_PARAM) ? jsonObject.getString(DEFAULT_PRINCIPAL_ACCOUNT_PARAM) : defaultSettings.getDefaultPrincipalAccount();
            globalSettings.setDefaultPrincipalAccount(storedDefaultPrincipalAccount);
            globalSettings.setDefaultOverviewAccounts(Utils.jsonArrayToList(jsonObject, DEFAULT_OVERVIEW_ACCOUNTS_PARAM));
            globalSettings.setDataVersion(jsonObject.has(DATA_VERSION_PARAM) ? jsonObject.getInt(DATA_VERSION_PARAM) : 0);
            return globalSettings;
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error while converting JSON String to Object", e);
        }
    }

    public static final GlobalSettings parseStringToObject(String jsonString) {
        return GlobalSettings.parseStringToObject(null, jsonString);
    }

    private static Map<String, Double> toMap(JSONArray storedInitialFunds) throws JSONException {
        HashMap<String, Double> map = new HashMap<String, Double>();
        if (storedInitialFunds == null || storedInitialFunds.length() == 0) {
            return map;
        }
        for (int i = 0; i < storedInitialFunds.length(); ++i) {
            JSONObject obj = storedInitialFunds.getJSONObject(i);
            map.put(obj.getString("address"), obj.getDouble("amount"));
        }
        return map;
    }

    public GlobalSettings clone() {
        try {
            GlobalSettings clonedSettings = (GlobalSettings)super.clone();
            clonedSettings.setUserPreferences(this.userPreferences);
            clonedSettings.setAdmin(false);
            clonedSettings.setWalletEnabled(false);
            return clonedSettings;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Can't clone settings");
        }
    }

    public Integer getDataVersion() {
        return this.dataVersion;
    }

    public boolean isEnableDelegation() {
        return this.enableDelegation;
    }

    public String getAccessPermission() {
        return this.accessPermission;
    }

    public String getFundsHolder() {
        return this.fundsHolder;
    }

    public String getInitialFundsRequestMessage() {
        return this.initialFundsRequestMessage;
    }

    public String getFundsHolderType() {
        return this.fundsHolderType;
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public String getWebsocketProviderURL() {
        return this.websocketProviderURL;
    }

    public Long getDefaultNetworkId() {
        return this.defaultNetworkId;
    }

    public Long getDefaultGas() {
        return this.defaultGas;
    }

    public Long getMinGasPrice() {
        return this.minGasPrice;
    }

    public Long getNormalGasPrice() {
        return this.normalGasPrice;
    }

    public Long getMaxGasPrice() {
        return this.maxGasPrice;
    }

    public String getPrincipalContractAdminName() {
        return this.principalContractAdminName;
    }

    public String getPrincipalContractAdminAddress() {
        return this.principalContractAdminAddress;
    }

    public String getDefaultPrincipalAccount() {
        return this.defaultPrincipalAccount;
    }

    public Set<String> getDefaultOverviewAccounts() {
        return this.defaultOverviewAccounts;
    }

    public Map<String, Double> getInitialFunds() {
        return this.initialFunds;
    }

    public boolean isWalletEnabled() {
        return this.walletEnabled;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public WalletPreferences getUserPreferences() {
        return this.userPreferences;
    }

    public Set<String> getDefaultContractsToDisplay() {
        return this.defaultContractsToDisplay;
    }

    public JSONArray getContractAbi() {
        return this.contractAbi;
    }

    public String getContractBin() {
        return this.contractBin;
    }

    public void setDataVersion(Integer dataVersion) {
        this.dataVersion = dataVersion;
    }

    public void setEnableDelegation(boolean enableDelegation) {
        this.enableDelegation = enableDelegation;
    }

    public void setAccessPermission(String accessPermission) {
        this.accessPermission = accessPermission;
    }

    public void setFundsHolder(String fundsHolder) {
        this.fundsHolder = fundsHolder;
    }

    public void setInitialFundsRequestMessage(String initialFundsRequestMessage) {
        this.initialFundsRequestMessage = initialFundsRequestMessage;
    }

    public void setFundsHolderType(String fundsHolderType) {
        this.fundsHolderType = fundsHolderType;
    }

    public void setProviderURL(String providerURL) {
        this.providerURL = providerURL;
    }

    public void setWebsocketProviderURL(String websocketProviderURL) {
        this.websocketProviderURL = websocketProviderURL;
    }

    public void setDefaultNetworkId(Long defaultNetworkId) {
        this.defaultNetworkId = defaultNetworkId;
    }

    public void setDefaultGas(Long defaultGas) {
        this.defaultGas = defaultGas;
    }

    public void setMinGasPrice(Long minGasPrice) {
        this.minGasPrice = minGasPrice;
    }

    public void setNormalGasPrice(Long normalGasPrice) {
        this.normalGasPrice = normalGasPrice;
    }

    public void setMaxGasPrice(Long maxGasPrice) {
        this.maxGasPrice = maxGasPrice;
    }

    public void setPrincipalContractAdminName(String principalContractAdminName) {
        this.principalContractAdminName = principalContractAdminName;
    }

    public void setPrincipalContractAdminAddress(String principalContractAdminAddress) {
        this.principalContractAdminAddress = principalContractAdminAddress;
    }

    public void setDefaultPrincipalAccount(String defaultPrincipalAccount) {
        this.defaultPrincipalAccount = defaultPrincipalAccount;
    }

    public void setDefaultOverviewAccounts(Set<String> defaultOverviewAccounts) {
        this.defaultOverviewAccounts = defaultOverviewAccounts;
    }

    public void setInitialFunds(Map<String, Double> initialFunds) {
        this.initialFunds = initialFunds;
    }

    public void setWalletEnabled(boolean walletEnabled) {
        this.walletEnabled = walletEnabled;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void setUserPreferences(WalletPreferences userPreferences) {
        this.userPreferences = userPreferences;
    }

    public void setDefaultContractsToDisplay(Set<String> defaultContractsToDisplay) {
        this.defaultContractsToDisplay = defaultContractsToDisplay;
    }

    public void setContractAbi(JSONArray contractAbi) {
        this.contractAbi = contractAbi;
    }

    public void setContractBin(String contractBin) {
        this.contractBin = contractBin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalSettings)) {
            return false;
        }
        GlobalSettings other = (GlobalSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$dataVersion = this.getDataVersion();
        Integer other$dataVersion = other.getDataVersion();
        if (this$dataVersion == null ? other$dataVersion != null : !((Object)this$dataVersion).equals(other$dataVersion)) {
            return false;
        }
        if (this.isEnableDelegation() != other.isEnableDelegation()) {
            return false;
        }
        String this$accessPermission = this.getAccessPermission();
        String other$accessPermission = other.getAccessPermission();
        if (this$accessPermission == null ? other$accessPermission != null : !this$accessPermission.equals(other$accessPermission)) {
            return false;
        }
        String this$fundsHolder = this.getFundsHolder();
        String other$fundsHolder = other.getFundsHolder();
        if (this$fundsHolder == null ? other$fundsHolder != null : !this$fundsHolder.equals(other$fundsHolder)) {
            return false;
        }
        String this$initialFundsRequestMessage = this.getInitialFundsRequestMessage();
        String other$initialFundsRequestMessage = other.getInitialFundsRequestMessage();
        if (this$initialFundsRequestMessage == null ? other$initialFundsRequestMessage != null : !this$initialFundsRequestMessage.equals(other$initialFundsRequestMessage)) {
            return false;
        }
        String this$fundsHolderType = this.getFundsHolderType();
        String other$fundsHolderType = other.getFundsHolderType();
        if (this$fundsHolderType == null ? other$fundsHolderType != null : !this$fundsHolderType.equals(other$fundsHolderType)) {
            return false;
        }
        String this$providerURL = this.getProviderURL();
        String other$providerURL = other.getProviderURL();
        if (this$providerURL == null ? other$providerURL != null : !this$providerURL.equals(other$providerURL)) {
            return false;
        }
        String this$websocketProviderURL = this.getWebsocketProviderURL();
        String other$websocketProviderURL = other.getWebsocketProviderURL();
        if (this$websocketProviderURL == null ? other$websocketProviderURL != null : !this$websocketProviderURL.equals(other$websocketProviderURL)) {
            return false;
        }
        Long this$defaultNetworkId = this.getDefaultNetworkId();
        Long other$defaultNetworkId = other.getDefaultNetworkId();
        if (this$defaultNetworkId == null ? other$defaultNetworkId != null : !((Object)this$defaultNetworkId).equals(other$defaultNetworkId)) {
            return false;
        }
        Long this$defaultGas = this.getDefaultGas();
        Long other$defaultGas = other.getDefaultGas();
        if (this$defaultGas == null ? other$defaultGas != null : !((Object)this$defaultGas).equals(other$defaultGas)) {
            return false;
        }
        Long this$minGasPrice = this.getMinGasPrice();
        Long other$minGasPrice = other.getMinGasPrice();
        if (this$minGasPrice == null ? other$minGasPrice != null : !((Object)this$minGasPrice).equals(other$minGasPrice)) {
            return false;
        }
        Long this$normalGasPrice = this.getNormalGasPrice();
        Long other$normalGasPrice = other.getNormalGasPrice();
        if (this$normalGasPrice == null ? other$normalGasPrice != null : !((Object)this$normalGasPrice).equals(other$normalGasPrice)) {
            return false;
        }
        Long this$maxGasPrice = this.getMaxGasPrice();
        Long other$maxGasPrice = other.getMaxGasPrice();
        if (this$maxGasPrice == null ? other$maxGasPrice != null : !((Object)this$maxGasPrice).equals(other$maxGasPrice)) {
            return false;
        }
        String this$principalContractAdminName = this.getPrincipalContractAdminName();
        String other$principalContractAdminName = other.getPrincipalContractAdminName();
        if (this$principalContractAdminName == null ? other$principalContractAdminName != null : !this$principalContractAdminName.equals(other$principalContractAdminName)) {
            return false;
        }
        String this$principalContractAdminAddress = this.getPrincipalContractAdminAddress();
        String other$principalContractAdminAddress = other.getPrincipalContractAdminAddress();
        if (this$principalContractAdminAddress == null ? other$principalContractAdminAddress != null : !this$principalContractAdminAddress.equals(other$principalContractAdminAddress)) {
            return false;
        }
        String this$defaultPrincipalAccount = this.getDefaultPrincipalAccount();
        String other$defaultPrincipalAccount = other.getDefaultPrincipalAccount();
        if (this$defaultPrincipalAccount == null ? other$defaultPrincipalAccount != null : !this$defaultPrincipalAccount.equals(other$defaultPrincipalAccount)) {
            return false;
        }
        Set<String> this$defaultOverviewAccounts = this.getDefaultOverviewAccounts();
        Set<String> other$defaultOverviewAccounts = other.getDefaultOverviewAccounts();
        if (this$defaultOverviewAccounts == null ? other$defaultOverviewAccounts != null : !((Object)this$defaultOverviewAccounts).equals(other$defaultOverviewAccounts)) {
            return false;
        }
        Map<String, Double> this$initialFunds = this.getInitialFunds();
        Map<String, Double> other$initialFunds = other.getInitialFunds();
        if (this$initialFunds == null ? other$initialFunds != null : !((Object)this$initialFunds).equals(other$initialFunds)) {
            return false;
        }
        if (this.isWalletEnabled() != other.isWalletEnabled()) {
            return false;
        }
        if (this.isAdmin() != other.isAdmin()) {
            return false;
        }
        WalletPreferences this$userPreferences = this.getUserPreferences();
        WalletPreferences other$userPreferences = other.getUserPreferences();
        if (this$userPreferences == null ? other$userPreferences != null : !((Object)this$userPreferences).equals(other$userPreferences)) {
            return false;
        }
        Set<String> this$defaultContractsToDisplay = this.getDefaultContractsToDisplay();
        Set<String> other$defaultContractsToDisplay = other.getDefaultContractsToDisplay();
        if (this$defaultContractsToDisplay == null ? other$defaultContractsToDisplay != null : !((Object)this$defaultContractsToDisplay).equals(other$defaultContractsToDisplay)) {
            return false;
        }
        JSONArray this$contractAbi = this.getContractAbi();
        JSONArray other$contractAbi = other.getContractAbi();
        if (this$contractAbi == null ? other$contractAbi != null : !this$contractAbi.equals(other$contractAbi)) {
            return false;
        }
        String this$contractBin = this.getContractBin();
        String other$contractBin = other.getContractBin();
        return !(this$contractBin == null ? other$contractBin != null : !this$contractBin.equals(other$contractBin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $dataVersion = this.getDataVersion();
        result = result * 59 + ($dataVersion == null ? 43 : ((Object)$dataVersion).hashCode());
        result = result * 59 + (this.isEnableDelegation() ? 79 : 97);
        String $accessPermission = this.getAccessPermission();
        result = result * 59 + ($accessPermission == null ? 43 : $accessPermission.hashCode());
        String $fundsHolder = this.getFundsHolder();
        result = result * 59 + ($fundsHolder == null ? 43 : $fundsHolder.hashCode());
        String $initialFundsRequestMessage = this.getInitialFundsRequestMessage();
        result = result * 59 + ($initialFundsRequestMessage == null ? 43 : $initialFundsRequestMessage.hashCode());
        String $fundsHolderType = this.getFundsHolderType();
        result = result * 59 + ($fundsHolderType == null ? 43 : $fundsHolderType.hashCode());
        String $providerURL = this.getProviderURL();
        result = result * 59 + ($providerURL == null ? 43 : $providerURL.hashCode());
        String $websocketProviderURL = this.getWebsocketProviderURL();
        result = result * 59 + ($websocketProviderURL == null ? 43 : $websocketProviderURL.hashCode());
        Long $defaultNetworkId = this.getDefaultNetworkId();
        result = result * 59 + ($defaultNetworkId == null ? 43 : ((Object)$defaultNetworkId).hashCode());
        Long $defaultGas = this.getDefaultGas();
        result = result * 59 + ($defaultGas == null ? 43 : ((Object)$defaultGas).hashCode());
        Long $minGasPrice = this.getMinGasPrice();
        result = result * 59 + ($minGasPrice == null ? 43 : ((Object)$minGasPrice).hashCode());
        Long $normalGasPrice = this.getNormalGasPrice();
        result = result * 59 + ($normalGasPrice == null ? 43 : ((Object)$normalGasPrice).hashCode());
        Long $maxGasPrice = this.getMaxGasPrice();
        result = result * 59 + ($maxGasPrice == null ? 43 : ((Object)$maxGasPrice).hashCode());
        String $principalContractAdminName = this.getPrincipalContractAdminName();
        result = result * 59 + ($principalContractAdminName == null ? 43 : $principalContractAdminName.hashCode());
        String $principalContractAdminAddress = this.getPrincipalContractAdminAddress();
        result = result * 59 + ($principalContractAdminAddress == null ? 43 : $principalContractAdminAddress.hashCode());
        String $defaultPrincipalAccount = this.getDefaultPrincipalAccount();
        result = result * 59 + ($defaultPrincipalAccount == null ? 43 : $defaultPrincipalAccount.hashCode());
        Set<String> $defaultOverviewAccounts = this.getDefaultOverviewAccounts();
        result = result * 59 + ($defaultOverviewAccounts == null ? 43 : ((Object)$defaultOverviewAccounts).hashCode());
        Map<String, Double> $initialFunds = this.getInitialFunds();
        result = result * 59 + ($initialFunds == null ? 43 : ((Object)$initialFunds).hashCode());
        result = result * 59 + (this.isWalletEnabled() ? 79 : 97);
        result = result * 59 + (this.isAdmin() ? 79 : 97);
        WalletPreferences $userPreferences = this.getUserPreferences();
        result = result * 59 + ($userPreferences == null ? 43 : ((Object)$userPreferences).hashCode());
        Set<String> $defaultContractsToDisplay = this.getDefaultContractsToDisplay();
        result = result * 59 + ($defaultContractsToDisplay == null ? 43 : ((Object)$defaultContractsToDisplay).hashCode());
        JSONArray $contractAbi = this.getContractAbi();
        result = result * 59 + ($contractAbi == null ? 43 : $contractAbi.hashCode());
        String $contractBin = this.getContractBin();
        result = result * 59 + ($contractBin == null ? 43 : $contractBin.hashCode());
        return result;
    }
}

