/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.scheduled;

import java.util.Set;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.model.GlobalSettings;
import org.exoplatform.addon.ethereum.wallet.model.TransactionDetail;
import org.exoplatform.addon.ethereum.wallet.service.EthereumClientConnector;
import org.exoplatform.addon.ethereum.wallet.service.EthereumTransactionDecoder;
import org.exoplatform.addon.ethereum.wallet.service.WalletContractService;
import org.exoplatform.addon.ethereum.wallet.service.WalletService;
import org.exoplatform.addon.ethereum.wallet.service.WalletTransactionService;
import org.exoplatform.addon.ethereum.wallet.utils.Utils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class ContractTransactionVerifierJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(ContractTransactionVerifierJob.class);
    private ExoContainer container;
    private EthereumClientConnector ethereumClientConnector;
    private EthereumTransactionDecoder ethereumTransactionDecoder;
    private WalletService walletService;
    private WalletContractService contractService;
    private WalletTransactionService transactionService;
    private SettingService settingService;

    public ContractTransactionVerifierJob() {
        this((ExoContainer)PortalContainer.getInstance());
    }

    public ContractTransactionVerifierJob(ExoContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            long lastWatchedBlockNumber;
            GlobalSettings settings = this.getWalletService().getSettings();
            if (settings == null || settings.getDefaultNetworkId() == null) {
                LOG.debug((Object)"Empty network id on settings, ignore blockchain listening");
                return;
            }
            Long networkId = settings.getDefaultNetworkId();
            Set defaultContractsAddresses = this.getContractService().getDefaultContractsAddresses(networkId);
            if (defaultContractsAddresses == null || defaultContractsAddresses.isEmpty()) {
                LOG.debug((Object)"Empty contracts list in settings");
                return;
            }
            long lastEthereumBlockNumber = this.getEthereumClientConnector().getLastestBlockNumber();
            if (lastEthereumBlockNumber <= (lastWatchedBlockNumber = this.getLastWatchedBlockNumber(networkId))) {
                LOG.debug("No new blocks to verify. last watched = {}. last blockchain block = {}", new Object[]{lastWatchedBlockNumber, lastEthereumBlockNumber});
                return;
            }
            boolean processed = true;
            for (String contractsAddress : defaultContractsAddresses) {
                Set<String> transactionHashes = this.getEthereumClientConnector().getContractTransactions(contractsAddress, lastWatchedBlockNumber, lastEthereumBlockNumber);
                LOG.debug("{} transactions has been found on contract {} between block {} and {}", new Object[]{transactionHashes.size(), contractsAddress, lastWatchedBlockNumber, lastEthereumBlockNumber});
                ContractDetail contractDetail = this.getContractService().getContractDetail(contractsAddress, networkId);
                int treatedTransactionsCount = 0;
                for (String transactionHash : transactionHashes) {
                    TransactionDetail transactionDetail = this.getTransactionService().getTransactionByHash(transactionHash);
                    if (transactionDetail != null) {
                        LOG.debug(" - transaction {} already exists on database, ignore it.", new Object[]{transactionHash});
                        continue;
                    }
                    processed = this.processTransaction(networkId, transactionHash, contractDetail) && processed;
                    if (!processed) continue;
                    ++treatedTransactionsCount;
                }
                LOG.debug("{} transactions has been added on database using contract {} between block {} and {}", new Object[]{treatedTransactionsCount, contractsAddress, lastWatchedBlockNumber, lastEthereumBlockNumber});
            }
            if (processed) {
                this.saveLastWatchedBlockNumber(networkId, lastEthereumBlockNumber);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking pending transactions", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    private boolean processTransaction(Long networkId, String transactionHash, ContractDetail contractDetail) {
        boolean processed = true;
        try {
            LOG.debug(" - treating transaction {} that doesn't exist on database.", new Object[]{transactionHash});
            TransactionDetail transactionDetail = this.getEthereumTransactionDecoder().computeTransactionDetail(networkId, transactionHash, contractDetail);
            if (transactionDetail == null) {
                throw new IllegalStateException("Empty transaction detail is returned");
            }
            LOG.info("Saving new transaction that wasn't managed by UI: {}", new Object[]{transactionDetail});
            this.getTransactionService().saveTransactionDetail(transactionDetail, true);
        }
        catch (Exception e) {
            processed = false;
            LOG.warn("Error processing transaction {}. It will be retried next time.", new Object[]{transactionHash, e});
        }
        return processed;
    }

    private long getLastWatchedBlockNumber(long networkId) {
        SettingValue lastBlockNumberValue = this.getSettingService().get(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER" + networkId);
        if (lastBlockNumberValue != null && lastBlockNumberValue.getValue() != null) {
            return Long.valueOf(lastBlockNumberValue.getValue().toString());
        }
        return 0L;
    }

    private void saveLastWatchedBlockNumber(long networkId, long lastWatchedBlockNumber) {
        LOG.debug("Save watched block number {} on network {}", new Object[]{lastWatchedBlockNumber, networkId});
        this.getSettingService().set(Utils.WALLET_CONTEXT, Utils.WALLET_SCOPE, "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER" + networkId, SettingValue.create((Long)lastWatchedBlockNumber));
    }

    private WalletService getWalletService() {
        if (this.walletService == null) {
            this.walletService = (WalletService)CommonsUtils.getService(WalletService.class);
        }
        return this.walletService;
    }

    private WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    private WalletContractService getContractService() {
        if (this.contractService == null) {
            this.contractService = (WalletContractService)CommonsUtils.getService(WalletContractService.class);
        }
        return this.contractService;
    }

    private EthereumTransactionDecoder getEthereumTransactionDecoder() {
        if (this.ethereumTransactionDecoder == null) {
            this.ethereumTransactionDecoder = (EthereumTransactionDecoder)CommonsUtils.getService(EthereumTransactionDecoder.class);
        }
        return this.ethereumTransactionDecoder;
    }

    private EthereumClientConnector getEthereumClientConnector() {
        if (this.ethereumClientConnector == null) {
            this.ethereumClientConnector = (EthereumClientConnector)CommonsUtils.getService(EthereumClientConnector.class);
        }
        return this.ethereumClientConnector;
    }

    private SettingService getSettingService() {
        if (this.settingService == null) {
            this.settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        }
        return this.settingService;
    }
}

