/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.reward.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.reward.api.RewardPlugin;
import org.exoplatform.addon.ethereum.wallet.reward.model.RewardBudgetType;
import org.exoplatform.addon.ethereum.wallet.reward.model.RewardPluginSettings;
import org.exoplatform.addon.ethereum.wallet.reward.model.RewardSettings;
import org.exoplatform.addon.ethereum.wallet.reward.service.utils.RewardUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.ws.frameworks.json.impl.JsonException;

public class RewardSettingsService {
    private SettingService settingService;
    private RewardSettings rewardSettings;
    private Map<String, RewardPlugin> rewardPlugins = new HashMap<String, RewardPlugin>();

    public RewardSettingsService(SettingService settingService) {
        this.settingService = settingService;
    }

    public RewardSettings getSettings() throws JsonException {
        Set<String> configuredPluginIds;
        Set<RewardPluginSettings> pluginSettings;
        if (this.rewardSettings != null) {
            return this.rewardSettings.clone();
        }
        SettingValue settingsValue = this.settingService.get(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, "REWARD_SETTINGS");
        String settingsValueString = settingsValue == null || settingsValue.getValue() == null ? null : settingsValue.getValue().toString();
        RewardSettings storedRewardSettings = RewardUtils.fromJsonString(settingsValueString, RewardSettings.class);
        if (storedRewardSettings == null) {
            storedRewardSettings = new RewardSettings();
        }
        if ((pluginSettings = storedRewardSettings.getPluginSettings()) == null) {
            pluginSettings = new HashSet<RewardPluginSettings>();
            storedRewardSettings.setPluginSettings(pluginSettings);
        }
        if (!(configuredPluginIds = this.rewardPlugins.keySet()).isEmpty()) {
            for (String configuredPluginId : configuredPluginIds) {
                if (!pluginSettings.stream().noneMatch(plugin -> StringUtils.equals((CharSequence)plugin.getPluginId(), (CharSequence)configuredPluginId))) continue;
                RewardPluginSettings emptyRewardSettings = new RewardPluginSettings();
                emptyRewardSettings.setPluginId(configuredPluginId);
                pluginSettings.add(emptyRewardSettings);
            }
        }
        for (RewardPluginSettings rewardPluginSettings : pluginSettings) {
            if (rewardPluginSettings == null) continue;
            String pluginId = rewardPluginSettings.getPluginId();
            RewardPlugin rewardPlugin = this.getRewardPlugin(pluginId);
            boolean enabled = false;
            if (rewardPlugin != null) {
                enabled = rewardPlugin.isEnabled();
            }
            rewardPluginSettings.setEnabled(enabled);
        }
        this.rewardSettings = storedRewardSettings;
        return this.rewardSettings;
    }

    public void saveSettings(RewardSettings rewardSettingsToStore) throws JsonException {
        if (rewardSettingsToStore == null) {
            throw new IllegalArgumentException("Empty settings to save");
        }
        Set<RewardPluginSettings> pluginSettings = rewardSettingsToStore.getPluginSettings();
        if (pluginSettings != null && !pluginSettings.isEmpty()) {
            for (RewardPluginSettings rewardPluginSettings : pluginSettings) {
                if (rewardPluginSettings.getBudgetType() != RewardBudgetType.FIXED_PER_POINT) continue;
                rewardPluginSettings.setUsePools(false);
            }
        }
        String settingsString = RewardUtils.toJsonString(rewardSettingsToStore);
        this.settingService.set(RewardUtils.REWARD_CONTEXT, RewardUtils.REWARD_SCOPE, "REWARD_SETTINGS", SettingValue.create((String)settingsString));
        this.rewardSettings = null;
    }

    public Collection<RewardPlugin> getRewardPlugins() {
        return this.rewardPlugins.values();
    }

    public RewardPlugin getRewardPlugin(String pluginId) {
        return this.rewardPlugins.get(pluginId);
    }

    public void registerPlugin(RewardPlugin rewardPlugin) {
        this.rewardPlugins.put(rewardPlugin.getPluginId(), rewardPlugin);
    }
}

