/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.reward.plugin;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.exoplatform.addon.ethereum.wallet.reward.api.RewardPlugin;
import org.exoplatform.addon.ethereum.wallet.utils.RewardUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Component;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GamificationRewardPlugin
extends RewardPlugin {
    private static final Log LOG = ExoLogger.getLogger(GamificationRewardPlugin.class);
    private static final String GAMIFICATION_SERVICE_FQN = "org.exoplatform.addons.gamification.service.effective.GamificationService";
    private static final String FIND_USER_POINTS_METHOD_NAME = "findUserReputationScoreBetweenDate";
    private ConfigurationManager configurationManager;
    private ExoContainer container;
    private Object serviceInstance;
    private Method retrievePointsMethod;
    private boolean enabled;

    public GamificationRewardPlugin(PortalContainer container, ConfigurationManager configurationManager) {
        this.container = container;
        this.configurationManager = configurationManager;
        Component component = this.configurationManager.getComponent(GAMIFICATION_SERVICE_FQN);
        this.enabled = component != null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Map<Long, Double> gtEarnedPoints(Set<Long> identityIds, long startDateInSeconds, long endDateInSeconds) {
        HashMap<Long, Double> earnedPoints = new HashMap<Long, Double>();
        if (identityIds == null || identityIds.isEmpty()) {
            return earnedPoints;
        }
        Date startDate = new Date(startDateInSeconds * 1000L);
        Date endDate = new Date(endDateInSeconds * 1000L);
        Method method = this.getMethod();
        if (method == null) {
            throw new IllegalStateException("Can't find gamification service method to retrieve user points");
        }
        for (Long identityId : identityIds) {
            long points = 0L;
            try {
                points = (Long)method.invoke(this.getService(), String.valueOf(identityId), startDate, endDate);
            }
            catch (Exception e) {
                LOG.warn("Error getting gamification points for user with id {}", new Object[]{identityId, e});
            }
            earnedPoints.put(identityId, Double.valueOf(points));
        }
        return earnedPoints;
    }

    private Method getMethod() {
        if (this.retrievePointsMethod != null) {
            return this.retrievePointsMethod;
        }
        this.retrievePointsMethod = RewardUtils.getMethod((ExoContainer)this.container, (String)GAMIFICATION_SERVICE_FQN, (String)FIND_USER_POINTS_METHOD_NAME);
        return this.retrievePointsMethod;
    }

    private Object getService() {
        if (this.serviceInstance != null) {
            return this.serviceInstance;
        }
        this.serviceInstance = RewardUtils.getService((ExoContainer)this.container, (String)GAMIFICATION_SERVICE_FQN);
        return this.serviceInstance;
    }
}

