/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.listener;

import java.util.Map;
import java.util.Set;
import org.exoplatform.addon.ethereum.wallet.model.AccountDetail;
import org.exoplatform.addon.ethereum.wallet.model.FundsRequest;
import org.exoplatform.addon.ethereum.wallet.model.GlobalSettings;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

public class NewAddressAssociationListener
extends Listener<Object, AccountDetail> {
    private EthereumWalletService ethereumWalletService;

    public NewAddressAssociationListener(EthereumWalletService ethereumWalletService) {
        this.ethereumWalletService = ethereumWalletService;
    }

    public void onEvent(Event<Object, AccountDetail> event) throws Exception {
        AccountDetail accountDetail = (AccountDetail)event.getData();
        if (accountDetail == null || !"user".equals(accountDetail.getType())) {
            return;
        }
        GlobalSettings settings = this.ethereumWalletService.getSettings();
        Map<String, Double> initialFunds = settings.getInitialFunds();
        if (initialFunds == null || initialFunds.isEmpty() || settings.getFundsHolder() == null || settings.getFundsHolder().isEmpty() || accountDetail.getId() == null || settings.getFundsHolder().equals(accountDetail.getId())) {
            return;
        }
        Set<String> addresses = initialFunds.keySet();
        for (String address : addresses) {
            Double amount = initialFunds.get(address);
            if (amount == null || amount == 0.0) continue;
            FundsRequest request = new FundsRequest();
            if (!"ether".equals(address)) {
                if (!settings.getDefaultContractsToDisplay().contains(address)) continue;
                request.setContract(address);
            }
            request.setAmount(amount);
            request.setAddress(accountDetail.getAddress());
            request.setReceipient(settings.getFundsHolder());
            request.setReceipientType(settings.getFundsHolderType());
            request.setMessage(settings.getInitialFundsRequestMessage());
            this.ethereumWalletService.requestFunds(request);
        }
    }
}

