/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.listener;

import org.exoplatform.addon.ethereum.wallet.model.GlobalSettings;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

@Asynchronous
public class EthereumLastWatchedBlockListener
extends Listener<Long, Object> {
    private EthereumWalletService ethereumWalletService;
    private ExoContainer container;
    private long lastSavedBlockNumber = 0L;
    private long networkId = 0L;

    public EthereumLastWatchedBlockListener(ExoContainer container, EthereumWalletService ethereumWalletService) {
        this.ethereumWalletService = ethereumWalletService;
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Long, Object> event) throws Exception {
        Long blockNumber = (Long)event.getSource();
        if (blockNumber == null) {
            return;
        }
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            GlobalSettings globalSettings = this.ethereumWalletService.getSettings();
            long networkId = globalSettings.getDefaultNetworkId();
            if (networkId != this.networkId || blockNumber > this.lastSavedBlockNumber) {
                this.lastSavedBlockNumber = blockNumber;
                this.networkId = networkId;
                this.ethereumWalletService.saveLastWatchedBlockNumber(networkId, blockNumber);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

