// Generated by delombok at Mon Nov 19 11:21:18 UTC 2018
package org.exoplatform.addon.ethereum.wallet.model;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import lombok.*;

public class ContractDetail implements Serializable {
  private static final long serialVersionUID = 1459881604949041768L;
  private String address;
  private String name;
  private String symbol;
  private Integer decimals;
  private Long networkId;
  private String owner;
  private String sellPrice;
  private String contractType;

  public String toJSONString() {
    return toJSONObject().toString();
  }

  public JSONObject toJSONObject() {
    JSONObject jsonObject = new JSONObject();
    try {
      jsonObject.put("address", address);
      jsonObject.put("name", name);
      jsonObject.put("symbol", symbol);
      jsonObject.put("decimals", decimals);
      jsonObject.put("networkId", networkId);
      jsonObject.put("owner", owner);
      jsonObject.put("sellPrice", sellPrice);
      jsonObject.put("contractType", contractType);
    } catch (JSONException e) {
      throw new RuntimeException("Error while converting Object to JSON", e);
    }
    return jsonObject;
  }

  public static final ContractDetail parseStringToObject(String jsonString) {
    if (StringUtils.isBlank(jsonString)) {
      return null;
    }
    try {
      JSONObject jsonObject = new JSONObject(jsonString);
      ContractDetail contractDetail = new ContractDetail();
      contractDetail.setNetworkId(jsonObject.getLong("networkId"));
      contractDetail.setAddress(jsonObject.getString("address"));
      contractDetail.setName(jsonObject.getString("name"));
      contractDetail.setSymbol(jsonObject.getString("symbol"));
      contractDetail.setDecimals(jsonObject.has("decimals") ? jsonObject.getInt("decimals") : 0);
      contractDetail.setOwner(jsonObject.has("owner") ? jsonObject.getString("owner") : null);
      contractDetail.setSellPrice(jsonObject.has("sellPrice") ? jsonObject.getString("sellPrice") : null);
      contractDetail.setContractType(jsonObject.has("contractType") ? jsonObject.getString("contractType") : null);
      return contractDetail;
    } catch (JSONException e) {
      throw new RuntimeException("Error while converting JSON String to Object", e);
    }
  }

  @Override
  public String toString() {
    return toJSONString();
  }

  @java.lang.SuppressWarnings("all")
  public String getAddress() {
    return this.address;
  }

  @java.lang.SuppressWarnings("all")
  public String getName() {
    return this.name;
  }

  @java.lang.SuppressWarnings("all")
  public String getSymbol() {
    return this.symbol;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getDecimals() {
    return this.decimals;
  }

  @java.lang.SuppressWarnings("all")
  public Long getNetworkId() {
    return this.networkId;
  }

  @java.lang.SuppressWarnings("all")
  public String getOwner() {
    return this.owner;
  }

  @java.lang.SuppressWarnings("all")
  public String getSellPrice() {
    return this.sellPrice;
  }

  @java.lang.SuppressWarnings("all")
  public String getContractType() {
    return this.contractType;
  }

  @java.lang.SuppressWarnings("all")
  public void setAddress(final String address) {
    this.address = address;
  }

  @java.lang.SuppressWarnings("all")
  public void setName(final String name) {
    this.name = name;
  }

  @java.lang.SuppressWarnings("all")
  public void setSymbol(final String symbol) {
    this.symbol = symbol;
  }

  @java.lang.SuppressWarnings("all")
  public void setDecimals(final Integer decimals) {
    this.decimals = decimals;
  }

  @java.lang.SuppressWarnings("all")
  public void setNetworkId(final Long networkId) {
    this.networkId = networkId;
  }

  @java.lang.SuppressWarnings("all")
  public void setOwner(final String owner) {
    this.owner = owner;
  }

  @java.lang.SuppressWarnings("all")
  public void setSellPrice(final String sellPrice) {
    this.sellPrice = sellPrice;
  }

  @java.lang.SuppressWarnings("all")
  public void setContractType(final String contractType) {
    this.contractType = contractType;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ContractDetail)) return false;
    final ContractDetail other = (ContractDetail) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$address = this.getAddress();
    final java.lang.Object other$address = other.getAddress();
    if (this$address == null ? other$address != null : !this$address.equals(other$address)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    final java.lang.Object this$symbol = this.getSymbol();
    final java.lang.Object other$symbol = other.getSymbol();
    if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) return false;
    final java.lang.Object this$decimals = this.getDecimals();
    final java.lang.Object other$decimals = other.getDecimals();
    if (this$decimals == null ? other$decimals != null : !this$decimals.equals(other$decimals)) return false;
    final java.lang.Object this$networkId = this.getNetworkId();
    final java.lang.Object other$networkId = other.getNetworkId();
    if (this$networkId == null ? other$networkId != null : !this$networkId.equals(other$networkId)) return false;
    final java.lang.Object this$owner = this.getOwner();
    final java.lang.Object other$owner = other.getOwner();
    if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) return false;
    final java.lang.Object this$sellPrice = this.getSellPrice();
    final java.lang.Object other$sellPrice = other.getSellPrice();
    if (this$sellPrice == null ? other$sellPrice != null : !this$sellPrice.equals(other$sellPrice)) return false;
    final java.lang.Object this$contractType = this.getContractType();
    final java.lang.Object other$contractType = other.getContractType();
    if (this$contractType == null ? other$contractType != null : !this$contractType.equals(other$contractType)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ContractDetail;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $address = this.getAddress();
    result = result * PRIME + ($address == null ? 43 : $address.hashCode());
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    final java.lang.Object $symbol = this.getSymbol();
    result = result * PRIME + ($symbol == null ? 43 : $symbol.hashCode());
    final java.lang.Object $decimals = this.getDecimals();
    result = result * PRIME + ($decimals == null ? 43 : $decimals.hashCode());
    final java.lang.Object $networkId = this.getNetworkId();
    result = result * PRIME + ($networkId == null ? 43 : $networkId.hashCode());
    final java.lang.Object $owner = this.getOwner();
    result = result * PRIME + ($owner == null ? 43 : $owner.hashCode());
    final java.lang.Object $sellPrice = this.getSellPrice();
    result = result * PRIME + ($sellPrice == null ? 43 : $sellPrice.hashCode());
    final java.lang.Object $contractType = this.getContractType();
    result = result * PRIME + ($contractType == null ? 43 : $contractType.hashCode());
    return result;
  }

  @java.lang.SuppressWarnings("all")
  public ContractDetail(final String address, final String name, final String symbol, final Integer decimals, final Long networkId, final String owner, final String sellPrice, final String contractType) {
    this.address = address;
    this.name = name;
    this.symbol = symbol;
    this.decimals = decimals;
    this.networkId = networkId;
    this.owner = owner;
    this.sellPrice = sellPrice;
    this.contractType = contractType;
  }

  @java.lang.SuppressWarnings("all")
  public ContractDetail() {
  }
}
